/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.entities.IAnimPacketSync;
import com.ma.network.messages.BaseMessage;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class EntityStateMessage
extends BaseMessage {
    private CompoundNBT data;
    private int entityID;

    private EntityStateMessage(int entityID, CompoundNBT nbt) {
        this.data = nbt;
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    private EntityStateMessage() {
        this.messageIsValid = false;
    }

    public CompoundNBT getData() {
        return this.data;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static EntityStateMessage decode(PacketBuffer buf) {
        EntityStateMessage msg = new EntityStateMessage();
        try {
            msg.entityID = buf.readInt();
            msg.data = buf.func_150793_b();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading EntityStateMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(EntityStateMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.getEntityID());
        buf.func_150786_a(msg.getData());
    }

    public static EntityStateMessage fromEntity(IAnimPacketSync<? extends Entity> entity) {
        EntityStateMessage msg = new EntityStateMessage(((Entity)entity).func_145782_y(), entity.getPacketData());
        return msg;
    }
}

