/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.handlers;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.blocks.tileentities.ArcaneSentryTile;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.blocks.tileentities.LodestarTile;
import com.ma.blocks.tileentities.ManaweavingAltarTile;
import com.ma.blocks.tileentities.RunescribingTableTile;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectHelper;
import com.ma.enchantments.EnchantmentInit;
import com.ma.entities.EntityInit;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.entities.utility.EntityEldrinFlight;
import com.ma.events.EventDispatcher;
import com.ma.gui.containers.block.ContainerMagiciansWorkbench;
import com.ma.gui.containers.entity.ContainerWanderingWizard;
import com.ma.gui.containers.providers.NamedSpellCustomization;
import com.ma.items.IRadialInventorySelect;
import com.ma.items.ItemInit;
import com.ma.items.artifice.ItemEnderDisk;
import com.ma.items.manaweaving.ItemManaweaverWand;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.sorcery.ItemBookOfRote;
import com.ma.items.sorcery.ItemModifierBook;
import com.ma.items.sorcery.ItemSpell;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.items.sorcery.ItemStaff;
import com.ma.network.ServerMessageDispatcher;
import com.ma.network.messages.BaseMessage;
import com.ma.network.messages.to_server.AnimatedConstructSyncRequestMessage;
import com.ma.network.messages.to_server.ArcaneSentryTargetPlayersMessage;
import com.ma.network.messages.to_server.CantripPatternUpdateMessage;
import com.ma.network.messages.to_server.ConstructHornMessage;
import com.ma.network.messages.to_server.EndControlEffectEarlyMessage;
import com.ma.network.messages.to_server.EnderDiscIndexSetMessage;
import com.ma.network.messages.to_server.EnderDiscPatternSetMessage;
import com.ma.network.messages.to_server.InscriptionTableAttributeChangeMessage;
import com.ma.network.messages.to_server.InscriptionTableRequestStartCraftingMessage;
import com.ma.network.messages.to_server.InscriptionTableSetComponentMessage;
import com.ma.network.messages.to_server.InscriptionTableSetModifierMessage;
import com.ma.network.messages.to_server.InscriptionTableSetShapeMessage;
import com.ma.network.messages.to_server.LodestarGUIActionMessage;
import com.ma.network.messages.to_server.MAPFXSyncRequestMessage;
import com.ma.network.messages.to_server.MagiciansWorkbenchClearMessage;
import com.ma.network.messages.to_server.MagiciansWorkbenchRecipeSetMessage;
import com.ma.network.messages.to_server.ManaweavePatternDrawnMessage;
import com.ma.network.messages.to_server.MultiblockSyncRequestMessage;
import com.ma.network.messages.to_server.OpenSpellRenameMessage;
import com.ma.network.messages.to_server.PlayerBounceMessage;
import com.ma.network.messages.to_server.PlayerJumpMessage;
import com.ma.network.messages.to_server.PossessionInputMessage;
import com.ma.network.messages.to_server.RadialInventorySlotChangeMessage;
import com.ma.network.messages.to_server.RequestWellspringPowerNetworkSyncMessage;
import com.ma.network.messages.to_server.RitualKitIndexSetMessage;
import com.ma.network.messages.to_server.RoteSpellsSyncMessageToServer;
import com.ma.network.messages.to_server.RunescribingTableMutexChangeMessage;
import com.ma.network.messages.to_server.SelectedModifierMessage;
import com.ma.network.messages.to_server.SpellAdjustmentsMessage;
import com.ma.network.messages.to_server.SpellBookSlotChangeMessage;
import com.ma.network.messages.to_server.SpellNameAndIconMessage;
import com.ma.network.messages.to_server.TradeSelectedMessage;
import com.ma.network.messages.to_server.UIModifierPress;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.multiblock.MultiblockDefinition;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.PosessionHelper;
import com.ma.tools.TeleportHelper;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class ServerMessageHandler {
    private static <T extends BaseMessage> boolean validateBasics(T message, NetworkEvent.Context ctx) {
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return false;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return false;
        }
        return true;
    }

    public static void handleUIModifierPress(UIModifierPress message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when UIModifierPress was received");
            return;
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.setModifierPressed(message.getPressed())));
    }

    public static void handleInscriptionTableShapeSet(InscriptionTableSetShapeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableSetShapeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> InscriptionTableTile.handleShapeSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableComponentSet(InscriptionTableSetComponentMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableSetComponentMessage was received");
            return;
        }
        ctx.enqueueWork(() -> InscriptionTableTile.handleComponentSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableModifierSet(InscriptionTableSetModifierMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableSetModifierMessage was received");
            return;
        }
        ctx.enqueueWork(() -> InscriptionTableTile.handleModifierSet(sendingPlayer, message));
    }

    public static void handleInscriptionTableAttributeChange(InscriptionTableAttributeChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableAttributeChangeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> InscriptionTableTile.handleAttributeValueChange(sendingPlayer, message));
    }

    public static void handleInscriptionTableStartCrafting(InscriptionTableRequestStartCraftingMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableRequestStartCraftingMessage was received");
            return;
        }
        ctx.enqueueWork(() -> InscriptionTableTile.handleRequestStartCrafting(sendingPlayer, message));
    }

    public static void handleManaweavePatternDrawnMessage(ManaweavePatternDrawnMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when ManaweavePatternDrawnMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            TileEntity worldTile;
            BlockPos messagePos = new BlockPos(message.getPosition());
            if (!sendingPlayer.field_70170_p.isAreaLoaded(messagePos, 64)) {
                return;
            }
            IRecipe pattern = sendingPlayer.field_70170_p.func_199532_z().func_215367_a(message.getPatternID()).orElse(null);
            if (!(pattern instanceof IManaweavePattern)) {
                return;
            }
            if (!EventDispatcher.DispatchManaweavePatternDrawn((IManaweavePattern)pattern, (PlayerEntity)sendingPlayer)) {
                return;
            }
            BlockPos storedPos = ItemManaweaverWand.getStoredBlockPos(sendingPlayer.func_184586_b(message.getHand()));
            ManaweavingAltarTile tile = null;
            if (storedPos != null && storedPos.func_177951_i((Vector3i)messagePos) <= 64.0 && (worldTile = sendingPlayer.field_70170_p.func_175625_s(storedPos)) != null && worldTile instanceof ManaweavingAltarTile) {
                tile = (ManaweavingAltarTile)worldTile;
            }
            if (tile == null) {
                Entity weave = ((EntityType)EntityInit.MANAWEAVE_ENTITY.get()).func_200721_a(sendingPlayer.field_70170_p);
                if (weave != null) {
                    weave.func_70012_b(message.getPosition().field_72450_a, message.getPosition().field_72448_b, message.getPosition().field_72449_c, 0.0f, 0.0f);
                    if (weave instanceof EntityManaweave) {
                        ((EntityManaweave)weave).setPattern(message.getPatternID());
                        ((EntityManaweave)weave).setCaster((PlayerEntity)sendingPlayer, message.getHand());
                        ((EntityManaweave)weave).setManuallyDrawn();
                        ((EntityManaweave)weave).setManaRefunded(message.getTicksDrawn());
                    }
                    sendingPlayer.field_70170_p.func_217376_c(weave);
                }
            } else {
                tile.pushPattern((ManaweavingPattern)pattern, (PlayerEntity)sendingPlayer);
            }
            sendingPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.addMagicXP(3, (PlayerEntity)sendingPlayer, (IPlayerProgression)p)));
            sendingPlayer.func_184614_ca().func_222118_a(1, (LivingEntity)sendingPlayer, i -> {});
        });
    }

    public static void handleRunescribingTableMutexChangeMessage(RunescribingTableMutexChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellCastMessageToServer was received");
            return;
        }
        ctx.enqueueWork(() -> {
            if (!sendingPlayer.field_70170_p.func_195588_v(message.getPosition())) {
                return;
            }
            ctx.enqueueWork(() -> RunescribingTableTile.handleMutexChangeMessage(sendingPlayer, message));
        });
    }

    public static void handleSpellBookSlotChangeMessage(SpellBookSlotChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellBookSlotChangeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> ItemSpellBook.handleSlotChangeMessage(message, sendingPlayer));
    }

    public static void handleRadialInventorySlotChangeMessage(RadialInventorySlotChangeMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when RadialInventorySlotChangeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = sendingPlayer.func_184614_ca();
            if (stack.func_77973_b() instanceof IRadialInventorySelect) {
                ((IRadialInventorySelect)stack.func_77973_b()).setSlot((PlayerEntity)sendingPlayer, stack, message.getSlot(), false);
            }
        });
    }

    public static void handleEnderDiscPatternSetMessage(EnderDiscPatternSetMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when EnderDiscPatternSetMessage was received");
            return;
        }
        ctx.enqueueWork(() -> ItemEnderDisk.setPattern(sendingPlayer.field_71071_by.func_70448_g(), message.getPatterns(), message.getIndex(), message.getName()));
    }

    public static void handleEnderDiscIndexSetMessage(EnderDiscIndexSetMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when EnderDiscIndexSetMessage was received");
            return;
        }
        ctx.enqueueWork(() -> ItemEnderDisk.setIndex(sendingPlayer.field_71071_by.func_70448_g(), message.getIndex()));
    }

    public static void handleRitualKitIndexSetMessage(RitualKitIndexSetMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when RitualKitIndexSetMessage was received");
            return;
        }
        ctx.enqueueWork(() -> ItemPractitionersPouch.setIndex(sendingPlayer.field_71071_by.func_70448_g(), message.getIndex()));
    }

    public static void handleAnimatedConstructSyncRequestMessage(AnimatedConstructSyncRequestMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when AnimatedConstructSyncRequestMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            EntityAnimatedConstruct eac = (EntityAnimatedConstruct)sendingPlayer.field_70170_p.func_73045_a(message.getEntityID());
            if (eac != null) {
                eac.setRequestingDiagnostics(message.getDiagnosticsOnly());
                ServerMessageDispatcher.sendEntityStateMessage(eac, sendingPlayer);
                eac.setRequestingDiagnostics(false);
            }
        });
    }

    public static void handleMAPFXSyncRequestMessage(MAPFXSyncRequestMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when MAPFXSyncRequestMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity entity = sendingPlayer.field_70170_p.func_73045_a(message.getEntityID());
            if (entity != null && entity instanceof LivingEntity) {
                ServerMessageDispatcher.sendMAPFXMessage((LivingEntity)entity, sendingPlayer);
            }
        });
    }

    public static void handleMultiblockSyncRequestMessage(MultiblockSyncRequestMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when MultiblockSyncRequestMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity entity = sendingPlayer.field_70170_p.func_73045_a(message.getEntityID());
            if (entity != null && entity instanceof ServerPlayerEntity) {
                entity.field_70170_p.func_199532_z().func_215367_a(message.getRecipe()).ifPresent(r -> {
                    if (r instanceof MultiblockDefinition) {
                        ServerMessageDispatcher.sendStructureSyncMessage((MultiblockDefinition)r, (ServerPlayerEntity)entity);
                    }
                });
            }
        });
    }

    public static void handleRequestWellspringPowerNetworkSyncMessage(RequestWellspringPowerNetworkSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when MultiblockSyncRequestMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            ServerWorld world = TeleportHelper.resolveRegistryKey((ServerWorld)sendingPlayer.field_70170_p, message.getDimension());
            if (world != null) {
                ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage(world, sendingPlayer, true);
                if (message.getNearbyNodes()) {
                    ServerMessageDispatcher.sendWellspringSyncMessage(world, sendingPlayer, 512);
                }
            }
        });
    }

    public static void handleLodestarGUIActionMessage(LodestarGUIActionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when AnimatedConstructSyncRequestMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            LodestarTile lodestar;
            if (sendingPlayer.field_70170_p.func_195588_v(message.getPos()) && (lodestar = (LodestarTile)sendingPlayer.field_70170_p.func_175625_s(message.getPos())) != null) {
                lodestar.handleMessage((PlayerEntity)sendingPlayer, message);
            }
        });
    }

    public static void handleArcaneSentryTargetPlayersMessage(ArcaneSentryTargetPlayersMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when ArcaneSentryTargetPlayersMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            TileEntity te = sendingPlayer.field_70170_p.func_175625_s(message.getBlockPos());
            if (te != null && te instanceof ArcaneSentryTile) {
                ((ArcaneSentryTile)te).setTargetPlayers(message.getTargetPlayers());
            }
        });
    }

    public static void handleRoteSpellsSyncMessageToServer(RoteSpellsSyncMessageToServer message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when RoteSpellsSyncMessageToServer was received");
            return;
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            MutableInt playerTier = new MutableInt(0);
            sendingPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
            for (int i = 0; i < message.getInventory().size(); ++i) {
                ItemStack roteStack = (ItemStack)message.getInventory().get(i);
                SpellRecipe spell = SpellRecipe.fromNBT(roteStack.func_196082_o());
                if (!spell.isValid()) {
                    m.getRoteInventory().func_70299_a(i, new ItemStack((IItemProvider)ItemInit.SPELL.get()));
                    continue;
                }
                m.getRoteInventory().func_70299_a(i, roteStack);
            }
            m.setSyncRote();
            m.forceSync();
        }));
    }

    public static void handlePlayerBounceMessage(PlayerBounceMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when PlayerBounceMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            sendingPlayer.func_213317_d(message.getVelocity());
            sendingPlayer.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)sendingPlayer));
        });
    }

    public static void handlePlayerJumpMessage(PlayerJumpMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when PlayerJumpMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.LEAPING.get()), (ItemStack)sendingPlayer.func_184582_a(EquipmentSlotType.FEET));
            sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getAirJumps() < enchLevel) {
                    m.incrementAirJumps((PlayerEntity)sendingPlayer);
                    sendingPlayer.func_70664_aZ();
                    sendingPlayer.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)sendingPlayer));
                }
            });
        });
    }

    public static void handleCantripPatternUpdateMessage(CantripPatternUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when CantripPatternUpdateMessage was received");
            return;
        }
        ctx.enqueueWork(() -> sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCantripData().readFromNBT(message.getData())));
    }

    public static void handleSpellNameAndIconMessage(SpellNameAndIconMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellNameAndIconMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = sendingPlayer.func_184586_b(message.getHand());
            if (stack.func_77973_b() == ItemInit.SPELL.get() || stack.func_77973_b() instanceof ItemStaff) {
                stack.func_200302_a((ITextComponent)new StringTextComponent(message.getName()));
                ItemSpell.setCustomIcon(stack, message.getIconIndex());
            } else if (stack.func_77973_b() instanceof ItemBookOfRote) {
                sendingPlayer.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    ItemStack roteStack = m.getRoteInventory().func_70301_a(message.getItemIndex());
                    roteStack.func_200302_a((ITextComponent)new StringTextComponent(message.getName()));
                    ItemSpell.setCustomIcon(roteStack, message.getIconIndex());
                });
            }
        });
    }

    public static void handleSpellAdjustmentsMessage(SpellAdjustmentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SpellAdjustmentMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            SpellRecipe recipe = SpellRecipe.fromNBT(message.getData());
            ItemStack heldStack = sendingPlayer.func_184586_b(message.getHand());
            if (recipe.isValid() && heldStack.func_77973_b() instanceof ItemSpell && !(heldStack.func_77973_b() instanceof ItemSpellBook)) {
                recipe.writeToNBT(heldStack.func_196082_o());
            } else {
                sendingPlayer.func_145747_a((ITextComponent)new StringTextComponent("Error setting spell data values; serverside validation failed!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        });
    }

    public static void handleOpenSpellRenameMessage(OpenSpellRenameMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when OpenSpellRenameMessage was received");
            return;
        }
        ctx.enqueueWork(() -> NetworkHooks.openGui((ServerPlayerEntity)sendingPlayer, (INamedContainerProvider)new NamedSpellCustomization()));
    }

    public static void handleSelectedModifierMessage(SelectedModifierMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SelectedModifierMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = sendingPlayer.field_71071_by.func_70448_g();
            if (stack.func_77973_b() == ItemInit.MODIFIER_BOOK.get()) {
                ItemModifierBook.setModifier(stack, message.getModifierRLoc());
            } else {
                sendingPlayer.func_145747_a((ITextComponent)new StringTextComponent("Error setting selected modifier, couldn't verify held item"), Util.field_240973_b_);
            }
        });
    }

    public static void handleConstructHornMessage(ConstructHornMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SelectedModifierMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = sendingPlayer.field_70170_p.func_73045_a(message.getEntityId());
            if (e != null && e instanceof EntityAnimatedConstruct) {
                ((EntityAnimatedConstruct)e).soundHorn();
            }
        });
    }

    public static void handleTradeSelectedMessage(TradeSelectedMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when SelectedModifierMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            int i = message.getIndex();
            Container container = sendingPlayer.field_71070_bA;
            if (container instanceof ContainerWanderingWizard) {
                ContainerWanderingWizard merchantcontainer = (ContainerWanderingWizard)container;
                merchantcontainer.setCurrentRecipeIndex(i);
                merchantcontainer.setCurrentTradeRecipeItems(i);
            }
        });
    }

    public static void handlePossessionInputMessage(PossessionInputMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when PosessionInputMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            int id;
            Entity e;
            if (sendingPlayer.getPersistentData().func_74764_b("posessed_entity_id") && (e = sendingPlayer.field_70170_p.func_73045_a(id = sendingPlayer.getPersistentData().func_74762_e("posessed_entity_id"))) != null && e instanceof MobEntity) {
                PosessionHelper.handleRemoteInput(message, (PlayerEntity)sendingPlayer, (MobEntity)e);
            }
            if (sendingPlayer.getPersistentData().func_74764_b("eldrin_flight_entity_id") && (e = sendingPlayer.field_70170_p.func_73045_a(id = sendingPlayer.getPersistentData().func_74762_e("eldrin_flight_entity_id"))) != null && e instanceof EntityEldrinFlight) {
                e.field_70177_z = message.getYaw();
                e.field_70125_A = message.getPitch();
            }
        });
    }

    public static void handleEndControlEffectEarlyMessage(EndControlEffectEarlyMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when EndControlEffectEarlyMessage was received");
            return;
        }
        ctx.enqueueWork(() -> EffectHelper.removeDoubleTapEvents((PlayerEntity)sendingPlayer));
    }

    public static void handleMagiciansWorkbenchRecipeSetMessage(MagiciansWorkbenchRecipeSetMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableSetShapeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            if (sendingPlayer.field_71070_bA != null && sendingPlayer.field_71070_bA instanceof ContainerMagiciansWorkbench) {
                ((ContainerMagiciansWorkbench)sendingPlayer.field_71070_bA).moveRecipeToCraftingGrid(message.getIndex());
            }
        });
    }

    public static void handleMagiciansWorkbenchClearMessage(MagiciansWorkbenchClearMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ServerMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ManaAndArtifice.LOGGER.error("EntityPlayerMP was null when InscriptionTableSetShapeMessage was received");
            return;
        }
        ctx.enqueueWork(() -> {
            if (sendingPlayer.field_71070_bA != null && sendingPlayer.field_71070_bA instanceof ContainerMagiciansWorkbench) {
                ((ContainerMagiciansWorkbench)sendingPlayer.field_71070_bA).tryClearGrid(message.isSecond());
            }
        });
    }
}

