/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.MAParticleType;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.capabilities.entity.MAPFXProvider;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.IAnimPacketSync;
import com.ma.network.MAPacketHandler;
import com.ma.network.messages.to_client.CantripCastingTimerMessage;
import com.ma.network.messages.to_client.EntityStateMessage;
import com.ma.network.messages.to_client.ExtendedSlotContentsMessage;
import com.ma.network.messages.to_client.MAPFXMessage;
import com.ma.network.messages.to_client.MagicSyncMessageToClient;
import com.ma.network.messages.to_client.MindVisionMessage;
import com.ma.network.messages.to_client.PosessionMessage;
import com.ma.network.messages.to_client.ProgressionSyncMessageToClient;
import com.ma.network.messages.to_client.RoteProgressSyncMessageToClient;
import com.ma.network.messages.to_client.SetLiftPositionMessage;
import com.ma.network.messages.to_client.SetRitualCollectedReagentsMessage;
import com.ma.network.messages.to_client.SpawnParticleEffectMessage;
import com.ma.network.messages.to_client.SpawnParticleMessage;
import com.ma.network.messages.to_client.StructureSyncMessage;
import com.ma.network.messages.to_client.WanderingWizardInventoryMessage;
import com.ma.network.messages.to_client.WellspringPowerNetworkSyncMessage;
import com.ma.network.messages.to_client.WellspringSyncMessage;
import com.ma.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import com.ma.recipes.multiblock.MultiblockDefinition;
import com.ma.tools.TeleportHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerMessageDispatcher {
    public static void sendMagicSyncMessage(ServerPlayerEntity player) {
        LazyOptional magic = player.getCapability(PlayerMagicProvider.MAGIC);
        if (!magic.isPresent()) {
            return;
        }
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)MagicSyncMessageToClient.fromCapability((IPlayerMagic)magic.orElse(null)));
    }

    public static void sendStructureSyncMessage(MultiblockDefinition structure, ServerPlayerEntity player) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)StructureSyncMessage.fromMultiblock(structure, player.func_71121_q()));
    }

    public static void sendEntityStateMessage(IAnimPacketSync<?> entity) {
        MAPacketHandler.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> (Entity)entity), (Object)EntityStateMessage.fromEntity(entity));
    }

    public static void sendEntityStateMessage(IAnimPacketSync<?> entity, ServerPlayerEntity player) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)EntityStateMessage.fromEntity(entity));
    }

    public static void sendMAPFXMessage(LivingEntity entity, ServerPlayerEntity player) {
        entity.getCapability(MAPFXProvider.MAPFX).ifPresent(p -> MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MAPFXMessage(entity.func_145782_y(), p.getFlags())));
    }

    public static void sendMAPFXMessage(LivingEntity entity) {
        entity.getCapability(MAPFXProvider.MAPFX).ifPresent(p -> MAPacketHandler.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MAPFXMessage(entity.func_145782_y(), p.getFlags())));
    }

    public static void sendProgressionSyncMessage(ServerPlayerEntity player) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)ProgressionSyncMessageToClient.fromCapability(p)));
    }

    public static void sendRoteSyncMessage(ServerPlayerEntity player) {
        player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)RoteProgressSyncMessageToClient.fromCapability(r)));
    }

    public static void sendInscriptionTableCraftingUpdate(InscriptionTableTile te) {
        ServerWorld world = (ServerWorld)te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        MAPacketHandler.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)InscriptionTableCraftingUpdateMessage.fromInscriptionTable(te));
    }

    public static void sendRitualReagentData(CompoundNBT ritualReagentData, int entityID, ServerWorld world, BlockPos pos) {
        MAPacketHandler.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)new SetRitualCollectedReagentsMessage(ritualReagentData, entityID));
    }

    public static void sendParticleSpawn(double x, double y, double z, double vX, double vY, double vZ, float radius, RegistryKey<World> dimension, MAParticleType type) {
        SpawnParticleMessage msg = new SpawnParticleMessage(x, y, z, vX, vY, vZ, type.getRegistryName());
        MAPacketHandler.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, (double)radius, dimension)), (Object)msg);
    }

    public static void sendParticleEffect(RegistryKey<World> dimension, float radius, double x, double y, double z, SpawnParticleEffectMessage.ParticleTypes type) {
        SpawnParticleEffectMessage msg = new SpawnParticleEffectMessage(x, y, z, type);
        MAPacketHandler.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, (double)radius, dimension)), (Object)msg);
    }

    public static void sendSetLiftPosition(double x, double y, double z, ServerPlayerEntity player) {
        SetLiftPositionMessage msg = new SetLiftPositionMessage(x, y, z);
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void sendCantripTimerMessage(String id, int ticks, ServerPlayerEntity player) {
        CantripCastingTimerMessage msg = new CantripCastingTimerMessage(id, ticks);
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void sendWanderingWizardContainerMessage(int containerID, MerchantOffers offers, int level, int xp, boolean hasXPBar, boolean canRestock, boolean isFinal, ServerPlayerEntity player) {
        WanderingWizardInventoryMessage msg = new WanderingWizardInventoryMessage(containerID, offers, level, xp, hasXPBar, canRestock, isFinal);
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void sendWellspringPowerNetworkSyncMessage(RegistryKey<World> targetDimension, ServerPlayerEntity player, boolean fullSync) {
        ServerWorld targetWorld = TeleportHelper.resolveRegistryKey((ServerWorld)player.field_70170_p, targetDimension);
        ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage(targetWorld, player, fullSync);
    }

    public static void sendWellspringPowerNetworkSyncMessage(ServerWorld world, ServerPlayerEntity player, boolean fullSync) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)WellspringPowerNetworkSyncMessage.from(world, player, fullSync));
    }

    public static void sendWellspringSyncMessage(ServerWorld world, ServerPlayerEntity player) {
        ServerMessageDispatcher.sendWellspringSyncMessage(world, player, 64);
    }

    public static void sendWellspringSyncMessage(ServerWorld world, ServerPlayerEntity player, int radius) {
        CompoundNBT nbt = new CompoundNBT();
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            if (m.getWellspringRegistry().writeToNBT(nbt, player.func_233580_cy_(), radius)) {
                MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new WellspringSyncMessage(nbt));
            }
        });
    }

    public static void sendPlayerMindVisionMessage(ServerPlayerEntity player, Entity entity) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MindVisionMessage(entity != null ? entity.func_145782_y() : -1));
    }

    public static void sendPlayerPosessionMessage(ServerPlayerEntity player, Entity entity) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PosessionMessage(entity.func_145782_y()));
    }

    public static void sendExtendedItemStack(ServerPlayerEntity player, int screenID, int slotID, ItemStack stack) {
        MAPacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ExtendedSlotContentsMessage(screenID, slotID, stack));
    }
}

