/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery.bound;

import com.ma.api.spells.base.ISpellDefinition;
import com.ma.items.renderers.bound.BoundShieldItemRenderer;
import com.ma.items.sorcery.bound.IBoundItem;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ItemBoundShield
extends ShieldItem
implements IBoundItem {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ItemBoundShield() {
        super(new Item.Properties().setISTER(() -> BoundShieldItemRenderer::new));
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public float getPassiveManaDrain(Entity entity) {
        return entity instanceof LivingEntity && ((LivingEntity)entity).func_184585_cz() ? 2.0f : 0.2f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.handleInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public boolean isShield(ItemStack stack, LivingEntity entity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        SpellRecipe recipe = this.getRecipe(stack);
        recipe.addItemTooltip(stack, worldIn, tooltip, flagIn, (PlayerEntity)mc.field_71439_g);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack createFromSpell(ItemStack original, ISpellDefinition recipe) {
        return IBoundItem.super.createFromSpell((Item)this, original, recipe);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        ItemStack restored = this.restoreItem(item);
        player.func_174820_d(98, restored);
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bound_shield.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

