/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.gui.containers.providers.NamedGrimoire;
import com.ma.items.renderers.books.GrimoireBookRenderer;
import com.ma.items.sorcery.ISpellBookInventory;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemSpellGrimoire
extends ItemSpellBook {
    private boolean showSubtitle = false;

    public ItemSpellGrimoire() {
        this(() -> GrimoireBookRenderer::new, false);
    }

    public ItemSpellGrimoire(Supplier<Callable<ItemStackTileEntityRenderer>> ister, boolean renderBook) {
        super(ister, renderBook);
        this.tier = 3;
    }

    public ItemSpellGrimoire setFactionGrimoire() {
        this.showSubtitle = true;
        this.tier = 4;
        return this;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedGrimoire();
    }

    @Override
    public ISpellBookInventory getInventory(ItemStack item, IPlayerMagic magic) {
        if (magic == null) {
            return null;
        }
        return magic.getGrimoireInventory();
    }

    @Override
    public CompoundNBT getSpellCompound(ItemStack stack, PlayerEntity player) {
        if (player == null) {
            return new CompoundNBT();
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return new CompoundNBT();
        }
        ItemStack selectedStack = magic.getGrimoireInventory().func_70301_a(ItemSpellGrimoire.getActiveSpellSlot(stack));
        return selectedStack.func_190925_c("spell");
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("cur_spell_use_duration")) {
            return tag.func_74762_e("cur_spell_use_duration");
        }
        return 9999;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack bookStack;
        ItemStack selectedStack;
        SpellRecipe recipe;
        if (!world.field_72995_K && (recipe = SpellRecipe.fromNBT((selectedStack = this.getSelectedStack(bookStack = player.func_184586_b(hand), player)).func_190925_c("spell"))).isValid()) {
            CompoundNBT bookTag = bookStack.func_196082_o();
            bookTag.func_74768_a("cur_spell_use_duration", recipe.getMaxChannelTime());
            bookStack.func_77982_d(bookTag);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    protected ItemStack getSelectedStack(ItemStack bookStack, @Nullable PlayerEntity player) {
        Inventory bookInv;
        if (bookStack.func_77973_b() instanceof ItemSpellBook && (bookInv = (Inventory)this.getInventory(bookStack, player != null ? (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null) : null)) != null) {
            ItemStack selectedStack = bookInv.func_70301_a(ItemSpellGrimoire.getActiveSpellSlot(bookStack));
            return selectedStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.showSubtitle) {
            tooltip.add((ITextComponent)new TranslationTextComponent(stack.func_77977_a() + ".subtitle"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : 5841080;
    }
}

