/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.constructs;

import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.blocks.BlockInit;
import com.ma.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.ma.entities.constructs.ai.ConstructCommandReturnToTable;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ConstructControlRod
extends TieredItem {
    private static final String NBT_COMMANDING_ENTITY = "commanding_entity";

    public ConstructControlRod() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.constructs));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!playerIn.field_70170_p.field_72995_K) {
            EntityAnimatedConstruct commanded_entity = this.getCommandedEntity(playerIn.field_70170_p, stack);
            if (target instanceof EntityAnimatedConstruct) {
                if (commanded_entity == null) {
                    ItemStack heldStack = playerIn.func_184586_b(hand);
                    this.setCommandingEntity((EntityAnimatedConstruct)target, heldStack);
                } else {
                    this.commandEntity(commanded_entity, playerIn, hand, (ConstructCommand)((Object)commanded_entity.getCommand(ConstructActions.STAY)));
                }
                return ActionResultType.SUCCESS;
            }
            if (target instanceof LivingEntity) {
                // empty if block
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        EntityAnimatedConstruct commandedEntity = this.getCommandedEntity(context.func_195991_k(), stack);
        if (commandedEntity == null) {
            context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.construct_control_rod.not_commanding"), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        BlockState block = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (block.func_177230_c() == BlockInit.CONSTRUCT_WORKBENCH.get()) {
            ((ConstructCommandReturnToTable)((Object)commandedEntity.getCommand(ConstructActions.MODIFY))).setTablePos(context.func_195995_a());
            commandedEntity.setCurrentCommand(context.func_195999_j(), (ConstructCommand)((Object)commandedEntity.getCommand(ConstructActions.MODIFY)));
        } else if (block.func_177230_c() == BlockInit.LODESTAR.get()) {
            ((ConstructCommandFollowLodestar)((Object)commandedEntity.getCommand(ConstructActions.LODESTAR))).setTileEntity(context.func_195995_a(), Direction.DOWN);
            commandedEntity.setCurrentCommand(context.func_195999_j(), (ConstructCommand)((Object)commandedEntity.getCommand(ConstructActions.LODESTAR)));
        } else {
            this.commandEntity(commandedEntity, context.func_195999_j(), context.func_221531_n(), (ConstructCommand)((Object)commandedEntity.getCommand(ConstructActions.FOLLOW_DEFEND)));
        }
        this.setCommandingEntity(null, stack);
        return ActionResultType.SUCCESS;
    }

    private void commandEntity(EntityAnimatedConstruct construct, PlayerEntity player, Hand hand, ConstructCommand command) {
        this.setCommandingEntity(null, player.func_184586_b(hand));
        construct.setCurrentCommand(player, command);
    }

    private void setCommandingEntity(EntityAnimatedConstruct construct, ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(NBT_COMMANDING_ENTITY, construct != null ? construct.func_145782_y() : -1);
        stack.func_77982_d(tag);
    }

    private EntityAnimatedConstruct getCommandedEntity(World world, ItemStack stack) {
        Entity e = world.func_73045_a(stack.func_196082_o().func_74762_e(NBT_COMMANDING_ENTITY));
        if (e instanceof EntityAnimatedConstruct) {
            return (EntityAnimatedConstruct)e;
        }
        return null;
    }
}

