/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice;

import com.ma.api.capabilities.WellspringNode;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.sound.ItemInUseLoopingSound;
import com.ma.tools.math.MathUtils;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemDowsingRod
extends TieredItem {
    private static final float MANA_PER_TICK = 5.0f;
    private static final String KEY_STORED_CLOSEST_BP = "closest_node_pos";

    public ItemDowsingRod() {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 999999;
    }

    public void func_219972_a(World world, LivingEntity user, ItemStack stack, int ticks) {
        if (!(user instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)user;
        MutableBoolean continueUsing = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (!m.isMagicUnlocked() || m.getCastingResource().getAmount() < 5.0f) {
                continueUsing.setFalse();
                return;
            }
            m.getCastingResource().consume(5.0f);
        });
        if (!continueUsing.getValue().booleanValue()) {
            player.func_184597_cx();
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o(KEY_STORED_CLOSEST_BP);
            }
        } else {
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(wm -> {
                BlockPos closest = null;
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_STORED_CLOSEST_BP)) {
                    closest = BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f(KEY_STORED_CLOSEST_BP));
                } else {
                    HashMap<BlockPos, WellspringNode> nodes = wm.getWellspringRegistry().getNearbyNodes(user.func_233580_cy_(), 0, (int)((double)((Integer)GeneralModConfig.MA_NODE_DISTANCE.get()).intValue() * 1.5));
                    MutableObject closestLoopContainer = new MutableObject(null);
                    MutableDouble closestDist = new MutableDouble();
                    nodes.keySet().forEach(bp -> {
                        double dist = bp.func_177951_i((Vector3i)player.func_233580_cy_());
                        if (closestLoopContainer.getValue() == null || dist < closestDist.getValue()) {
                            closestLoopContainer.setValue(bp);
                            closestDist.setValue(dist);
                        }
                    });
                    if (closestLoopContainer.getValue() == null) {
                        return;
                    }
                    stack.func_196082_o().func_74772_a(KEY_STORED_CLOSEST_BP, ((BlockPos)closestLoopContainer.getValue()).func_218275_a());
                }
                if (closest != null) {
                    Vector3d closestPos = new Vector3d((double)closest.func_177958_n() + 0.5, player.func_226278_cu_() + (double)player.func_70047_e(), (double)closest.func_177952_p() + 0.5);
                    if (world.field_72995_K) {
                        MathUtils.rotateEntityLookTowards(EntityAnchorArgument.Type.EYES, (LivingEntity)player, closestPos, 5.0f);
                    }
                }
            });
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity user, int ticks) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(KEY_STORED_CLOSEST_BP);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        MutableBoolean success = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (m.isMagicUnlocked()) {
                if (world.field_72995_K) {
                    this.PlayLoopingSound(SFX.Loops.MANAWEAVING, player);
                }
                player.func_184598_c(hand);
            } else {
                if (world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.dowsing_rod.confusion"), Util.field_240973_b_);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 100);
            }
        });
        if (success.getValue().booleanValue()) {
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, PlayerEntity player) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ItemInUseLoopingSound(soundID, player));
    }
}

