/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.artifice;

import com.ma.api.capabilities.CurioItemCapability;
import com.ma.api.capabilities.Faction;
import com.ma.api.items.IFactionSpecific;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.effects.EffectInit;
import java.util.ArrayList;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ItemArcaneCrown
extends TieredItem
implements IFactionSpecific {
    public ItemArcaneCrown() {
        super(new Item.Properties().func_200916_a(MAItemGroups.artifice).func_200917_a(1).func_208103_a(Rarity.EPIC));
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        EquipmentSlotType slotType = EquipmentSlotType.HEAD;
        ItemStack equippedItem = playerIn.func_184582_a(slotType);
        if (equippedItem.func_190926_b()) {
            playerIn.func_184201_a(slotType, heldItem.func_77946_l());
            heldItem.func_190920_e(0);
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return entity instanceof PlayerEntity && stack.func_77973_b() == this && armorType == EquipmentSlotType.HEAD;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.tickEffect(player, world);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return CurioItemCapability.createProvider(new ICurio(){

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    ItemArcaneCrown.this.tickEffect((PlayerEntity)livingEntity, livingEntity.field_70170_p);
                }
            }
        });
    }

    @Override
    public float getMaxIre() {
        return 5.0E-4f;
    }

    @Override
    public Faction getFaction() {
        return Faction.ANCIENT_WIZARDS;
    }

    private void tickEffect(PlayerEntity player, World world) {
        EffectInstance dispelExhaustion;
        EffectInstance manaBoost;
        if (!(world.field_72995_K || (manaBoost = player.func_70660_b((Effect)EffectInit.MANA_BOOST.get())) != null && manaBoost.func_76459_b() >= 10 && manaBoost.func_76458_c() >= 1)) {
            player.func_195064_c(new EffectInstance((Effect)EffectInit.MANA_BOOST.get(), 100, 1, false, false, false));
            this.usedByPlayer(player);
        }
        if ((dispelExhaustion = player.func_70660_b((Effect)EffectInit.DISPEL_EXHAUSTION.get())) == null) {
            int effectsRemoved = 0;
            this.usedByPlayer(player);
            ArrayList<Effect> toRemove = new ArrayList<Effect>();
            for (EffectInstance inst : player.func_70651_bq()) {
                if (inst.func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
                toRemove.add(inst.func_188419_a());
            }
            for (Effect e : toRemove) {
                if (!player.func_195063_d(e)) continue;
                ++effectsRemoved;
            }
            if (effectsRemoved > 0 && !world.field_72995_K) {
                player.func_195064_c(new EffectInstance((Effect)EffectInit.DISPEL_EXHAUSTION.get(), 6000, 0, false, false, false));
            }
        }
    }
}

