/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.IFactionSpecific;
import com.ma.api.items.ITieredItem;
import com.ma.api.items.MAItemGroups;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.entities.utility.MAExplosion;
import com.ma.items.ItemInit;
import com.ma.items.armor.ISetItem;
import com.ma.tools.RLoc;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class DemonArmorItem
extends GeoArmorItem
implements IAnimatable,
ISetItem,
ITieredItem<DemonArmorItem>,
IFactionSpecific {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final ResourceLocation demon_armor_set_bonus = RLoc.create("demon_armor_set_bonus");
    public static final String demon_armor_set_bonus_key = "demon_armor_set_bonus";
    public static final String demon_armor_meteor_jumping_key = "demon_armor_meteor_jumping";
    public static final AttributeModifier runSpeed = new AttributeModifier("demon_armor_set_bonus", 0.25, AttributeModifier.Operation.ADDITION);
    private static final float MANA_COST_PER_TICK = 0.25f;
    private static final float METEOR_JUMP_MANA_COST = 40.0f;
    private int _tier = -1;

    public DemonArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder.func_200916_a(MAItemGroups.artifice).func_208103_a(Rarity.EPIC));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return demon_armor_set_bonus;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.usedByPlayer(player);
        if (this.isSetEquipped((LivingEntity)player)) {
            EffectInstance eff;
            if (stack.func_77973_b() != ItemInit.DEMON_ARMOR_CHEST.get()) {
                return;
            }
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic == null) {
                return;
            }
            boolean showParticles = false;
            boolean removeModifier = true;
            if (player.func_70051_ag() && magic.getCastingResource().getAmount() >= 0.25f) {
                if (!player.func_110148_a(Attributes.field_233821_d_).func_180374_a(runSpeed)) {
                    player.func_110148_a(Attributes.field_233821_d_).func_233767_b_(runSpeed);
                    player.func_184185_a(SFX.Event.Artifact.DEMON_ARMOR_SPRINT_START, 1.0f, 1.0f);
                }
                magic.getCastingResource().consume(0.25f);
                removeModifier = false;
                showParticles = true;
            }
            if (removeModifier) {
                player.func_110148_a(Attributes.field_233821_d_).func_111124_b(runSpeed);
            }
            if (!player.func_233570_aj_() && player.func_213322_ci().field_72448_b < 0.0 && player.func_213453_ef() && magic.getCastingResource().getAmount() >= 40.0f && !player.getPersistentData().func_74764_b(demon_armor_meteor_jumping_key)) {
                int heightAboveGround;
                int reqHeight = 5;
                BlockPos pos = player.func_233580_cy_();
                for (heightAboveGround = 0; player.field_70170_p.func_175623_d(pos) && heightAboveGround < reqHeight; ++heightAboveGround) {
                    pos = pos.func_177977_b();
                }
                if (heightAboveGround >= reqHeight) {
                    player.getPersistentData().func_74757_a(demon_armor_meteor_jumping_key, true);
                    player.func_184185_a(SFX.Event.Artifact.METEOR_JUMP, 0.25f, 0.8f);
                    magic.getCastingResource().consume(40.0f);
                    showParticles = true;
                }
            }
            if (player.getPersistentData().func_74764_b(demon_armor_meteor_jumping_key)) {
                this.handlePlayerMeteorJump(player);
                showParticles = true;
            }
            if (player.func_70027_ad()) {
                EffectInstance strength;
                if (!(player.field_70170_p.field_72995_K || (strength = player.func_70660_b(Effects.field_76420_g)) != null && strength.func_76459_b() >= 105)) {
                    player.func_195064_c(new EffectInstance(Effects.field_76420_g, 600, 1, true, true));
                }
            } else if (!player.field_70170_p.field_72995_K && (eff = player.func_70660_b(Effects.field_76420_g)) != null && eff.func_82720_e()) {
                player.func_195063_d(Effects.field_76420_g);
            }
            if (world.field_72995_K && showParticles) {
                Vector3d motion = player.func_213322_ci();
                Vector3d look = player.func_189651_aD().func_72431_c(new Vector3d(0.0, 1.0, 0.0));
                float offset = (float)(Math.random() * 0.2);
                float yOffset = 0.2f;
                look = look.func_186678_a((double)offset);
                for (int i = 0; i < 5; ++i) {
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.func_226277_ct_() + look.field_72450_a + Math.random() * motion.field_72450_a * 2.0, player.func_226278_cu_() + (double)yOffset + Math.random() * motion.field_72448_b * 2.0, player.func_226281_cx_() + look.field_72449_c + Math.random() * motion.field_72449_c * 2.0, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.func_226277_ct_() - look.field_72450_a + Math.random() * motion.field_72450_a * 2.0, player.func_226278_cu_() + (double)yOffset + Math.random() * motion.field_72448_b * 2.0, player.func_226281_cx_() - look.field_72449_c + Math.random() * motion.field_72449_c * 2.0, 0.0, 0.0, 0.0);
                }
            }
        } else {
            player.func_110148_a(Attributes.field_233821_d_).func_111124_b(runSpeed);
        }
    }

    public void handlePlayerJump(PlayerEntity player) {
        if (this.isSetEquipped((LivingEntity)player) && player.func_70051_ag()) {
            player.func_70024_g((double)((float)(player.func_213322_ci().field_72450_a * 0.25)), 0.75, (double)((float)(player.func_213322_ci().field_72449_c * 0.25)));
        }
    }

    private void handlePlayerMeteorJump(PlayerEntity player) {
        if (player.func_233570_aj_()) {
            this.handlePlayerMeteorJumpImpact(player, 0.0f);
        }
        if (this.isSetEquipped((LivingEntity)player)) {
            player.func_70024_g(0.0, -0.05, 0.0);
            if (player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 25; ++i) {
                    player.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), player.func_226277_ct_() - 0.5 + Math.random() * 0.5, player.func_226278_cu_() + Math.random(), player.func_226281_cx_() - 0.5 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean handlePlayerMeteorJumpImpact(PlayerEntity player, float fallDistance) {
        if (player.getPersistentData().func_74764_b(demon_armor_meteor_jumping_key)) {
            player.getPersistentData().func_82580_o(demon_armor_meteor_jumping_key);
            if (!player.field_70170_p.field_72995_K && fallDistance > 5.0f) {
                MAExplosion.make((LivingEntity)player, (ServerWorld)player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), Math.min(5.0f, fallDistance / 6.0f), Math.min(20.0f, fallDistance / 1.5f), (Boolean)GeneralModConfig.MA_METEOR_JUMP.get() != false && ((ServerWorld)player.field_70170_p).func_73046_m().func_200252_aR().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
            }
            return true;
        }
        return false;
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(demon_armor_set_bonus_key, true);
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(demon_armor_set_bonus_key, false);
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 4;
    }

    @Override
    public int getCachedtier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public Faction getFaction() {
        return Faction.DEMONS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

