/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.items.IFactionSpecific;
import com.ma.api.items.ITieredItem;
import com.ma.api.items.MAItemGroups;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.effects.EffectInit;
import com.ma.items.ItemInit;
import com.ma.items.armor.ISetItem;
import com.ma.tools.RLoc;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class CouncilArmorItem
extends GeoArmorItem
implements IAnimatable,
ISetItem,
ITieredItem<CouncilArmorItem>,
IFactionSpecific {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final ResourceLocation council_armor_set_bonus = RLoc.create("council_armor_set_bonus");
    public static final String council_armor_set_bonus_key = "council_armor_set_bonus";
    public static final String council_armor_reflect_counters_key = "council_armor_reflect_counters";
    private static final float MANA_COST_PER_TICK = 0.75f;
    private int _tier = -1;

    public CouncilArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder.func_200916_a(MAItemGroups.artifice).func_208103_a(Rarity.EPIC));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.ambient"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return council_armor_set_bonus;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.usedByPlayer(player);
        if (this.isSetEquipped((LivingEntity)player) && this == ItemInit.COUNCIL_ARMOR__CHEST.get()) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (player.field_71075_bZ.field_75100_b && !player.func_70644_a((Effect)EffectInit.LEVITATION.get())) {
                    if (world.field_72995_K) {
                        Vector3d look = player.func_189651_aD().func_72431_c(new Vector3d(0.0, 1.0, 0.0));
                        float offset = (float)(Math.random() * 0.2);
                        look = look.func_186678_a((double)offset);
                        world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), player.func_226277_ct_() + look.field_72450_a, player.func_226278_cu_(), player.func_226281_cx_() + look.field_72449_c, 0.0, (double)-0.05f, 0.0);
                        world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), player.func_226277_ct_() - look.field_72450_a, player.func_226278_cu_(), player.func_226281_cx_() - look.field_72449_c, 0.0, (double)-0.05f, 0.0);
                    } else {
                        m.getCastingResource().consume(0.75f);
                    }
                }
                if (m.getCastingResource().getAmount() <= 0.75f) {
                    ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
                } else {
                    ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
                    if (!player.func_184812_l_()) {
                        ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.02f);
                        if (player.field_71075_bZ.field_75100_b) {
                            player.func_70031_b(false);
                        }
                    } else {
                        ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.05f);
                    }
                }
            });
        }
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(council_armor_set_bonus_key, true);
            ((PlayerEntity)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().addModifier(council_armor_set_bonus_key, 1000.0f);
                m.getCastingResource().addRegenerationModifier(council_armor_set_bonus_key, -0.5f);
            });
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(council_armor_set_bonus_key, false);
            ((PlayerEntity)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().removeModifier(council_armor_set_bonus_key);
                m.getCastingResource().removeRegenerationModifier(council_armor_set_bonus_key);
            });
            ManaAndArtifice.instance.proxy.setFlySpeed((PlayerEntity)living, 0.05f);
            ManaAndArtifice.instance.proxy.setFlightEnabled((PlayerEntity)living, false);
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 4;
    }

    @Override
    public int getCachedtier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public Faction getFaction() {
        return Faction.ANCIENT_WIZARDS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private static int[] getReflectCharges(PlayerEntity player) {
        int[] reflections = !player.getPersistentData().func_74764_b(council_armor_reflect_counters_key) ? new int[((Integer)GeneralModConfig.MA_SPELLWEAVER_REFLECTCHARGES.get()).intValue()] : player.getPersistentData().func_74759_k(council_armor_reflect_counters_key);
        if (reflections.length != (Integer)GeneralModConfig.MA_SPELLWEAVER_REFLECTCHARGES.get()) {
            reflections = new int[((Integer)GeneralModConfig.MA_SPELLWEAVER_REFLECTCHARGES.get()).intValue()];
        }
        return reflections;
    }

    private static void updateReflectCharges(PlayerEntity player, int[] reflections) {
        player.getPersistentData().func_74783_a(council_armor_reflect_counters_key, reflections);
    }

    public static boolean consumeReflectCharget(PlayerEntity player) {
        int[] reflections = CouncilArmorItem.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] > 0) continue;
            reflections[i] = (Integer)GeneralModConfig.MA_SPELLWEAVER_RECHARGETIME.get();
            CouncilArmorItem.updateReflectCharges(player, reflections);
            return true;
        }
        return false;
    }

    public static void tickReflectCharges(PlayerEntity player) {
        int[] reflections = CouncilArmorItem.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] <= 0) continue;
            int n = i;
            reflections[n] = reflections[n] - 1;
        }
        CouncilArmorItem.updateReflectCharges(player, reflections);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return super.makesPiglinsNeutral(stack, wearer);
    }
}

