/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory.stack_extension;

import com.ma.ManaAndArtifice;
import com.ma.gui.containers.IExtendedItemHandler;
import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.WorldSavedData;

public class MAInventoryData<T extends IExtendedItemHandler>
extends WorldSavedData {
    private UUID id;
    private final T inventory;
    private int size;

    public static String ID(UUID id) {
        return "mana-and-artifice-inventory-" + id.toString();
    }

    public MAInventoryData(UUID id, int size, Function<Integer, T> builder) {
        super(MAInventoryData.ID(id));
        this.id = id;
        this.size = size;
        this.inventory = (IExtendedItemHandler)builder.apply(this.size);
    }

    public T getInventory() {
        return this.inventory;
    }

    public UUID getUUID() {
        return this.id;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.id = nbt.func_186857_a("id");
        this.size = nbt.func_74762_e("size");
        this.inventory.deserialize(nbt.func_74775_l("inventory"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("size", this.size);
        compound.func_186854_a("id", this.id);
        if (this.inventory != null) {
            compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        } else {
            ManaAndArtifice.LOGGER.error("MAInventoryData inventory is null - writing empty inventory.");
            compound.func_218657_a("inventory", (INBT)new CompoundNBT());
        }
        return compound;
    }

    public void func_215158_a(File fileIn) {
        super.func_215158_a(fileIn);
    }

    public void func_76185_a() {
        super.func_76185_a();
    }
}

