/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory;

import com.ma.ManaAndArtifice;
import com.ma.inventory.stack_extension.AbstractItemHandler;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;

public class ItemInventoryBase
extends AbstractItemHandler {
    protected final ItemStack stack;
    private static final String TAG_ITEMS = "Items";

    public ItemInventoryBase(ItemStack stack) {
        super(54);
        this.stack = stack;
        this.setup();
    }

    public ItemInventoryBase(ItemStack stack, int numSlots) {
        super(numSlots);
        this.stack = stack;
        this.setup();
    }

    public void setup() {
        this.readItemStack();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void readItemStack() {
        if (this.stack.func_77978_p() != null && this.stack.func_77978_p().func_74764_b(TAG_ITEMS)) {
            if (this.stack.func_77978_p().func_74775_l(TAG_ITEMS).func_74764_b("slots")) {
                this.deserialize(this.stack.func_77978_p().func_74775_l(TAG_ITEMS));
            } else {
                this.readNBT(this.stack.func_77978_p());
            }
        }
    }

    public void writeItemStack() {
        if (this.isEmpty()) {
            this.stack.func_196083_e(TAG_ITEMS);
        } else {
            CompoundNBT tag = this.stack.func_196082_o();
            tag.func_218657_a(TAG_ITEMS, (INBT)this.serialize());
        }
    }

    protected boolean isSameItem(ItemStack a, ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    protected void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!itemstack.func_190926_b()) continue;
            this.setStackInSlot(i, stack.func_77946_l());
            stack.func_190920_e(0);
            return;
        }
    }

    protected void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!this.isSameItem(itemstack, stack)) continue;
            this.moveItemsBetweenStacks(stack, itemstack, i);
            if (!stack.func_190926_b()) continue;
            return;
        }
    }

    protected void moveItemsBetweenStacks(ItemStack source, ItemStack dest, int slot) {
        int i = Math.min(this.getSlotLimit(slot, dest), dest.func_77976_d());
        int j = Math.min(source.func_190916_E(), i - dest.func_190916_E());
        if (j > 0) {
            dest.func_190917_f(j);
            source.func_190918_g(j);
            this.markDirty();
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private void readNBT(CompoundNBT compound) {
        ManaAndArtifice.LOGGER.info("Upconverting old ritual kit to Practitioner's Pouch");
        NonNullList list = NonNullList.func_191197_a((int)this.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)list);
        int mySlotIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (((ItemStack)list.get(i)).func_190926_b()) continue;
            this.setStackInSlot(mySlotIndex++, (ItemStack)list.get(i));
        }
        this.writeItemStack();
    }
}

