/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.rituals.IRitualReagent;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.JEIInterop;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.interop.jei.ingredients.ManaweavePatternIngredient;
import com.ma.items.ItemInit;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 144;
    private int ySize = 169;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.Jei.RITUAL, 0, 0, this.xSize, this.ySize).setTextureSize(144, 169).build();
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.ritual", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemInit.RUNE_RITUAL_METAL.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.RITUAL;
    }

    public Class<? extends RitualRecipe> getRecipeClass() {
        return RitualRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RitualRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
        ArrayList<ManaweavePatternIngredient> patternIngredients = new ArrayList<ManaweavePatternIngredient>();
        IRitualReagent[][] reagents = recipe.getReagents();
        for (int i = 0; i < reagents.length; ++i) {
            for (int j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] == null || reagents[i][j].isEmpty() || reagents[i][j].isDynamic()) continue;
                recipeIngredients.add(Ingredient.func_234819_a_(MATags.smartLookupItem(reagents[i][j].getResourceLocation()).stream().map(item -> new ItemStack((IItemProvider)item))));
            }
        }
        for (String rLoc : recipe.getManaweavePatterns()) {
            patternIngredients.add(new ManaweavePatternIngredient(new ResourceLocation(rLoc)));
        }
        ingredients.setInputIngredients(recipeIngredients);
        ingredients.setInputs((IIngredientType)JEIInterop.MANAWEAVE_PATTERN, patternIngredients);
        if (!recipe.func_77571_b().func_190926_b() && recipe.func_77571_b().func_77973_b() != ItemInit.RUNE_RITUAL_METAL.get()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, RitualRecipe recipe, IIngredients ingredients) {
        int xPosOrigin;
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        int xc = this.xSize / 2 - 9;
        int yc = this.ySize / 2 + 2;
        int bounds = recipe.getLowerBound();
        int reagentIdx = 0;
        IRitualReagent[][] reagents = recipe.getReagents();
        int xPos = xPosOrigin = xc + 16 * bounds;
        int yPos = yc - 16 * bounds;
        for (int i = 0; i < reagents.length; ++i) {
            xPos = xPosOrigin;
            for (int j = 0; j < reagents[i].length; ++j) {
                if (reagents[i][j] != null && !reagents[i][j].isEmpty() && !reagents[i][j].isDynamic()) {
                    stackGroup.init(reagentIdx, true, xPos, yPos);
                    stackGroup.set(reagentIdx, (List)ingredients.getInputs(VanillaTypes.ITEM).get(reagentIdx));
                    ++reagentIdx;
                }
                xPos -= 16;
            }
            yPos += 16;
        }
    }

    public void draw(RitualRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int xPosOrigin;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
            TranslationTextComponent name = new TranslationTextComponent(recipe.func_199560_c().toString());
            TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
            int stringWidth = mc.field_71466_p.func_238414_a_((ITextProperties)name);
            int textX = this.xSize / 2 - stringWidth / 2;
            int textY = 5;
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(this.xSize / 2 - mc.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), 15.0f, color);
            GuiRenderUtils.renderFactionIcon(matrixStack, recipe.getFactionRequirement(), textX + stringWidth + 3, textY);
        }
        int squareSize = 16;
        int xc = this.xSize / 2 - 9;
        int yc = this.ySize / 2 + 2;
        int bounds = recipe.getLowerBound();
        int xPos = xPosOrigin = xc + squareSize * bounds;
        int yPos = yc - squareSize * bounds;
        mc.func_110434_K().func_110577_a(GuiTextures.WIDGETS);
        RenderSystem.enableBlend();
        int[][] pattern = recipe.getPattern();
        for (int i = 0; i < pattern.length; ++i) {
            xPos = xPosOrigin;
            for (int j = 0; j < pattern[i].length; ++j) {
                if (pattern[i][j] != 0) {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(xPos + 1), (int)(yPos + 1), (float)112.0f, (float)0.0f, (int)squareSize, (int)squareSize, (int)128, (int)128);
                }
                xPos -= squareSize;
            }
            yPos += squareSize;
        }
        RenderSystem.disableBlend();
    }
}

