/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeRunescribing
extends RecipeRendererBase {
    private RunescribingRecipe pattern;
    static final int POINT_RENDER_SIZE = 13;

    public RecipeRunescribing(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        this.pattern = pattern.isPresent() && pattern.get() instanceof RunescribingRecipe ? (RunescribingRecipe)pattern.get() : null;
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_RUNESCRIBING;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.pattern == null) {
            return;
        }
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        float scaleX = 1.5f;
        float scaleY = 1.5f;
        int startX = (int)((float)(x + 37) / scaleX);
        int startY = (int)((float)(y + 110) / scaleY);
        int grid = 12;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scaleX, (float)scaleY, (float)1.0f);
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((this.pattern.getHMutex() & 1L << count) != 0L) {
                    this.func_238474_b_(matrixStack, startX + j * grid, startY + i * grid, 26, 0, grid, 1);
                }
                if ((this.pattern.getVMutex() & 1L << count) != 0L) {
                    this.func_238474_b_(matrixStack, startX + (i + 1) * grid, startY + (j - 1) * grid, 26, 0, 1, grid);
                }
                ++count;
            }
        }
        RenderSystem.popMatrix();
        ItemStack output = this.pattern.func_77571_b();
        this.renderItemStack(output, x + this.field_230688_j_ / 2 - 8, y + 57);
        int tier = this.pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(this.pattern.func_77571_b().func_77977_a().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int stringWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = y + 5;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + 15), color);
        if (this.pattern.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, this.pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        return this.pattern != null ? this.pattern.getTier() : 1;
    }
}

