/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.RecipeRendererBase;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeArcaneFurnace
extends RecipeRendererBase {
    private ArcaneFurnaceRecipe recipe;

    public RecipeArcaneFurnace(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe == null) {
            return;
        }
        Item input = (Item)ForgeRegistries.ITEMS.getValue(this.recipe.getInputItem());
        Item output = (Item)ForgeRegistries.ITEMS.getValue(this.recipe.getOutputItem());
        if (input != null) {
            this.renderItemStack(new ItemStack((IItemProvider)input), x + 30, y + 75);
        }
        if (output != null) {
            this.renderItemStack(new ItemStack((IItemProvider)output), x + 171, y + 75);
        }
        int tier = this.recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
        TranslationTextComponent name = new TranslationTextComponent(this.recipe.func_77571_b().func_77977_a().toString());
        TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
        int stringWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)name);
        int textX = x + this.field_230688_j_ / 2 - stringWidth / 2;
        int textY = y + 5;
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        this.minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(x + this.field_230688_j_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), (float)(y + 15), color);
        if (this.recipe.getFactionRequirement() != Faction.NONE) {
            int xPadding = 3;
            this.renderFactionIcon(matrixStack, this.recipe.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_ARCANE_FURNACE;
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof ArcaneFurnaceRecipe) {
            this.recipe = (ArcaneFurnaceRecipe)pattern.get();
        }
    }

    @Override
    public int getTier() {
        return this.recipe != null ? this.recipe.getTier() : 1;
    }
}

