/*
 * Decompiled with CFR 0.152.
 */
package com.ma.guide.recipe;

import com.ma.gui.GuiTextures;
import com.ma.guide.recipe.ICyclingRecipeRenderer;
import com.ma.guide.recipe.RecipeRendererBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;

public class Recipe3x3
extends RecipeRendererBase
implements ICyclingRecipeRenderer<Recipe3x3> {
    private ICraftingRecipe[] recipes;
    static final int POINT_RENDER_SIZE = 13;

    public Recipe3x3(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(recipeLocation);
        if (pattern.isPresent()) {
            this.recipes = new ICraftingRecipe[]{(ICraftingRecipe)pattern.get()};
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.GUIDEBOOK_RECIPE_3X3;
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.length == 0) {
            return;
        }
        ICraftingRecipe recipe = this.recipes[this.getIndex()];
        if (recipe instanceof ShapedRecipe) {
            this.renderShapedRecipe(matrixStack, x, y, (ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            this.renderShapelessRecipe(matrixStack, x, y, (ShapelessRecipe)recipe);
        }
    }

    private void renderShapedRecipe(MatrixStack matrixStack, int x, int y, ShapedRecipe recipe) {
        if (recipe.getRecipeWidth() > 3 || recipe.getRecipeHeight() > 3) {
            return;
        }
        RenderSystem.pushMatrix();
        float scale = 2.0f;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        int startX = (int)((float)(x + 37) / scale);
        int startY = (int)((float)(y + 95) / scale);
        int pointSizeX = (int)(54.0f / scale);
        int pointSizeY = (int)(50.0f / scale);
        int padding = (int)(5.0f / scale);
        for (int j = 0; j < recipe.getRecipeHeight(); ++j) {
            for (int i = 0; i < recipe.getRecipeWidth(); ++i) {
                Ingredient ingredient;
                List<ItemStack> stacks;
                int ingredientIndex = j * recipe.getRecipeWidth() + i;
                if (ingredientIndex >= recipe.func_192400_c().size() || (stacks = Arrays.asList((ingredient = (Ingredient)recipe.func_192400_c().get(ingredientIndex)).func_193365_a())).size() <= 0) continue;
                this.renderItemStack(stacks, startX + (pointSizeX + padding) * i, startY + (pointSizeY + padding) * j, scale);
            }
        }
        this.renderItemStack(recipe.func_77571_b(), (int)((float)(x + 93) / scale), (int)((float)(y + 25) / scale), scale);
        RenderSystem.popMatrix();
    }

    private void renderShapelessRecipe(MatrixStack matrixStack, int x, int y, ShapelessRecipe recipe) {
        if (recipe.func_192400_c().size() > 9) {
            return;
        }
        RenderSystem.pushMatrix();
        float scale = 2.0f;
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.minecraft.field_71446_o.func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
        int startX = (int)((float)(x + 37) / scale);
        int startY = (int)((float)(y + 95) / scale);
        int pointSizeX = (int)(54.0f / scale);
        int pointSizeY = (int)(50.0f / scale);
        int padding = (int)(5.0f / scale);
        int count = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ItemStack[] stacks = ingredient.func_193365_a();
            if (stacks.length > 0) {
                this.renderItemStack(Arrays.asList(stacks), startX + (pointSizeX + padding) * Math.floorDiv(count, 3), startY + (pointSizeY + padding) * (count % 3), scale);
            }
            ++count;
        }
        this.renderItemStack(recipe.func_77571_b(), (int)((float)(x + 93) / scale), (int)((float)(y + 25) / scale), scale);
        RenderSystem.popMatrix();
        FontRenderer fr = this.minecraft.field_71466_p;
        String lineFormatted = I18n.func_135052_a((String)"gui.mana-and-artifice.shapeless", (Object[])new Object[0]);
        fr.func_238421_b_(matrixStack, lineFormatted, (float)(this.field_230690_l_ + this.field_230688_j_ / 2 - fr.func_78256_a(lineFormatted) / 2), (float)(this.field_230691_m_ + 67), 0x404040);
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional pattern = this.minecraft.field_71441_e.func_199532_z().func_215367_a(rLoc);
            if (!pattern.isPresent()) continue;
            recipes.add((ICraftingRecipe)pattern.get());
        }
        this.recipes = recipes.toArray(new ICraftingRecipe[0]);
    }

    @Override
    public int countRecipes() {
        return this.recipes.length;
    }
}

