/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.radial;

import com.google.common.collect.Lists;
import com.ma.KeybindInit;
import com.ma.events.ClientEventHandler;
import com.ma.gui.radial.GenericRadialMenu;
import com.ma.gui.radial.components.IRadialMenuHost;
import com.ma.gui.radial.components.RadialMenuItem;
import com.ma.gui.radial.components.TextRadialMenuItem;
import com.ma.items.artifice.ItemEnderDisk;
import com.ma.network.ClientMessageDispatcher;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EnderDiscPatternSelectionScreen
extends Screen {
    private ItemStack stackEquipped;
    private boolean needsRecheckStacks = true;
    private final List<RadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;
    private boolean forceclose = false;
    private Minecraft mc = Minecraft.func_71410_x();

    public EnderDiscPatternSelectionScreen() {
        super((ITextComponent)new StringTextComponent("RADIAL MENU"));
        this.stackEquipped = this.mc.field_71439_g.func_184614_ca();
        if (!(this.stackEquipped.func_77973_b() instanceof ItemEnderDisk)) {
            this.func_231175_as__();
        }
        this.menu = new GenericRadialMenu(Minecraft.func_71410_x(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(MatrixStack matrixStack, ItemStack stack, int mouseX, int mouseY) {
                EnderDiscPatternSelectionScreen.this.func_230457_a_(matrixStack, stack, mouseX, mouseY);
            }

            @Override
            public void renderTooltip(MatrixStack matrixStack, ITextComponent text, int mouseX, int mouseY) {
                EnderDiscPatternSelectionScreen.this.func_238652_a_(matrixStack, text, mouseX, mouseY);
            }

            @Override
            public Screen getScreen() {
                return EnderDiscPatternSelectionScreen.this;
            }

            @Override
            public FontRenderer getFontRenderer() {
                return EnderDiscPatternSelectionScreen.this.field_230712_o_;
            }

            @Override
            public ItemRenderer getItemRenderer() {
                return EnderDiscPatternSelectionScreen.this.field_230707_j_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof EnderDiscPatternSelectionScreen) {
            event.setCanceled(true);
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ClientEventHandler.wipeOpen();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.func_71410_x().func_147108_a(null);
            ClientEventHandler.wipeOpen();
        }
        if (!this.menu.isReady()) {
            return;
        }
        ItemStack inHand = this.field_230706_i_.field_71439_g.func_184614_ca();
        if (!(inHand.func_77973_b() instanceof ItemEnderDisk)) {
            this.forceclose = true;
        } else {
            ItemStack stack = inHand;
            if (stack.func_190916_E() <= 0) {
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.menu.close();
            }
        }
        if (this.forceclose) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (!ClientEventHandler.isKeyDown(KeybindInit.spellBookSelectWheelOpen)) {
            this.processClick(false);
            this.forceclose = true;
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < 7; ++i) {
                final int index = i;
                TextRadialMenuItem item = new TextRadialMenuItem(this.menu, ItemEnderDisk.getPatternName(this.stackEquipped, i)){

                    @Override
                    public boolean onClick() {
                        ClientMessageDispatcher.sendEnderDiscIndexChange(index);
                        return true;
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.needsRecheckStacks = false;
        }
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.ender_disc"));
        } else {
            this.menu.setCentralText(null);
        }
        this.menu.draw(matrixStack, partialTicks, mouseX, mouseY);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

