/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.item;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.gui.GuiTextures;
import com.ma.gui.base.GuiJEIDisable;
import com.ma.gui.block.GuiInscriptionTable;
import com.ma.gui.containers.item.ContainerSpellAdjustments;
import com.ma.network.ClientMessageDispatcher;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GuiSpellAdjust
extends GuiJEIDisable<ContainerSpellAdjustments> {
    ArrayList<ImageButton> shapeAttributeButtons;
    ArrayList<ImageButton> componentAttributeButtons;
    final float textScaleFactor = 0.5f;
    static final int textColor = ColorHelper.PackedColor.func_233006_a_((int)255, (int)49, (int)49, (int)49);
    static final int textColorLight = ColorHelper.PackedColor.func_233006_a_((int)255, (int)200, (int)200, (int)200);
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    int spellNameWidth = 1;
    String spellName = "";
    ITextComponent currentTooltip = null;
    IPlayerRoteSpells playerRote = null;
    IPlayerProgression playerProgression = null;

    public GuiSpellAdjust(ContainerSpellAdjustments screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playerRote = (IPlayerRoteSpells)this.field_230706_i_.field_71439_g.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.playerProgression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new ArrayList();
        this.spellName = ((ContainerSpellAdjustments)this.field_147002_h).getSpellName();
        this.spellNameWidth = this.field_230712_o_.func_78256_a(this.spellName);
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 223, this.field_147009_r + 7, 16, 16, 223, 152, 0, GuiTextures.SPELL_VALUES, 256, 256, button -> {
            this.func_231175_as__();
            ClientMessageDispatcher.sendRequestOpenSpellNameAndIconGUI();
        }));
        this.setupShapeAttributeButtons(((ContainerSpellAdjustments)this.field_147002_h).getShape().getPart());
        this.setupComponentAttributeButtons(((ContainerSpellAdjustments)this.field_147002_h).getComponent().getPart());
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(122, 45, this.shapeAttributeButtons, shape);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (int i = 0; i < 3; ++i) {
                Modifier modifier = ((ContainerSpellAdjustments)this.field_147002_h).getModifier(i);
                if (modifier == null || !modifier.modifiesType(attribute.getAttribute())) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButton upButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 1, this.field_147009_r + yOffset - 3, 8, 5, 0, 48, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerSpellAdjustments)this.field_147002_h).increaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButton downButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 1, this.field_147009_r + yOffset + 2, 8, 5, 0, 53, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerSpellAdjustments)this.field_147002_h).decreaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.func_230480_a_((Widget)new AttributeButton(this.field_147003_i + xOffset - 8, this.field_147009_r + yOffset - 2, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, attribute.getAttribute().getLocaleKey()));
            addTo.add(iconButton);
            ++count;
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.field_230710_m_.remove(button);
            this.field_230705_e_.remove(button);
        }
        attributeButtons.clear();
    }

    private void setupComponentAttributeButtons(Component component) {
        this.clearAttributeButtons(this.componentAttributeButtons);
        if (component == null) {
            return;
        }
        this.setupAttributeButtons(122, 92, this.componentAttributeButtons, component);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ClientMessageDispatcher.sendSpellAdjustmentMessage(((ContainerSpellAdjustments)this.field_147002_h).getRecipe(), ((ContainerSpellAdjustments)this.field_147002_h).getHand());
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        int col;
        int row;
        int xPos = 133;
        int yPos = 45;
        int count = 0;
        int text_y = 12;
        List split_lines = this.field_230712_o_.func_238420_b_().func_238365_g_(this.spellName, 150, Style.field_240709_b_);
        for (ITextProperties line : split_lines) {
            String textLine = line.getString();
            int snw = this.field_230712_o_.func_78256_a(textLine);
            this.field_230712_o_.func_238421_b_(matrixStack, textLine, (float)(this.field_146999_f / 2 - snw / 2), (float)text_y, textColor);
            this.field_230712_o_.getClass();
            text_y += 9;
        }
        ItemStack stack = ((ContainerSpellAdjustments)this.field_147002_h).getSpellStack();
        this.field_230707_j_.func_175042_a(stack, 7, 7);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (((ContainerSpellAdjustments)this.field_147002_h).getShape() != null) {
            this.field_230706_i_.field_71446_o.func_110577_a(((ContainerSpellAdjustments)this.field_147002_h).getShape().getPart().getGuiIcon());
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)150, (int)88, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            for (Attribute attribute : ((ContainerSpellAdjustments)this.field_147002_h).getShape().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerSpellAdjustments)this.field_147002_h).getShape().getValue(attribute));
                ++count;
            }
        }
        yPos += 47;
        count = 0;
        if (((ContainerSpellAdjustments)this.field_147002_h).getComponent() != null) {
            this.field_230706_i_.field_71446_o.func_110577_a(((ContainerSpellAdjustments)this.field_147002_h).getComponent().getPart().getGuiIcon());
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)150, (int)182, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            for (Attribute attribute : ((ContainerSpellAdjustments)this.field_147002_h).getComponent().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerSpellAdjustments)this.field_147002_h).getComponent().getValue(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 3; ++i) {
            Modifier m = ((ContainerSpellAdjustments)this.field_147002_h).getModifier(i);
            if (m == null) continue;
            this.field_230706_i_.field_71446_o.func_110577_a(m.getGuiIcon());
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(150 + 74 * i), (int)276, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        }
        String header = I18n.func_135052_a((String)"gui.mana-and-artifice.mana_cost", (Object[])new Object[0]) + ":";
        String manaCost = String.format("%.1f", Float.valueOf(((ContainerSpellAdjustments)this.field_147002_h).getManaCost((PlayerEntity)this.field_230706_i_.field_71439_g)));
        String complexityHeader = I18n.func_135052_a((String)"gui.mana-and-artifice.complexity", (Object[])new Object[0]) + ":";
        String complexity = String.format("%.1f / %d", Float.valueOf(((ContainerSpellAdjustments)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g)), this.playerProgression.getTierMaxComplexity());
        float manaCostWidth = (float)this.field_230712_o_.func_78256_a(manaCost) * 0.5f;
        float headerWidth = (float)this.field_230712_o_.func_78256_a(header) * 0.5f;
        float complexityHeaderWidth = (float)this.field_230712_o_.func_78256_a(complexityHeader) * 0.5f;
        float complexityWidth = (float)this.field_230712_o_.func_78256_a(complexity) * 0.5f;
        float padding = 2.0f;
        float summaryXPos = (float)(this.field_146999_f / 2) - (complexityHeaderWidth + complexityWidth + padding) / 2.0f;
        float summaryYPos = 182.0f;
        this.field_230712_o_.func_238421_b_(matrixStack, complexityHeader, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        summaryXPos += complexityHeaderWidth + padding;
        if (((ContainerSpellAdjustments)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g) <= (float)this.playerProgression.getTierMaxComplexity()) {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, TextFormatting.RED.func_211163_e().intValue());
        }
        summaryXPos = (float)(this.field_146999_f / 2) - (headerWidth + manaCostWidth + padding) / 2.0f;
        this.field_230712_o_.getClass();
        summaryYPos = 185.0f + 9.0f * 0.5f;
        this.field_230712_o_.func_238421_b_(matrixStack, header, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        this.field_230712_o_.func_238421_b_(matrixStack, manaCost, (summaryXPos += headerWidth + padding) / 0.5f, summaryYPos / 0.5f, textColor);
        RenderSystem.popMatrix();
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void drawAttributeValue(MatrixStack matrixStack, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        this.field_230712_o_.func_238421_b_(matrixStack, valueString, (float)x / 0.5f, (float)y / 0.5f, textColor);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.SPELL_VALUES);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        GuiSpellAdjust.func_238463_a_((MatrixStack)matrixStack, (int)i, (int)j, (float)0.0f, (float)145.0f, (int)247, (int)30, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiSpellAdjust.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f / 2 - 50), (int)(j + 170), (float)0.0f, (float)176.0f, (int)100, (int)30, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiSpellAdjust.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f / 2 - 60), (int)(j + 35), (float)0.0f, (float)0.0f, (int)120, (int)144, (int)this.field_146999_f, (int)this.field_147000_g);
    }

    class AttributeButton
    extends ImageButton {
        private ITextComponent tooltip;

        public AttributeButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn, String tooltip) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
            this.tooltip = new TranslationTextComponent(tooltip);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_230449_g_()) {
                GuiSpellAdjust.this.currentTooltip = this.tooltip;
            }
        }
    }
}

