/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.item;

import com.ma.Registries;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.sound.SFX;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.config.GeneralClientConfig;
import com.ma.gui.GuiTextures;
import com.ma.gui.base.SearchableGuiJeiDisable;
import com.ma.gui.block.GuiInscriptionTable;
import com.ma.gui.containers.item.ContainerRoteBook;
import com.ma.items.ItemInit;
import com.ma.items.SpellIconList;
import com.ma.items.sorcery.ItemSpell;
import com.ma.network.ClientMessageDispatcher;
import com.ma.recipes.ItemAndPatternRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiRoteBook
extends SearchableGuiJeiDisable<ContainerRoteBook> {
    private static final int MAX_COMPONENTS = 5;
    ImageButton[] pieceWidgets;
    ImageButton activeShapeButton;
    ImageButton[] activeComponentButtons;
    ArrayList<ImageButton> shapeAttributeButtons;
    HashMap<Integer, ArrayList<ImageButton>> componentAttributeButtons;
    ArrayList<ImageButton> inactiveCategoryButtons;
    ArrayList<ImageButton> activeCategoryButtons;
    private SpellPartList list;
    private Button nameAndIcon;
    final float textScaleFactor = 0.5f;
    static final int textColor = ColorHelper.PackedColor.func_233006_a_((int)255, (int)49, (int)49, (int)49);
    static final int textColorLight = ColorHelper.PackedColor.func_233006_a_((int)255, (int)200, (int)200, (int)200);
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    ITextComponent currentTooltip = null;
    IPlayerRoteSpells playerRote = null;
    IPlayerProgression playerProgression = null;
    private boolean namingSpell = true;
    private int page = 0;
    private int numPages = 0;
    private int hoveredIndex;
    TextFieldWidget nameBox;
    ITextComponent nameValue;
    ModelButton currentButton;
    private static ArrayList<Pair<Integer, Integer>> pipLocations = new ArrayList();
    ArrayList<ModelButton> iconButtons;
    private Button prev;
    private Button next;
    private Button clear;

    public GuiRoteBook(ContainerRoteBook screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.activeComponentButtons = new ImageButton[5];
        this.inactiveCategoryButtons = new ArrayList();
        this.activeCategoryButtons = new ArrayList();
        this.iconButtons = new ArrayList();
        this.numPages = (int)Math.floor((float)SpellIconList.ALL.length / 100.0f);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.list.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    protected void func_231160_c_() {
        int i;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.activeCategoryButtons.clear();
        this.inactiveCategoryButtons.clear();
        super.func_231160_c_();
        this.initSpellIcons();
        int tbWidth = 130;
        int x = this.field_147003_i + this.field_146999_f / 2 - tbWidth / 2;
        int y = this.field_147009_r + this.field_147000_g - 95;
        this.initSearch(this.field_147003_i + 6, this.field_147009_r + 185, 59, 18);
        this.playerRote = (IPlayerRoteSpells)this.field_230706_i_.field_71439_g.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.playerProgression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.nameAndIcon = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 228, this.field_147009_r + 12, 16, 16, 228, 12, 0, GuiTextures.BOOK_OF_ROTE, 256, 256, button -> this.toggleNaming()));
        this.list = new SpellPartList();
        this.field_230705_e_.add(this.list);
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new HashMap();
        for (i = 0; i < 5; ++i) {
            this.componentAttributeButtons.put(i, new ArrayList());
        }
        this.mapUIToCurrentSpell();
        x = this.field_147003_i + 256;
        y = this.field_147009_r + 6;
        for (i = 0; i < ((ContainerRoteBook)this.field_147002_h).getSize(); ++i) {
            int idx = i;
            if (i < 8) {
                this.inactiveCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 37, 22, 0, 0, 22, GuiTextures.BOOK_OF_ROTE_EXTRAS, 128, 128, btn -> {
                    this.setActiveIndex(idx);
                    ((ContainerRoteBook)this.field_147002_h).changeIndex(idx);
                    ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.field_147002_h).getIconIndex());
                    this.mapUIToCurrentSpell();
                }, i + 1, false)));
                this.activeCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 37, 22, 0, 44, 22, GuiTextures.BOOK_OF_ROTE_EXTRAS, 128, 128, btn -> {}, i + 1, true)));
            } else {
                this.inactiveCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 37, 22, 37, 0, 22, GuiTextures.BOOK_OF_ROTE_EXTRAS, 128, 128, btn -> {
                    this.setActiveIndex(idx);
                    ((ContainerRoteBook)this.field_147002_h).changeIndex(idx);
                    ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.field_147002_h).getIconIndex());
                    this.mapUIToCurrentSpell();
                }, i + 1, false)));
                this.activeCategoryButtons.add((ImageButton)this.func_230480_a_((Widget)new IndexButton(x, y, 37, 22, 37, 44, 22, GuiTextures.BOOK_OF_ROTE_EXTRAS, 128, 128, btn -> {}, i + 1, true)));
            }
            y += 22;
            if (i != 7) continue;
            x = this.field_147003_i - 37;
            y = this.field_147009_r + 6;
        }
        this.setActiveIndex(((ContainerRoteBook)this.field_147002_h).getActiveIndex());
        this.namingSpell = true;
        this.toggleNaming();
    }

    private void initSpellIcons() {
        int nameWidth = 218;
        int nameHeight = 256;
        int i = this.field_147003_i + this.field_146999_f / 2 - nameWidth / 2;
        int j = this.field_147009_r + this.field_147000_g / 2 - nameHeight / 2;
        this.currentButton = new ModelButton(this.field_147003_i + 12, j + 12, -1, btn -> {});
        this.field_230710_m_.add(this.currentButton);
        this.nameBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, i + nameWidth / 2 - 80, j + 10, 160, 20, this.nameValue);
        this.nameBox.func_146180_a(((ContainerRoteBook)this.field_147002_h).getName());
        this.nameBox.func_146203_f(60);
        this.nameBox.func_212954_a(this::nameChanged);
        this.field_230710_m_.add(this.nameBox);
        this.nameBox.func_146205_d(false);
        this.nameBox.func_146195_b(false);
        this.nameBox.func_231049_c__(true);
        this.func_231035_a_((IGuiEventListener)this.nameBox);
        this.page = 0;
        this.clear = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + this.field_146999_f - 28, this.field_147009_r + 12, 15, 18, 222, 7, 0, GuiTextures.SPELL_CUSTOMIZE, 256, 256, button -> this.toggleNaming()));
        this.prev = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 9, this.field_147009_r + this.field_147000_g - 18, 9, 14, 247, 31, 14, GuiTextures.SPELL_CUSTOMIZE, 256, 256, button -> {
            --this.page;
            if (this.page <= 0) {
                this.page = 0;
                this.prev.field_230693_o_ = false;
            }
            this.next.field_230693_o_ = true;
            this.initIconButtons();
            this.func_231035_a_((IGuiEventListener)this.nameBox);
        }));
        this.next = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + this.field_146999_f - 17, this.field_147009_r + this.field_147000_g - 18, 9, 14, 247, 60, 14, GuiTextures.SPELL_CUSTOMIZE, 256, 256, button -> {
            ++this.page;
            if (this.page >= this.numPages) {
                this.page = this.numPages;
                this.next.field_230693_o_ = false;
            }
            this.prev.field_230693_o_ = true;
            this.initIconButtons();
            this.func_231035_a_((IGuiEventListener)this.nameBox);
        }));
        this.prev.field_230693_o_ = false;
        i += 3;
        j += 20;
        this.initIconButtons();
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.namingSpell) {
                this.toggleNaming();
            } else {
                this.func_231175_as__();
            }
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        super.func_231044_a_(mouseX, mouseY, button);
        if (this.namingSpell) {
            this.func_231035_a_((IGuiEventListener)this.nameBox);
        }
        return false;
    }

    private void toggleNaming() {
        if (!this.namingSpell) {
            this.namingSpell = true;
            this.resetActiveSpell();
            this.list._active = false;
            this.nameAndIcon.field_230693_o_ = false;
            this.nameAndIcon.field_230694_p_ = false;
            this.searchBox.field_230693_o_ = false;
            this.searchBox.field_230694_p_ = false;
            this.page = 0;
            this.prev.field_230693_o_ = false;
            this.prev.field_230694_p_ = true;
            this.next.field_230693_o_ = true;
            this.next.field_230694_p_ = true;
            this.clear.field_230693_o_ = true;
            this.clear.field_230694_p_ = true;
            for (ModelButton btn : this.iconButtons) {
                btn.field_230693_o_ = true;
                btn.field_230694_p_ = true;
            }
            this.nameBox.field_230693_o_ = true;
            this.nameBox.field_230694_p_ = true;
            if (this.activeShapeButton != null) {
                this.activeShapeButton.field_230693_o_ = false;
                this.activeShapeButton.field_230694_p_ = false;
            }
            if (this.activeComponentButtons != null) {
                for (int i = 0; i < this.activeComponentButtons.length; ++i) {
                    if (this.activeComponentButtons[i] == null) continue;
                    this.activeComponentButtons[i].field_230693_o_ = false;
                    this.activeComponentButtons[i].field_230694_p_ = false;
                }
            }
        } else {
            this.namingSpell = false;
            this.page = 0;
            this.prev.field_230693_o_ = false;
            this.prev.field_230694_p_ = false;
            this.next.field_230693_o_ = false;
            this.next.field_230694_p_ = false;
            this.clear.field_230693_o_ = false;
            this.clear.field_230694_p_ = false;
            for (ModelButton btn : this.iconButtons) {
                btn.field_230693_o_ = false;
                btn.field_230694_p_ = false;
            }
            this.nameBox.field_230693_o_ = false;
            this.nameBox.field_230694_p_ = false;
            this.nameAndIcon.field_230693_o_ = true;
            this.nameAndIcon.field_230694_p_ = true;
            this.searchBox.field_230693_o_ = true;
            this.searchBox.field_230694_p_ = true;
            this.list._active = true;
            this.mapUIToCurrentSpell();
        }
    }

    private void nameChanged(String newName) {
        ((ContainerRoteBook)this.field_147002_h).setName(newName);
    }

    @Override
    protected void searchTermChanged(String newName) {
        this.currentSearchTerm = newName.toLowerCase();
        this.list.clear();
        this.list.reInit(this.currentSearchTerm);
    }

    private void initIconButtons() {
        int nameHeight = 256;
        int top = this.field_147009_r + this.field_147000_g / 2 - nameHeight / 2;
        for (ModelButton button2 : this.iconButtons) {
            this.field_230710_m_.remove((Object)button2);
            this.field_230705_e_.remove((Object)button2);
        }
        this.iconButtons.clear();
        int x = this.field_147003_i + 26;
        int y = top + 45;
        int count = 1;
        for (int i = this.page * 100; i < SpellIconList.ALL.length; ++i) {
            int idx = i;
            ModelButton btn = new ModelButton(x, y, i, button -> {
                ((ContainerRoteBook)this.field_147002_h).setIconIndex(idx);
                ItemSpell.setCustomIcon(this.currentButton.icon, idx);
            });
            this.func_230480_a_((Widget)btn);
            this.iconButtons.add(btn);
            x += 21;
            if (count % 10 == 0 && count != 0) {
                x = this.field_147003_i + 26;
                y += 21;
            }
            if (count == 100) break;
            ++count;
        }
        ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.field_147002_h).getIconIndex());
    }

    private void setActiveIndex(int index) {
        if (index < 0 || index >= this.activeCategoryButtons.size()) {
            return;
        }
        this.activeCategoryButtons.forEach(b -> {
            b.field_230693_o_ = false;
            b.field_230694_p_ = false;
        });
        this.inactiveCategoryButtons.forEach(b -> {
            b.field_230693_o_ = true;
            b.field_230694_p_ = true;
        });
        this.activeCategoryButtons.get((int)index).field_230693_o_ = true;
        this.activeCategoryButtons.get((int)index).field_230694_p_ = true;
        this.inactiveCategoryButtons.get((int)index).field_230693_o_ = false;
        this.inactiveCategoryButtons.get((int)index).field_230694_p_ = false;
    }

    private void resetActiveSpell() {
        this.setupShapeAttributeButtons(null);
        if (this.activeShapeButton != null) {
            this.field_230710_m_.remove(this.activeShapeButton);
            this.field_230705_e_.remove(this.activeShapeButton);
        }
        for (int index : this.componentAttributeButtons.keySet()) {
            this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        }
    }

    private void mapUIToCurrentSpell() {
        int i;
        this.resetActiveSpell();
        for (i = 0; i < this.activeComponentButtons.length; ++i) {
            this.field_230710_m_.remove(this.activeComponentButtons[i]);
            this.field_230705_e_.remove(this.activeComponentButtons[i]);
            this.activeComponentButtons[i] = null;
        }
        if (((ContainerRoteBook)this.field_147002_h).getShape() != null) {
            this.setupShapeWidgetsFor(((ContainerRoteBook)this.field_147002_h).getShape().getPart());
        }
        for (i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) == null) continue;
            this.setupComponentWidgetsFor(((ContainerRoteBook)this.field_147002_h).getComponent(i).getPart(), i);
        }
        this.nameBox.func_146180_a(((ContainerRoteBook)this.field_147002_h).getName());
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(60, 48, this.shapeAttributeButtons, shape);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (Modifier m : Registries.Modifier.getValues()) {
                if (!m.modifiesType(attribute.getAttribute()) || !this.playerRote.isRote(m) && !this.field_230706_i_.field_71439_g.func_184812_l_()) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButton upButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 1, this.field_147009_r + yOffset - 3, 8, 5, 0, 48, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerRoteBook)this.field_147002_h).increaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButton downButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 1, this.field_147009_r + yOffset + 2, 8, 5, 0, 53, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerRoteBook)this.field_147002_h).decreaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.func_230480_a_((Widget)new AttributeButton(this.field_147003_i + xOffset - 8, this.field_147009_r + yOffset - 2, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, attribute.getAttribute().getLocaleKey()));
            addTo.add(iconButton);
            ++count;
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.field_230710_m_.remove(button);
            this.field_230705_e_.remove(button);
        }
        attributeButtons.clear();
    }

    private void setupShapeWidgetsFor(Shape shape) {
        int texSize = 32;
        if (shape != null) {
            if (this.activeShapeButton != null) {
                this.field_230710_m_.remove(this.activeShapeButton);
                this.field_230705_e_.remove(this.activeShapeButton);
            }
            this.activeShapeButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 13, this.field_147009_r + 47, texSize, texSize, 0, 0, 0, shape.getGuiIcon(), texSize, texSize, button -> {
                ((ContainerRoteBook)this.field_147002_h).setShape(null);
                this.mapUIToCurrentSpell();
            }));
        }
        this.setupShapeAttributeButtons(shape);
    }

    private void OnShapeClicked(Shape shape) {
        ((ContainerRoteBook)this.field_147002_h).setShape(shape);
        this.mapUIToCurrentSpell();
    }

    private void setupComponentWidgetsFor(Component component, int index) {
        int texSize = 32;
        if (component != null) {
            if (this.activeComponentButtons[index] != null) {
                this.field_230710_m_.remove(this.activeComponentButtons[index]);
                this.field_230705_e_.remove(this.activeComponentButtons[index]);
            }
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index);
            this.activeComponentButtons[index] = (ImageButton)this.func_230480_a_((Widget)new ImageButton(coords.getKey().intValue(), coords.getValue().intValue(), 32, 32, 0, 0, 0, component.getGuiIcon(), 32, 32, button -> {
                ((ContainerRoteBook)this.field_147002_h).removeComponent(index);
                this.mapUIToCurrentSpell();
            }));
        }
        this.setupComponentAttributeButtons(component, index);
    }

    private void setupComponentAttributeButtons(Component component, int index) {
        this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        if (component == null) {
            return;
        }
        AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index, -this.field_147003_i + 47, -this.field_147009_r + 1);
        this.setupAttributeButtons(coords.getKey(), coords.getValue(), this.componentAttributeButtons.get(index), component);
    }

    private void OnComponentClicked(Component component) {
        for (int i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) != null) continue;
            ((ContainerRoteBook)this.field_147002_h).addComponent(component);
            this.mapUIToCurrentSpell();
            return;
        }
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index) {
        return this.getComponentRenderCoordinates(index, 0, 0);
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index, int offsetX, int offsetY) {
        int x = this.field_147003_i + 13;
        int y = this.field_147009_r + 94;
        if (index == 1 || index == 4) {
            y += 47;
        }
        if (index == 2) {
            y -= 47;
        }
        if (index > 1) {
            x += 124;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(x + offsetX, y + offsetY);
    }

    public void func_231164_f_() {
        this.checkAndShowDamageStackingTip();
        super.func_231164_f_();
        ((ContainerRoteBook)this.field_147002_h).copySpellChangesToInventory();
        ClientMessageDispatcher.sendRoteSpellsUpdate((ContainerRoteBook)this.field_147002_h);
    }

    private void checkAndShowDamageStackingTip() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)GeneralClientConfig.DAMAGE_STACKING_TIP_SHOWN.get()).booleanValue() && ((ContainerRoteBook)this.field_147002_h).countNonDelayedDamageComponents() > 1) {
            GeneralClientConfig.DAMAGE_STACKING_TIP_SHOWN.set((Object)true);
            mc.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("helptip.mana-and-artifice.damage_type_stacking").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        this.hoveredIndex = -1;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.namingSpell) {
            return;
        }
        int xPos = 71;
        int yPos = 48;
        int count = 0;
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (((ContainerRoteBook)this.field_147002_h).getShape() != null) {
            for (Attribute attribute : ((ContainerRoteBook)this.field_147002_h).getShape().getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerRoteBook)this.field_147002_h).getShape().getValue(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 5; ++i) {
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(i, -this.field_147003_i + 58, -this.field_147009_r + 1);
            xPos = coords.getKey();
            yPos = coords.getValue();
            count = 0;
            if (((ContainerRoteBook)this.field_147002_h).getComponent(i) == null) continue;
            for (Attribute attribute : ((ContainerRoteBook)this.field_147002_h).getComponent(i).getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerRoteBook)this.field_147002_h).getComponent(i).getValue(attribute));
                ++count;
            }
        }
        String header = I18n.func_135052_a((String)"gui.mana-and-artifice.mana_cost", (Object[])new Object[0]) + ":";
        String manaCost = String.format("%.1f", Float.valueOf(((ContainerRoteBook)this.field_147002_h).getManaCost((PlayerEntity)this.field_230706_i_.field_71439_g)));
        String complexityHeader = I18n.func_135052_a((String)"gui.mana-and-artifice.complexity", (Object[])new Object[0]) + ":";
        String complexity = String.format("%.1f / %d", Float.valueOf(((ContainerRoteBook)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g)), this.playerProgression.getTierMaxComplexity());
        float manaCostWidth = (float)this.field_230712_o_.func_78256_a(manaCost) * 0.5f;
        float headerWidth = (float)this.field_230712_o_.func_78256_a(header) * 0.5f;
        float complexityHeaderWidth = (float)this.field_230712_o_.func_78256_a(complexityHeader) * 0.5f;
        float padding = 2.0f;
        float summaryXPos = 35.0f;
        float summaryYPos = 25.0f;
        this.field_230712_o_.func_238421_b_(matrixStack, complexityHeader, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        summaryXPos += complexityHeaderWidth + padding;
        if (((ContainerRoteBook)this.field_147002_h).getComplexity((PlayerEntity)this.field_230706_i_.field_71439_g) <= (float)this.playerProgression.getTierMaxComplexity()) {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, complexity, summaryXPos / 0.5f, summaryYPos / 0.5f, TextFormatting.RED.func_211163_e().intValue());
        }
        summaryXPos = (float)(this.field_146999_f - 33) - headerWidth - manaCostWidth - padding;
        summaryYPos = 25.0f;
        this.field_230712_o_.func_238421_b_(matrixStack, header, summaryXPos / 0.5f, summaryYPos / 0.5f, textColor);
        this.field_230712_o_.func_238421_b_(matrixStack, manaCost, (summaryXPos += headerWidth + padding) / 0.5f, summaryYPos / 0.5f, textColor);
        RenderSystem.popMatrix();
        StringTextComponent curSpellName = new StringTextComponent(((ContainerRoteBook)this.field_147002_h).getName());
        int curNameWidth = this.field_230712_o_.func_238414_a_((ITextProperties)curSpellName);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)curSpellName, (float)(this.field_146999_f / 2 - curNameWidth / 2), 12.0f, textColor);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.BOOK_OF_ROTE_EXTRAS);
        for (int d = 0; d < 16; ++d) {
            Pair<Integer, Integer> pip = pipLocations.get(d);
            if (((ContainerRoteBook)this.field_147002_h).getActiveIndex() == d) {
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)((Integer)pip.getFirst()), (int)((Integer)pip.getSecond()), (float)0.0f, (float)126.0f, (int)2, (int)2, (int)128, (int)128);
            }
            if (this.hoveredIndex != d) continue;
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)((Integer)pip.getFirst()), (int)((Integer)pip.getSecond()), (float)0.0f, (float)124.0f, (int)2, (int)2, (int)128, (int)128);
        }
    }

    private void drawAttributeValue(MatrixStack matrixStack, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        this.field_230712_o_.func_238421_b_(matrixStack, valueString, (float)x / 0.5f, (float)y / 0.5f, textColor);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.BOOK_OF_ROTE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_238474_b_(matrixStack, i + 54, j + 178, 54, 178, 148, 78);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.namingSpell) {
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.SPELL_CUSTOMIZE);
            int bannerWidth = 246;
            int bannerHeight = 30;
            GuiRoteBook.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f / 2 - bannerWidth / 2), (int)(j + 5), (float)0.0f, (float)0.0f, (int)bannerWidth, (int)bannerHeight, (int)this.field_146999_f, (int)this.field_147000_g);
            int iconsWidth = 219;
            int iconsHeight = 219;
            GuiRoteBook.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f / 2 - iconsWidth / 2), (int)(j + 38), (float)0.0f, (float)31.0f, (int)iconsWidth, (int)iconsHeight, (int)this.field_146999_f, (int)this.field_147000_g);
        }
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.list._scrolling) {
            return this.list.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    static {
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)224, (Object)202));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)230, (Object)203));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)236, (Object)206));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)239, (Object)212));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)240, (Object)218));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)239, (Object)224));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)236, (Object)230));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)230, (Object)233));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)224, (Object)234));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)218, (Object)233));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)212, (Object)230));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)209, (Object)224));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)208, (Object)218));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)209, (Object)212));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)212, (Object)206));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)218, (Object)203));
    }

    class ModelButton
    extends Button {
        public ItemStack icon;

        public ModelButton(int x, int y, int index, Button.IPressable pressedAction) {
            super(x, y, 16, 16, (ITextComponent)new StringTextComponent(""), pressedAction);
            this.icon = new ItemStack((IItemProvider)ItemInit.SPELL.get());
            ItemSpell.setCustomIcon(this.icon, index);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            GuiRoteBook.this.field_230707_j_.func_180450_b(this.icon, this.field_230690_l_, this.field_230691_m_);
        }

        public boolean func_231049_c__(boolean focus) {
            return false;
        }
    }

    public class IndexButton
    extends ImageButton {
        boolean isActive;
        int index;

        public IndexButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, int index, boolean active) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, (ITextComponent)new StringTextComponent(""));
            this.index = index;
            this.isActive = active;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mousex, int mousey, float partialTick) {
            super.func_230431_b_(matrixStack, mousex, mousey, partialTick);
            if (this.field_230693_o_ && this.field_230694_p_) {
                boolean left = this.index > 8;
                ItemStack spellStack = ((ContainerRoteBook)GuiRoteBook.this.field_147002_h).getStack(this.index - 1);
                GuiRoteBook.this.field_230707_j_.func_180450_b(spellStack, left ? this.field_230690_l_ + 18 : this.field_230690_l_ + 3, this.field_230691_m_ + 3);
                if (this.func_230449_g_()) {
                    GuiRoteBook.this.hoveredIndex = this.index - 1;
                }
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    class AttributeButton
    extends ImageButton {
        private ITextComponent tooltip;

        public AttributeButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn, String tooltip) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
            this.tooltip = new TranslationTextComponent(tooltip);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_230449_g_()) {
                GuiRoteBook.this.currentTooltip = this.tooltip;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SpellPartList
    extends ExtendedList<SpellPartEntry> {
        private boolean _scrolling;
        public boolean _active;
        private final int tier;

        public SpellPartList() {
            super(GuiRoteBook.this.field_230706_i_, 113, 57, GuiRoteBook.this.field_147009_r + 190, GuiRoteBook.this.field_147009_r + 247, 24);
            this._scrolling = false;
            this._active = true;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 24);
            this.field_230675_l_ = GuiRoteBook.this.field_147003_i + 64;
            this.field_230674_k_ = this.field_230675_l_ + 113;
            this.tier = ((IPlayerProgression)this.field_230668_b_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)).getTier();
            this.reInit("");
        }

        public void clear() {
            this.func_230963_j_();
        }

        public void reInit(String searchTerm) {
            this.addIconsForAll(Registries.Shape.getValues().stream().filter(s -> {
                if (!((GuiRoteBook)GuiRoteBook.this).field_230706_i_.field_71439_g.func_184812_l_() && !GuiRoteBook.this.playerRote.isRote((ISpellComponent)s)) {
                    return false;
                }
                boolean valid = s.isCraftable(new SpellCraftingContext((PlayerEntity)this.field_230668_b_.field_71439_g));
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= this.tier;
                }
                return valid;
            }).filter(s -> {
                String translatedName = I18n.func_135052_a((String)s.getRegistryName().toString(), (Object[])new Object[0]).toLowerCase();
                return searchTerm == "" || translatedName.contains(searchTerm);
            }).collect(Collectors.toList()), s -> GuiRoteBook.this.OnShapeClicked((Shape)s));
            this.addIconsForAll(Registries.Component.getValues().stream().filter(s -> {
                if (!((GuiRoteBook)GuiRoteBook.this).field_230706_i_.field_71439_g.func_184812_l_() && !GuiRoteBook.this.playerRote.isRote((ISpellComponent)s)) {
                    return false;
                }
                boolean valid = s.isCraftable(null);
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= this.tier;
                }
                return valid;
            }).filter(s -> {
                String translatedName = I18n.func_135052_a((String)s.getRegistryName().toString(), (Object[])new Object[0]).toLowerCase();
                return searchTerm == "" || translatedName.contains(searchTerm);
            }).collect(Collectors.toList()), s -> GuiRoteBook.this.OnComponentClicked((Component)s));
        }

        private <T extends ISpellComponent> void addIconsForAll(Collection<T> parts, Consumer<ISpellComponent> clickHandler) {
            int itemsPerRow = 5;
            ArrayList<ISpellComponent> segment = new ArrayList<ISpellComponent>();
            for (ISpellComponent part : parts) {
                segment.add(part);
                if (segment.size() != itemsPerRow) continue;
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
                segment.clear();
            }
            if (segment.size() > 0) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (!this._active) {
                return;
            }
            int scrollBarStartX = this.func_230952_d_();
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            if (this.func_230955_e_() > 0) {
                this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE_WIDGETS);
                int scrollBarHeight = 20;
                int top = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarHeight) / this.func_230955_e_() + this.field_230672_i_;
                if (top < this.field_230672_i_) {
                    top = this.field_230672_i_;
                }
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)scrollBarStartX, (int)top, (float)25.0f, (float)20.0f, (int)4, (int)scrollBarHeight, (int)128, (int)128);
            }
            this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.BOOK_OF_ROTE);
            int i = GuiRoteBook.this.field_147003_i;
            int j = GuiRoteBook.this.field_147009_r;
            this.func_238474_b_(matrixStack, i, j, 0, 0, GuiRoteBook.this.field_146999_f, 190);
            this.func_238474_b_(matrixStack, i + 54, j + 246, 54, 246, 148, 10);
        }

        protected void func_238478_a_(MatrixStack p_238478_1_, int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float p_238478_6_) {
            int i = this.func_230965_k_();
            for (int j = 0; j < i; ++j) {
                int k = this.func_230962_i_(j);
                int l = this.getRowBottom(j);
                if (l <= this.field_230672_i_ || k >= this.field_230673_j_ - 10) continue;
                int j1 = this.field_230669_c_ - 4;
                SpellPartEntry e = (SpellPartEntry)this.func_230953_d_(j);
                int k1 = this.func_230949_c_();
                int j2 = this.func_230968_n_();
                e.func_230432_a_(p_238478_1_, j, k, j2, k1, j1, p_238478_4_, p_238478_5_, this.func_231047_b_(p_238478_4_, p_238478_5_) && Objects.equals(this.func_230933_a_(p_238478_4_, p_238478_5_), (Object)e), p_238478_6_);
            }
        }

        @Nullable
        protected final SpellPartEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.func_230968_n_();
            int upperXBound = lowerXBound + this.func_230949_c_();
            int adjustedY = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) + (int)this.func_230966_l_();
            int index = adjustedY / this.field_230669_c_;
            if (index >= 0 && adjustedY >= 0 && index < this.func_230965_k_() && mouseX < (double)this.func_230952_d_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (SpellPartEntry)((Object)this.func_231039_at__().get(index));
            }
            return null;
        }

        protected int func_230952_d_() {
            return this.func_230968_n_() + this.func_230949_c_();
        }

        protected int func_230962_i_(int p_getRowTop_1_) {
            return this.field_230672_i_ - (int)this.func_230966_l_() + p_getRowTop_1_ * this.field_230669_c_ - 4;
        }

        private int getRowBottom(int p_230948_1_) {
            return this.func_230962_i_(p_230948_1_) + this.field_230669_c_;
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected void func_230947_b_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.func_230947_b_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.func_230952_d_() && p_updateScrollingState_1_ < (double)(this.func_230952_d_() + 6);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!this._active) {
                return false;
            }
            this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            SpellPartEntry e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.func_231049_c__(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.func_231037_b__(true);
                return true;
            }
            return this._scrolling;
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        public void setSelected(@Nullable SpellPartEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class SpellPartEntry
        extends ExtendedList.AbstractListEntry<SpellPartEntry> {
            private Collection<ISpellComponent> parts;
            private int spacing = 20;
            private ISpellComponent _hoveredComponent;
            private Consumer<ISpellComponent> _clickHandler;

            public SpellPartEntry(Collection<ISpellComponent> parts, Consumer<ISpellComponent> clickHandler) {
                this.parts = new ArrayList<ISpellComponent>(parts);
                this._hoveredComponent = null;
                this._clickHandler = clickHandler;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                for (ISpellComponent part : this.parts) {
                    if (part == null) continue;
                    int x = 5 + left + i++ * this.spacing;
                    int y = top + 4;
                    this.renderIcon(matrixStack, x, y, part.getGuiIcon());
                    if (!isHovered || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiRoteBook.this.currentTooltip = new TranslationTextComponent(part.getRegistryName().toString());
                    this._hoveredComponent = part;
                }
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                SpellPartList.this.setSelected(this);
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent);
                }
                return true;
            }

            private void renderIcon(MatrixStack matrixStack, int x, int y, ResourceLocation item) {
                SpellPartList.this.field_230668_b_.func_110434_K().func_110577_a(item);
                int size = 18;
                AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)GuiRoteBook.this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
            }
        }
    }
}

