/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IDamageComponent;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Shape;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.gui.containers.ContainerInit;
import com.ma.inventory.SpellInventory;
import com.ma.items.IBagItem;
import com.ma.items.sorcery.ItemSpell;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.network.ClientMessageDispatcher;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class ContainerRoteBook
extends Container {
    public SpellInventory roteBook;
    private SpellRecipe currentSpellRecipe = null;
    private int index = 0;

    public ContainerRoteBook(int id, PlayerInventory playerInv) {
        this(id, playerInv, ((IPlayerMagic)playerInv.field_70458_d.getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getRoteInventory(), ItemSpellBook.getActiveSpellSlot(playerInv.field_70458_d.func_184614_ca()));
    }

    public ContainerRoteBook(int id, PlayerInventory playerInv, SpellInventory roteBook, int curIndex) {
        super(ContainerInit.ROTE_BOOK, id);
        this.roteBook = roteBook;
        this.changeIndex(curIndex);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        return held.func_77973_b() instanceof IBagItem;
    }

    @Nullable
    public ModifiedSpellPart<Shape> getShape() {
        if (this.currentSpellRecipe == null) {
            return null;
        }
        return this.currentSpellRecipe.getShape();
    }

    public void setShape(Shape shape) {
        if (this.currentSpellRecipe != null) {
            this.currentSpellRecipe.setShape(shape);
        }
    }

    public void addComponent(Component component) {
        if (this.currentSpellRecipe != null) {
            this.currentSpellRecipe.addComponent(component);
        }
    }

    public void removeComponent(int index) {
        if (this.currentSpellRecipe != null) {
            this.currentSpellRecipe.removeComponent(index);
        }
    }

    public float getManaCost(PlayerEntity player) {
        if (this.currentSpellRecipe == null) {
            return 0.0f;
        }
        this.currentSpellRecipe.calculateManaCost();
        SpellCaster.applyAdjusters(ItemStack.field_190927_a, player, this.currentSpellRecipe, SpellCastStage.SPELLCRAFTING_MANA_COST_ESTIMATE);
        return this.currentSpellRecipe.isChanneled() ? this.currentSpellRecipe.getManaCost() * 20.0f : this.currentSpellRecipe.getManaCost();
    }

    public float getComplexity(PlayerEntity player) {
        if (this.currentSpellRecipe == null) {
            return 0.0f;
        }
        this.currentSpellRecipe.calculateComplexity();
        return this.currentSpellRecipe.getComplexity();
    }

    public void increaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int count = isShiftDown ? 5 : 1;
        for (int i = 0; i < count; ++i) {
            int index;
            if (part instanceof Shape) {
                this.currentSpellRecipe.changeShapeAttributeValue(attribute, ((ModifiedSpellPart)this.currentSpellRecipe.getShape()).stepUp(attribute));
                continue;
            }
            if (!(part instanceof Component) || (index = this.currentSpellRecipe.findComponent((Component)part)) <= -1) continue;
            this.currentSpellRecipe.changeComponentAttributeValue(index, attribute, ((ModifiedSpellPart)this.currentSpellRecipe.getComponent(index)).stepUp(attribute));
        }
    }

    public void decreaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int count = isShiftDown ? 5 : 1;
        for (int i = 0; i < count; ++i) {
            int index;
            if (part instanceof Shape) {
                this.currentSpellRecipe.changeShapeAttributeValue(attribute, ((ModifiedSpellPart)this.currentSpellRecipe.getShape()).stepDown(attribute));
                continue;
            }
            if (!(part instanceof Component) || (index = this.currentSpellRecipe.findComponent((Component)part)) <= -1) continue;
            this.currentSpellRecipe.changeComponentAttributeValue(index, attribute, ((ModifiedSpellPart)this.currentSpellRecipe.getComponent(index)).stepDown(attribute));
        }
    }

    @Nullable
    public ModifiedSpellPart<Component> getComponent(int index) {
        if (this.currentSpellRecipe == null) {
            return null;
        }
        return this.currentSpellRecipe.getComponent(index);
    }

    public void changeIndex(int newIndex) {
        if (newIndex < 0 || newIndex >= this.roteBook.func_70302_i_()) {
            return;
        }
        this.copySpellChangesToInventory();
        this.index = newIndex;
        ItemStack stack = this.roteBook.func_70301_a(newIndex);
        this.currentSpellRecipe = SpellRecipe.fromNBT(stack.func_77978_p());
        this.currentSpellRecipe.setMysterious(false);
    }

    public int getSize() {
        return this.roteBook.func_70302_i_();
    }

    public void copySpellChangesToInventory() {
        if (this.currentSpellRecipe != null) {
            this.currentSpellRecipe.writeToNBT(this.roteBook.func_70301_a(this.index).func_196082_o());
            ClientMessageDispatcher.sendSpellBookSlotChange(this.index);
        }
    }

    public int getActiveIndex() {
        return this.index;
    }

    public void setName(String name) {
        this.roteBook.func_70301_a(this.index).func_200302_a((ITextComponent)new StringTextComponent(name));
    }

    public void setIconIndex(int index) {
        ItemSpell.setCustomIcon(this.roteBook.func_70301_a(this.index), index);
    }

    public int getIconIndex() {
        return ItemSpell.getCustomIcon(this.roteBook.func_70301_a(this.index));
    }

    public ItemStack getStack(int index) {
        return this.roteBook.func_70301_a(index);
    }

    public String getName() {
        return this.roteBook.func_70301_a(this.index).func_200301_q().getString();
    }

    public int countNonDelayedDamageComponents() {
        MutableInt count = new MutableInt(0);
        this.currentSpellRecipe.iterateComponents(c -> {
            if (c.getPart() instanceof IDamageComponent && c.getValue(Attribute.DELAY) == 0.0f) {
                count.increment();
            }
        });
        return count.getValue();
    }
}

