/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.cantrips.CantripRegistry;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.containers.ContainerInit;
import com.ma.gui.containers.slots.SingleItemSlot;
import com.ma.items.ItemInit;
import com.ma.items.manaweaving.ItemManaweaverWand;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ContainerCantrips
extends Container {
    private IInventory inventory;
    private int NUM_SLOTS = 0;
    private static final int SLOT_RIGHT_X = 180;
    private static final int SLOT_LEFT_X = 59;
    private static final int SLOT_Y_BASE = 9;
    private static final int SLOT_Y_OFFSET = 54;
    private HashMap<Integer, ArrayList<SingleItemSlot>> slots_per_page = new HashMap();

    public ContainerCantrips(int i, PlayerInventory playerInventory) {
        this(i, playerInventory, ((IPlayerMagic)playerInventory.field_70458_d.getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getCantripData().getAsInventory());
    }

    public ContainerCantrips(int i, PlayerInventory playerInv, IInventory grimoireInv) {
        super(ContainerInit.CANTRIPS, i);
        this.inventory = grimoireInv;
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(PlayerInventory playerInv) {
        MutableInt tier = new MutableInt(0);
        playerInv.field_70458_d.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> tier.setValue(p.getTier()));
        MutableInt cantrip_index = new MutableInt(0);
        CantripRegistry.INSTANCE.getCantrips(tier.getValue()).stream().filter(c -> c.getTier() <= tier.getValue()).forEach(c -> {
            if (!c.isStackLocked()) {
                int x = (float)cantrip_index.getValue().intValue() % 6.0f < 3.0f ? 59 : 180;
                int y = 9 + 54 * (cantrip_index.getValue() % 3);
                SingleItemSlot slot = new SingleItemSlot((IItemHandler)new InvWrapper(this.inventory), this.NUM_SLOTS, x, y, (Item)ItemInit.SPELL.get());
                this.func_75146_a((Slot)slot);
                int page = (int)Math.floor(cantrip_index.getValue() / 6);
                ArrayList<SingleItemSlot> pageSlots = this.slots_per_page.getOrDefault(page, new ArrayList());
                pageSlots.add(slot);
                this.slots_per_page.put(page, pageSlots);
                ++this.NUM_SLOTS;
            }
            cantrip_index.increment();
        });
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInv, j1 + l * 9 + 9, 48 + j1 * 18, 179 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInv, i1, 48 + i1 * 18, 237));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void enableSlotsForPage(int page) {
        this.slots_per_page.values().forEach(al -> al.forEach(slot -> slot.setActive(false)));
        if (this.slots_per_page.containsKey(page)) {
            this.slots_per_page.get(page).forEach(slot -> slot.setActive(true));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        try {
            if (this.func_75139_a(slotId).func_75211_c().func_77973_b() instanceof ItemManaweaverWand) {
                return ItemStack.field_190927_a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.NUM_SLOTS ? !this.func_75135_a(itemstack1, this.NUM_SLOTS, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.NUM_SLOTS, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

