/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.entity;

import com.ma.gui.containers.ContainerInit;
import com.ma.items.ItemInit;
import com.ma.items.ritual.ItemThaumaturgicLink;
import net.minecraft.entity.Entity;
import net.minecraft.entity.NPCMerchant;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.MerchantInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class ContainerWanderingWizard
extends Container {
    private final IMerchant merchant;
    private final MerchantInventory merchantInventory;
    private int merchantLevel;
    private boolean hasXPBar;
    private boolean canRestock;
    private boolean finalized = false;

    public ContainerWanderingWizard(int id, PlayerInventory playerInventoryIn) {
        this(id, playerInventoryIn, (IMerchant)new NPCMerchant(playerInventoryIn.field_70458_d));
    }

    public ContainerWanderingWizard(int id, PlayerInventory inv, IMerchant merchant) {
        super(ContainerInit.WANDERING_WIZARD, id);
        this.merchant = merchant;
        this.merchantInventory = new MerchantInventory(merchant);
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 0, 154, 6));
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 1, 179, 6));
        this.func_75146_a((Slot)new MerchantResultSlot(inv.field_70458_d, merchant, this.merchantInventory, 2, 234, 6));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 48 + j * 18, 174 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inv, k, 48 + k * 18, 232));
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.merchantInventory.func_70470_g();
        super.func_75130_a(inventoryIn);
    }

    public void setCurrentRecipeIndex(int currentRecipeIndex) {
        this.merchantInventory.func_70471_c(currentRecipeIndex);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.merchant.func_70931_l_() == playerIn;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    private void playMerchantYesSound() {
        if (!this.merchant.func_190670_t_().field_72995_K) {
            Entity entity = (Entity)this.merchant;
            this.merchant.func_190670_t_().func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.merchant.func_213714_ea(), SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
                this.playMerchantYesSound();
            } else if (index != 0 && index != 1 ? (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(itemstack1, 3, 30, false)) : !this.func_75135_a(itemstack1, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.merchant.func_70932_a_((PlayerEntity)null);
        if (!this.merchant.func_190670_t_().field_72995_K) {
            if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                ItemStack itemstack = this.merchantInventory.func_70304_b(0);
                if (!itemstack.func_190926_b()) {
                    playerIn.func_71019_a(itemstack, false);
                }
                if (!(itemstack = this.merchantInventory.func_70304_b(1)).func_190926_b()) {
                    playerIn.func_71019_a(itemstack, false);
                }
            } else {
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.merchantInventory.func_70304_b(0));
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.merchantInventory.func_70304_b(1));
            }
        }
    }

    public void setClientSideOffers(MerchantOffers offers) {
        MerchantOffers existing = this.merchant.func_213706_dY();
        offers.forEach(o -> existing.add(o));
    }

    public void setXp(int xp) {
        this.merchant.func_213702_q(xp);
    }

    public void setMerchantLevel(int level) {
        this.merchantLevel = level;
    }

    public void setCanRestock(boolean canRestock) {
        this.canRestock = canRestock;
    }

    public void setHaxXPBar(boolean hasXPBar) {
        this.hasXPBar = hasXPBar;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public MerchantOffers getOffers() {
        return this.merchant.func_213706_dY();
    }

    public void setCurrentTradeRecipeItems(int selectedIndex) {
        if (this.getOffers().size() > selectedIndex) {
            ItemStack itemstack1;
            ItemStack itemstack = this.merchantInventory.func_70301_a(0);
            if (!itemstack.func_190926_b()) {
                if (!this.func_75135_a(itemstack, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.func_70299_a(0, itemstack);
            }
            if (!(itemstack1 = this.merchantInventory.func_70301_a(1)).func_190926_b()) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.func_70299_a(1, itemstack1);
            }
            if (this.merchantInventory.func_70301_a(0).func_190926_b() && this.merchantInventory.func_70301_a(1).func_190926_b()) {
                ItemStack itemstack2 = ((MerchantOffer)this.getOffers().get(selectedIndex)).func_222205_b();
                this.pullItemFromPlayerInventory(0, itemstack2);
                ItemStack itemstack3 = ((MerchantOffer)this.getOffers().get(selectedIndex)).func_222202_c();
                this.pullItemFromPlayerInventory(1, itemstack3);
            }
        }
    }

    private void pullItemFromPlayerInventory(int p_217053_1_, ItemStack p_217053_2_) {
        if (!p_217053_2_.func_190926_b()) {
            for (int i = 3; i < 39; ++i) {
                ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                if (itemstack.func_190926_b() || !this.areItemStacksEqual(p_217053_2_, itemstack)) continue;
                ItemStack itemstack1 = this.merchantInventory.func_70301_a(p_217053_1_);
                int j = itemstack1.func_190926_b() ? 0 : itemstack1.func_190916_E();
                int k = Math.min(p_217053_2_.func_77976_d() - j, itemstack.func_190916_E());
                ItemStack itemstack2 = itemstack.func_77946_l();
                int l = j + k;
                itemstack.func_190918_g(k);
                itemstack2.func_190920_e(l);
                this.merchantInventory.func_70299_a(p_217053_1_, itemstack2);
                if (l >= p_217053_2_.func_77976_d()) break;
            }
        }
    }

    private boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int calculateIndexFor(MerchantOffer offer, int index, String currentSearchTerm) {
        if (currentSearchTerm == "" || currentSearchTerm == null) {
            return index;
        }
        ResourceLocation oLoc = ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getLocationKey(offer.func_222200_d());
        if (oLoc == null) {
            return index;
        }
        for (int i = 0; i < this.getOffers().size(); ++i) {
            MerchantOffer cur = (MerchantOffer)this.getOffers().get(i);
            ResourceLocation curLoc = ((ItemThaumaturgicLink)ItemInit.THAUMATURGIC_LINK.get()).getLocationKey(cur.func_222200_d());
            if (curLoc == null || !curLoc.equals((Object)oLoc)) continue;
            return i;
        }
        return -1;
    }
}

