/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.block;

import com.ma.blocks.tileentities.MagiciansWorkbenchTile;
import com.ma.gui.containers.ContainerInit;
import com.ma.gui.containers.slots.SlotMagiciansWorkbenchOutput;
import com.ma.network.ClientMessageDispatcher;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ContainerMagiciansWorkbench
extends Container {
    private final MagiciansWorkbenchTile table;
    public static int SIZE = 18;
    public static int INVENTORY_STORAGE_START = 0;
    public static int INVENTORY_STORAGE_END = 17;
    public static int FIRST_CRAFT_GRID_START = 18;
    public static int FIRST_OUTPUT_SLOT = 27;
    public static int SECOND_CRAFT_GRID_START = 28;
    public static int SECOND_OUTPUT_SLOT = 37;
    public static int PLAYER_INVENTORY_START = 38;
    public static int PLAYER_ACTION_BAR_START = 65;
    public static int PLAYER_ACTION_BAR_END = 73;
    public CraftingInventory firstCraftMatrix;
    public CraftingInventory secondCraftMatrix;
    private PlayerInventory playerInv;
    private boolean initializing;

    public ContainerMagiciansWorkbench(int i, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(i, playerInventory, ((MagiciansWorkbenchTile)playerInventory.field_70458_d.field_70170_p.func_175625_s(packetBuffer.func_179259_c())).readFrom(packetBuffer));
    }

    public ContainerMagiciansWorkbench(int windowId, PlayerInventory playerInventory, MagiciansWorkbenchTile inventory) {
        super((ContainerType)ContainerInit.MAGICIANS_WORKBENCH.get(), windowId);
        int j;
        int i;
        int ypos;
        int xpos;
        this.table = inventory;
        this.playerInv = playerInventory;
        inventory.func_174889_b(playerInventory.field_70458_d);
        this.firstCraftMatrix = new CraftingInventory((Container)this, 3, 3);
        this.secondCraftMatrix = new CraftingInventory((Container)this, 3, 3);
        this.updateCraftingMatrices();
        int slotIndex = 0;
        for (xpos = 0; xpos < 3; ++xpos) {
            for (ypos = 0; ypos < 6; ++ypos) {
                this.func_75146_a(new Slot((IInventory)this.table, slotIndex++, 196 + xpos * 18, 8 + ypos * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.firstCraftMatrix, j + i * 3, 67 + j * 20, 11 + i * 20));
            }
        }
        this.func_75146_a(new SlotMagiciansWorkbenchOutput(playerInventory.field_70458_d, (IInventory)this.firstCraftMatrix, (IInventory)this.table.firstResultInv, this, 0, 87, 91));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.secondCraftMatrix, j + i * 3, 133 + j * 20, 11 + i * 20));
            }
        }
        this.func_75146_a(new SlotMagiciansWorkbenchOutput(playerInventory.field_70458_d, (IInventory)this.secondCraftMatrix, (IInventory)this.table.secondResultInv, this, 0, 153, 91));
        for (xpos = 0; xpos < 9; ++xpos) {
            for (ypos = 0; ypos < 3; ++ypos) {
                this.func_75146_a(new Slot((IInventory)playerInventory, xpos + ypos * 9 + 9, 48 + xpos * 18, 121 + ypos * 18));
            }
        }
        for (xpos = 0; xpos < 9; ++xpos) {
            this.func_75146_a(new Slot((IInventory)playerInventory, xpos, 48 + xpos * 18, 179));
        }
    }

    public void updateCraftingMatrices() {
        this.initializing = true;
        for (int i = 0; i < 9; ++i) {
            this.firstCraftMatrix.func_70299_a(i, this.table.func_70301_a(i + FIRST_CRAFT_GRID_START));
            this.secondCraftMatrix.func_70299_a(i, this.table.func_70301_a(i + SECOND_CRAFT_GRID_START));
        }
        this.initializing = false;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.table.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == FIRST_OUTPUT_SLOT || index == SECOND_OUTPUT_SLOT) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, this.table.func_145831_w(), playerIn);
                if (!this.func_75135_a(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= PLAYER_INVENTORY_START && index < PLAYER_ACTION_BAR_END ? !this.func_75135_a(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && (index < PLAYER_ACTION_BAR_START ? !this.func_75135_a(itemstack1, PLAYER_ACTION_BAR_START, PLAYER_ACTION_BAR_END, false) : !this.func_75135_a(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_START, false)) : (index >= FIRST_CRAFT_GRID_START && index < FIRST_OUTPUT_SLOT ? !this.func_75135_a(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && !this.func_75135_a(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false) : (index >= SECOND_CRAFT_GRID_START && index < SECOND_OUTPUT_SLOT ? !this.func_75135_a(itemstack1, INVENTORY_STORAGE_START, FIRST_CRAFT_GRID_START, false) && !this.func_75135_a(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false) : !this.func_75135_a(itemstack1, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.table.func_174886_c(playerIn);
    }

    public void func_75130_a(IInventory p_75130_1_) {
        ContainerMagiciansWorkbench.updateCraftingResult(this.field_75152_c, this.table.func_145831_w(), this.playerInv.field_70458_d, this.firstCraftMatrix, this.table.firstResultInv, FIRST_OUTPUT_SLOT);
        ContainerMagiciansWorkbench.updateCraftingResult(this.field_75152_c, this.table.func_145831_w(), this.playerInv.field_70458_d, this.secondCraftMatrix, this.table.secondResultInv, SECOND_OUTPUT_SLOT);
        if (!this.initializing) {
            for (int i = 0; i < 9; ++i) {
                this.table.func_70299_a(i + FIRST_CRAFT_GRID_START, this.firstCraftMatrix.func_70301_a(i));
                this.table.func_70299_a(i + SECOND_CRAFT_GRID_START, this.secondCraftMatrix.func_70301_a(i));
            }
        }
    }

    protected static void updateCraftingResult(int id, World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory inventoryResult, int syncSlot) {
        if (!world.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (optional.isPresent() && inventoryResult.func_201561_a(world, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)inventory);
            }
            inventoryResult.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(id, syncSlot, itemstack));
        }
    }

    public MagiciansWorkbenchTile getWorkbench() {
        return this.table;
    }

    public HashMap<ImmutablePair<Item, Integer>, Integer> getComponentCount(int recipeIndex) {
        HashMap<ImmutablePair<Item, Integer>, Integer> componentCount = new HashMap<ImmutablePair<Item, Integer>, Integer>();
        MagiciansWorkbenchTile.RememberedRecipe recipe = this.table.getRememberedRecipeItems().get(recipeIndex);
        for (ItemStack stack : recipe.components) {
            if (stack.func_190926_b()) continue;
            ImmutablePair pair = new ImmutablePair((Object)stack.func_77973_b(), (Object)stack.func_77952_i());
            if (componentCount.containsKey(pair)) {
                int amt = componentCount.get(pair);
                componentCount.put((ImmutablePair<Item, Integer>)pair, ++amt);
                continue;
            }
            componentCount.put((ImmutablePair<Item, Integer>)pair, 1);
        }
        return componentCount;
    }

    public boolean hasComponents(int recipeIndex) {
        HashMap<ImmutablePair<Item, Integer>, Integer> componentCount = this.getComponentCount(recipeIndex);
        boolean allComponentsPresent = true;
        for (ImmutablePair<Item, Integer> pair : componentCount.keySet()) {
            Integer qty = componentCount.get(pair);
            if (qty == null) {
                return false;
            }
            allComponentsPresent &= this.hasComponent(new ItemStack((IItemProvider)pair.left), qty);
        }
        return allComponentsPresent;
    }

    private boolean hasComponent(ItemStack component, int qty) {
        int matchedQty = 0;
        for (int i = INVENTORY_STORAGE_START; i <= INVENTORY_STORAGE_END; ++i) {
            ItemStack stack = this.getWorkbench().func_70301_a(i);
            if (stack.func_77969_a(component)) {
                matchedQty += stack.func_190916_E();
            }
            if (matchedQty < qty) continue;
            return true;
        }
        return false;
    }

    private void decrementStoredComponents(int recipeIndex) {
        HashMap<ImmutablePair<Item, Integer>, Integer> componentCount = this.getComponentCount(recipeIndex);
        for (ImmutablePair<Item, Integer> pair : componentCount.keySet()) {
            Integer qty = componentCount.get(pair);
            if (qty == null) {
                return;
            }
            this.decrementStoredComponent(new ItemStack((IItemProvider)pair.left), qty);
        }
    }

    private void decrementStoredComponent(ItemStack component, int qty) {
        int qtyLeft = qty;
        for (int i = INVENTORY_STORAGE_START; i <= INVENTORY_STORAGE_END; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_77969_a(component)) continue;
            if (stack.func_190916_E() > qtyLeft) {
                stack.func_190920_e(stack.func_190916_E() - qtyLeft);
                slot.func_75215_d(stack);
                slot.func_75218_e();
                return;
            }
            qtyLeft -= stack.func_190916_E();
            slot.func_75215_d(ItemStack.field_190927_a);
            slot.func_75218_e();
        }
    }

    private void setRecipeItemsToGrid(int recipeIndex) {
        MagiciansWorkbenchTile.RememberedRecipe recipe = this.table.getRememberedRecipeItems().get(recipeIndex);
        int count = 0;
        int startSlot = -1;
        if (this.craftingGridIsEmpty(true)) {
            startSlot = SECOND_CRAFT_GRID_START;
        } else if (this.craftingGridIsEmpty(false)) {
            startSlot = FIRST_CRAFT_GRID_START;
        }
        if (startSlot == -1) {
            return;
        }
        for (ItemStack stack : recipe.components) {
            Slot slot = this.func_75139_a(startSlot + count);
            if (!stack.func_190926_b()) {
                ItemStack copyStack = stack.func_77946_l();
                copyStack.func_190920_e(1);
                slot.func_75215_d(copyStack);
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            ++count;
        }
    }

    public boolean gridIsFreeFor(int recipeIndex) {
        return this.craftingGridIsEmpty(false) || this.craftingGridIsEmpty(true);
    }

    public void tryClearGrid(boolean second) {
        if (this.table.func_145831_w().func_201670_d()) {
            ClientMessageDispatcher.sendMagiciansWorkbenchClearMessage(second);
            return;
        }
        int startIndex = second ? SECOND_CRAFT_GRID_START : FIRST_CRAFT_GRID_START;
        for (int i = 0; i < 9; ++i) {
            ItemStack gridStack = this.table.func_70301_a(i + startIndex);
            if (gridStack.func_190926_b() || !this.func_75135_a(gridStack, INVENTORY_STORAGE_START, INVENTORY_STORAGE_END, true) && !this.func_75135_a(gridStack, PLAYER_INVENTORY_START, PLAYER_ACTION_BAR_END, false)) continue;
            this.table.func_70299_a(i + startIndex, ItemStack.field_190927_a);
        }
        this.updateCraftingMatrices();
        this.func_75130_a(this.table);
        this.func_75142_b();
    }

    private boolean craftingGridIsEmpty(boolean second) {
        int startSlot = second ? SECOND_CRAFT_GRID_START : FIRST_CRAFT_GRID_START;
        for (int i = 0; i < 9; ++i) {
            if (this.getWorkbench().func_70301_a(startSlot + i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void moveRecipeToCraftingGrid(int recipeIndex) {
        if (this.table.getRememberedRecipeItems().size() <= recipeIndex) {
            return;
        }
        if (!this.gridIsFreeFor(recipeIndex) || this.isRecipeAlreadyInGrid(recipeIndex)) {
            return;
        }
        if (this.table.func_145831_w().func_201670_d()) {
            ClientMessageDispatcher.sendMagiciansWorkbenchRecipeSetMessage(recipeIndex);
            return;
        }
        if (this.hasComponents(recipeIndex)) {
            this.decrementStoredComponents(recipeIndex);
            this.setRecipeItemsToGrid(recipeIndex);
            this.updateCraftingMatrices();
            this.func_75130_a(this.table);
            this.func_75142_b();
        }
    }

    public boolean isRecipeAlreadyInGrid(int recipeIndex) {
        if (this.table.getRememberedRecipeItems().size() <= recipeIndex) {
            return false;
        }
        MagiciansWorkbenchTile.RememberedRecipe recipe = this.table.getRememberedRecipeItems().get(recipeIndex);
        if (this.getWorkbench().firstResultInv.func_70301_a(0).func_77969_a(recipe.output)) {
            return true;
        }
        return this.getWorkbench().secondResultInv.func_70301_a(0).func_77969_a(recipe.output);
    }
}

