/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.block;

import com.google.common.collect.Lists;
import com.ma.Registries;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.progression.ProgressionCondition;
import com.ma.api.sound.SFX;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.gui.GuiTextures;
import com.ma.gui.containers.block.ContainerOcculus;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.network.ClientMessageDispatcher;
import com.ma.progression.ProgressionHelper;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.spells.ISpellComponentRecipe;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiOcculus
extends ContainerScreen<ContainerOcculus> {
    private static final int ICON_WIDTH = 50;
    private static final int ICON_HEIGHT = 40;
    private static final int ICON_SPACING = 10;
    private static final int ICON_SHEET_SIZE = 256;
    float backgroundPositionX = 0.0f;
    float backgroundPositionY = 0.0f;
    int backgroundWidth = 1024;
    int backgroundHeight = 1024;
    int categoryButtonOffset = 0;
    int startTooltipY = 52;
    int tooltipYPos = 52;
    int minTooltipY = this.startTooltipY;
    float backgroundPositionXMax = 1000.0f;
    HashMap<IconTypes, OcculusEntryList> lists;
    OcculusEntryList currentList;
    List<ITextComponent> currentTooltip = new ArrayList<ITextComponent>();
    ArrayList<TextFormatData> currentProgressionTooltip = new ArrayList();
    IPlayerProgression progression;
    IPlayerMagic magic;
    IPlayerRoteSpells rote;
    TextFormatData tierConditions = null;

    public GuiOcculus(ContainerOcculus screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.lists = new HashMap();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(false);
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.categoryButtonOffset = 0;
        Minecraft mc = Minecraft.func_71410_x();
        RecipeManager recipeManager = mc.field_71441_e.func_199532_z();
        ArrayList<ListEntry<AMRecipeBase>> spell_parts = new ArrayList<ListEntry<AMRecipeBase>>();
        this.getRecipes(recipeManager, IconTypes.SHAPE, RecipeInit.SHAPE_TYPE, spell_parts, null);
        this.getRecipes(recipeManager, IconTypes.COMPONENT, RecipeInit.COMPONENT_TYPE, spell_parts, null);
        this.getRecipes(recipeManager, IconTypes.MODIFIER, RecipeInit.MODIFIER_TYPE, spell_parts, null);
        this.setupTierBadges(IconTypes.PROGRESSION, new ArrayList<ListEntry<AMRecipeBase>>(), new ItemStack((IItemProvider)ItemInit.GUIDE_BOOK.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:progression")));
        this.setupTierBadges(IconTypes.FACTION_AFFINITY, new ArrayList<ListEntry<AMRecipeBase>>(), new ItemStack((IItemProvider)ItemInit.MOTE_ARCANE.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:faction_affinity")));
        this.setupTierBadges(IconTypes.SHAPE, spell_parts, new ItemStack((IItemProvider)ItemInit.VELLUM.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:sorcery")));
        this.setupTierBadges(IconTypes.RITUAL, this.getRecipes(recipeManager, IconTypes.RITUAL, RecipeInit.RITUAL_TYPE, null), new ItemStack((IItemProvider)ItemInit.WIZARD_CHALK.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:rituals")));
        this.setupTierBadges(IconTypes.MANAWEAVE_PATTERN, this.getRecipes(recipeManager, IconTypes.MANAWEAVE_PATTERN, RecipeInit.MANAWEAVING_PATTERN_TYPE, null), new ItemStack((IItemProvider)ItemInit.MANAWEAVER_WAND.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:manaweave_patterns")));
        this.setupTierBadges(IconTypes.MANAWEAVE_ALTAR, this.getRecipes(recipeManager, IconTypes.MANAWEAVE_ALTAR, RecipeInit.MANAWEAVING_RECIPE_TYPE, r -> !r.isEnchantment() && !(r.func_77571_b().func_77973_b() instanceof ItemConstructPart)), new ItemStack((IItemProvider)BlockInit.MANAWEAVING_ALTAR.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:manaweave_crafting")));
        this.setupTierBadges(IconTypes.RUNESCRIBING, this.getRecipes(recipeManager, IconTypes.RUNESCRIBING, RecipeInit.RUNESCRIBING_TYPE, null), new ItemStack((IItemProvider)BlockInit.RUNESCRIBING_TABLE.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:runescribing")));
        this.setupTierBadges(IconTypes.RUNIC_ANVIL, this.getRecipes(recipeManager, IconTypes.RUNIC_ANVIL, RecipeInit.RUNEFORGING_TYPE, null), new ItemStack((IItemProvider)BlockInit.RUNIC_ANVIL.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:runesmithing")));
        this.setupTierBadges(IconTypes.CONSTRUCTS, this.getRecipes(recipeManager, IconTypes.CONSTRUCTS, RecipeInit.MANAWEAVING_RECIPE_TYPE, r -> !r.isEnchantment() && r.func_77571_b().func_77973_b() instanceof ItemConstructPart), new ItemStack((IItemProvider)ItemInit.CONSTRUCT_BASIC_HEAD_OBSIDIAN.get()).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:constructs")));
        this.setupTierBadges(IconTypes.ENCHANTMENT, this.getRecipes(recipeManager, IconTypes.ENCHANTMENT, RecipeInit.MANAWEAVING_RECIPE_TYPE, r -> r.isEnchantment()), new ItemStack((IItemProvider)Items.field_151134_bR).func_200302_a((ITextComponent)new TranslationTextComponent("mechanic.mana-and-artifice:enchantments")));
        this.finalizeLists();
        this.setActiveList(IconTypes.PROGRESSION);
        this.setActiveButton((Button)this.field_230710_m_.stream().filter(e -> e instanceof ImageItemStackButton).map(e -> (ImageItemStackButton)((Object)e)).findFirst().get());
        this.progression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.magic = (IPlayerMagic)this.field_230706_i_.field_71439_g.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        this.rote = (IPlayerRoteSpells)this.field_230706_i_.field_71439_g.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.currentProgressionTooltip.clear();
        if (this.progression != null) {
            List<ProgressionCondition<?>> conditions = ProgressionHelper.getConditionsForTier(this.progression.getTier());
            Collections.sort(conditions, new Comparator<ProgressionCondition<?>>(){

                @Override
                public int compare(ProgressionCondition<?> o1, ProgressionCondition<?> o2) {
                    TranslationTextComponent ttc1 = new TranslationTextComponent(o1.getRegistryName().toString());
                    TranslationTextComponent ttc2 = new TranslationTextComponent(o2.getRegistryName().toString());
                    return ttc1.getString().compareTo(ttc2.getString());
                }
            });
            List<ResourceLocation> completedConditions = this.progression.getCompletedProgressionSteps();
            this.tierConditions = this.progression.getTier() < 5 ? new TextFormatData((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.tier_progress", new Object[]{ProgressionHelper.getCompletePerTier(this.progression.getTier()), conditions.size()}), TextFormatting.WHITE.func_211163_e()) : null;
            for (ProgressionCondition<?> cond : conditions) {
                if (completedConditions.contains(cond.getRegistryName())) {
                    this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent(cond.getRegistryName().toString()), TextFormatting.GREEN.func_211163_e()));
                    continue;
                }
                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent(cond.getRegistryName().toString()), TextFormatting.RED.func_211163_e()));
            }
            if (this.progression.getTierProgress() >= 1.0f) {
                int advancementColor = TextFormatting.YELLOW.func_211163_e();
                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new StringTextComponent(""), TextFormatting.WHITE.func_211163_e()));
                block0 : switch (this.progression.getTier()) {
                    case 1: {
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.t1_complete"), advancementColor));
                        break;
                    }
                    case 2: {
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.t2_complete"), advancementColor));
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/ancient_council"), advancementColor));
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/burning_hells"), advancementColor));
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/faerie_courts"), advancementColor));
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/cold_dark"), advancementColor));
                        break;
                    }
                    case 3: {
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.t3_complete"), advancementColor));
                        switch (this.progression.getAlliedFaction()) {
                            case ANCIENT_WIZARDS: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/ancient_council"), advancementColor));
                                break block0;
                            }
                            case DEMONS: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/burning_hells"), advancementColor));
                                break block0;
                            }
                            case FEY_COURT: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/faerie_courts"), advancementColor));
                                break block0;
                            }
                            case UNDEAD: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/cold_dark"), advancementColor));
                                break block0;
                            }
                        }
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new StringTextComponent("ERROR"), advancementColor));
                        break;
                    }
                    case 4: {
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.t4_complete"), advancementColor));
                        switch (this.progression.getAlliedFaction()) {
                            case ANCIENT_WIZARDS: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/ancient_council"), advancementColor));
                                break block0;
                            }
                            case DEMONS: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/burning_hells"), advancementColor));
                                break block0;
                            }
                            case FEY_COURT: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/faerie_courts"), advancementColor));
                                break block0;
                            }
                            case UNDEAD: {
                                this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new TranslationTextComponent("mana-and-artifice:rituals/cold_dark"), advancementColor));
                                break block0;
                            }
                        }
                        this.currentProgressionTooltip.add(new TextFormatData((ITextComponent)new StringTextComponent("ERROR"), advancementColor));
                    }
                }
            }
        }
    }

    private <T extends AMRecipeBase> List<ListEntry<AMRecipeBase>> getRecipes(RecipeManager recipeManager, IconTypes iconType, IRecipeType<T> recipeType, Function<T, Boolean> predicate) {
        return this.getRecipes(recipeManager, iconType, recipeType, null, predicate);
    }

    private <T extends AMRecipeBase> List<ListEntry<AMRecipeBase>> getRecipes(RecipeManager recipeManager, IconTypes iconType, IRecipeType<T> recipeType, @Nullable List<ListEntry<AMRecipeBase>> appendTo, @Nullable Function<T, Boolean> predicate) {
        List recipes = recipeManager.func_241447_a_(recipeType);
        if (appendTo == null) {
            appendTo = new ArrayList<ListEntry<AMRecipeBase>>();
        }
        for (AMRecipeBase recipe : recipes) {
            if (predicate != null && !predicate.apply(recipe).booleanValue()) continue;
            appendTo.add(new ListEntry(this, recipe, iconType));
        }
        return appendTo;
    }

    private void setupViewButton(IconTypes iconType, ItemStack displayStack) {
        this.func_230480_a_((Widget)new ImageItemStackButton(this.field_147003_i - 22, this.field_147009_r + this.categoryButtonOffset, 22, 22, 51, 232, -22, GuiTextures.OCCULUS_BORDER, 256, 256, button -> {
            this.setActiveList(iconType);
            this.setActiveButton(button);
        }, displayStack, this.field_230707_j_, false));
        this.categoryButtonOffset += 25;
    }

    private void setupTierBadges(IconTypes iconType, List<ListEntry<AMRecipeBase>> recipes, ItemStack displayStack) {
        OcculusEntryList oel = new OcculusEntryList(this.field_230706_i_, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.lists.put(iconType, oel);
        Collections.sort(recipes, new Comparator<ListEntry<AMRecipeBase>>(){

            @Override
            public int compare(ListEntry<AMRecipeBase> o1, ListEntry<AMRecipeBase> o2) {
                Integer tier2;
                Integer tier1 = o1.getTier();
                int tierComp = tier1.compareTo(tier2 = Integer.valueOf(o2.getTier()));
                if (tierComp != 0) {
                    return tierComp;
                }
                String name1 = o1.getRecipe().getGuiRepresentationStack().func_200301_q().getString();
                String name2 = o2.getRecipe().getGuiRepresentationStack().func_200301_q().getString();
                return name1.compareTo(name2);
            }
        });
        for (ListEntry<AMRecipeBase> entry : recipes) {
            oel.addIcon(entry.getRecipe(), entry.getIcon());
        }
        this.func_230481_d_((IGuiEventListener)oel);
        this.setupViewButton(iconType, displayStack);
    }

    private void finalizeLists() {
        for (OcculusEntryList list : this.lists.values()) {
            list.finalize();
        }
    }

    private void setActiveList(IconTypes type) {
        this.currentList = this.lists.get((Object)type);
        this.currentList.func_230932_a_(0.0);
    }

    private void setActiveButton(Button btn) {
        this.func_231039_at__().stream().forEach(l -> {
            if (l instanceof ImageItemStackButton) {
                ((ImageItemStackButton)((Object)l)).setCurrent(l == btn);
            }
        });
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.field_146999_f) || mouseY >= (double)(guiTopIn + this.field_147000_g);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.field_147003_i) {
            for (Widget b : this.field_230710_m_) {
                if (!b.func_231044_a_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip.clear();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.currentTooltip.isEmpty()) {
            this.func_238654_b_(matrixStack, Lists.transform(this.currentTooltip, ITextComponent::func_241878_f), mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        if (this.progression != null && (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION) || this.currentList == this.lists.get((Object)IconTypes.FACTION_AFFINITY))) {
            this.func_238468_a_(matrixStack, i + 2, j + 2, i + this.field_146999_f, j + this.field_147000_g, ColorHelper.PackedColor.func_233006_a_((int)255, (int)34, (int)0, (int)61), ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)0, (int)0));
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_BACKGROUND);
            GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)(i + 2), (int)(j + 2), (float)this.backgroundPositionX, (float)this.backgroundPositionY, (int)(this.field_146999_f - 4), (int)(this.field_147000_g - 4), (int)100, (int)100);
            this.backgroundPositionX = (float)((double)this.backgroundPositionX + Math.cos((float)this.field_230706_i_.field_71441_e.func_82737_E() / 200.0f) * (double)0.2f * (double)partialTicks);
            this.backgroundPositionY = (float)((double)this.backgroundPositionY - Math.sin((float)this.field_230706_i_.field_71441_e.func_82737_E() / 200.0f) * (double)0.2f * (double)partialTicks);
        }
        if (this.currentList != null) {
            this.currentList.func_230430_a_(matrixStack, x, y, partialTicks);
        }
        if (this.progression != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_BORDER);
            int height = 210;
            GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f), (int)j, (float)232.0f, (float)0.0f, (int)11, (int)height, (int)256, (int)256);
            float fillPct = this.progression.getTierProgress();
            GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f), (int)((int)((float)j + (float)height * (1.0f - fillPct))), (float)221.0f, (float)0.0f, (int)11, (int)((int)((float)height * fillPct)), (int)256, (int)256);
            GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)(i + this.field_146999_f), (int)j, (float)210.0f, (float)0.0f, (int)11, (int)this.field_147000_g, (int)256, (int)256);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        int i = 0;
        int j = 0;
        int tooltipYStart = 30;
        int tooltipX = 10;
        int tooltipY = this.tooltipYPos;
        int maxWidth = this.field_146999_f - 20;
        int totalTooltipHeight = 0;
        if (this.progression != null && this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            List split_lines;
            String gui_player_tier = I18n.func_135052_a((String)"gui.mana-and-artifice.your_tier", (Object[])new Object[]{this.progression.getTier()});
            this.field_230712_o_.func_238421_b_(matrixStack, gui_player_tier, 10.0f, 10.0f, 0xFFFFFF);
            if (this.tierConditions != null) {
                split_lines = this.field_230712_o_.func_238420_b_().func_238365_g_(this.tierConditions.itc.getString(), maxWidth, Style.field_240709_b_);
                for (ITextProperties line : split_lines) {
                    this.field_230712_o_.func_238421_b_(matrixStack, line.getString(), (float)tooltipX, (float)tooltipYStart, this.tierConditions.color);
                    this.field_230712_o_.getClass();
                    tooltipYStart += 9;
                }
            } else {
                this.field_230712_o_.getClass();
                tooltipYStart += 9 * 2;
            }
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_BORDER);
            GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)i, (int)(j + tooltipYStart), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)2, (int)310, (int)312);
            if (this.progression.getTier() >= 5) {
                this.field_230712_o_.func_238421_b_(matrixStack, new TranslationTextComponent("gui.mana-and-artifice.your_tier_max").getString(), (float)tooltipX, (float)tooltipY, TextFormatting.WHITE.func_211163_e().intValue());
            } else {
                for (TextFormatData tfd : this.currentProgressionTooltip) {
                    split_lines = this.field_230712_o_.func_238420_b_().func_238365_g_(tfd.itc.getString(), maxWidth, Style.field_240709_b_);
                    for (ITextProperties line : split_lines) {
                        if (tooltipY >= tooltipYStart) {
                            this.field_230712_o_.getClass();
                            if (tooltipY <= this.field_147000_g - 9) {
                                this.field_230712_o_.func_238421_b_(matrixStack, line.getString(), (float)tooltipX, (float)tooltipY, tfd.color);
                            }
                        }
                        this.field_230712_o_.getClass();
                        tooltipY += 9;
                        this.field_230712_o_.getClass();
                        totalTooltipHeight += 9;
                    }
                    tooltipY += 2;
                    totalTooltipHeight += 2;
                }
            }
        } else if (this.progression != null && this.currentList == this.lists.get((Object)IconTypes.FACTION_AFFINITY)) {
            y = 10;
            x = 10;
            String gui_player_faction = I18n.func_135052_a((String)"gui.mana-and-artifice.your_faction", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, gui_player_faction, (float)x, (float)y, 0xFFFFFF);
            x += this.field_230712_o_.func_78256_a(gui_player_faction) + 3;
            switch (this.progression.getAlliedFaction()) {
                case ANCIENT_WIZARDS: {
                    this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
                    GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)240.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case DEMONS: {
                    this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
                    GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)248.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case FEY_COURT: {
                    this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
                    GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)232.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case UNDEAD: {
                    this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
                    GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)224.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                default: {
                    gui_player_faction = I18n.func_135052_a((String)"gui.mana-and-artifice.your_faction.none", (Object[])new Object[0]);
                    this.field_230712_o_.func_238421_b_(matrixStack, gui_player_faction, (float)x, (float)y, 0xFFFFFF);
                }
            }
            y = 30;
            x = 10;
            String gui_player_affinity = I18n.func_135052_a((String)"gui.mana-and-artifice.affinity", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, gui_player_affinity, (float)x, (float)y, 0xFFFFFF);
            this.field_230712_o_.getClass();
            y += 9;
            for (Affinity aff : Affinity.values()) {
                ItemStack affStack = GuiTextures.affinityIcons.get((Object)aff);
                if (affStack.func_190926_b()) continue;
                this.field_230707_j_.func_175042_a(affStack, x, y);
                this.field_230712_o_.func_238421_b_(matrixStack, String.format("%.1f%%", Float.valueOf(this.magic.getAffinityDepth(aff))), (float)(x += 20), (float)(y + 5), 0xFFFFFF);
                x = 10;
                y += 20;
            }
            this.field_230706_i_.field_71441_e.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                int posY = 30;
                int posX = this.getXSize() - 30;
                String gui_power_network = I18n.func_135052_a((String)"gui.mana-and-artifice.power_network", (Object[])new Object[0]);
                this.field_230712_o_.func_238421_b_(matrixStack, gui_power_network, (float)(posX - this.field_230712_o_.func_78256_a(gui_power_network) + 16), (float)posY, 0xFFFFFF);
                this.field_230712_o_.getClass();
                posY += 9;
                HashMap<Affinity, Float> nodeStrengths = m.getWellspringRegistry().getNodeNetworkStrengthFor((PlayerEntity)this.field_230706_i_.field_71439_g);
                for (Affinity aff : Affinity.values()) {
                    ItemStack affStack = GuiTextures.affinityIcons.get((Object)aff);
                    if (affStack.func_190926_b() || !nodeStrengths.containsKey((Object)aff)) continue;
                    String value = String.format("%.1f", nodeStrengths.get((Object)aff));
                    int valueWidth = this.field_230712_o_.func_78256_a(value);
                    this.field_230707_j_.func_175042_a(affStack, posX, posY);
                    this.field_230712_o_.func_238421_b_(matrixStack, value, (float)(posX - valueWidth - 5), (float)(posY + 5), 0xFFFFFF);
                    posY += 20;
                }
            });
        }
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_BORDER);
        GuiOcculus.func_238463_a_((MatrixStack)matrixStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)310, (int)312);
        this.minTooltipY = totalTooltipHeight <= this.tooltipYPos - tooltipY + this.field_147000_g - tooltipYStart + 20 ? 52 : this.tooltipYPos - tooltipY + this.field_147000_g - tooltipYStart + 20;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.backgroundPositionX = (float)((double)this.backgroundPositionX - deltaX);
        this.backgroundPositionY = (float)((double)this.backgroundPositionY - deltaY);
        for (OcculusEntryList list : this.lists.values()) {
            list.func_231043_a_(mouseX, mouseY, deltaY / 20.0);
        }
        if (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            this.tooltipYPos += (int)Math.ceil(deltaY);
            if (this.tooltipYPos > 52) {
                this.tooltipYPos = 52;
            }
            if (this.tooltipYPos < this.minTooltipY) {
                this.tooltipYPos = this.minTooltipY;
            }
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (OcculusEntryList list : this.lists.values()) {
            list.func_231043_a_(mouseX, mouseY, delta);
        }
        if (this.currentList == this.lists.get((Object)IconTypes.PROGRESSION)) {
            this.tooltipYPos += (int)Math.ceil(delta) * 10;
            if (this.tooltipYPos > 52) {
                this.tooltipYPos = 52;
            }
            if (this.tooltipYPos < this.minTooltipY) {
                this.tooltipYPos = this.minTooltipY;
            }
        }
        return true;
    }

    class TextFormatData {
        public ITextComponent itc;
        public int color;

        public TextFormatData(ITextComponent itc, int color) {
            this.itc = itc;
            this.color = color;
        }
    }

    static class ListEntry<T extends AMRecipeBase> {
        private T recipe;
        private IconTypes iconType;
        final /* synthetic */ GuiOcculus this$0;

        public ListEntry(T recipe, IconTypes icon) {
            this.this$0 = this$0;
            this.recipe = recipe;
            this.iconType = icon;
        }

        public int getTier() {
            return ((AMRecipeBase)this.recipe).getTier();
        }

        public IconTypes getIcon() {
            return this.iconType;
        }

        public T getRecipe() {
            return this.recipe;
        }
    }

    static enum IconTypes {
        PROGRESSION(0, 0),
        FACTION_AFFINITY(0, 0),
        MANAWEAVE_PATTERN(0, 0),
        MANAWEAVE_ALTAR(50, 0),
        SHAPE(100, 0),
        COMPONENT(150, 0),
        MODIFIER(200, 0),
        RUNESCRIBING(0, 80),
        RUNIC_ANVIL(50, 80),
        ENCHANTMENT(100, 80),
        RITUAL(150, 80),
        CONSTRUCTS(200, 80);

        private int texStartX;
        private int texStartY;

        private IconTypes(int texStartX, int texStartY) {
            this.texStartX = texStartX;
            this.texStartY = texStartY;
        }

        public int getTexX() {
            return this.texStartX;
        }

        public int getTexY() {
            return this.texStartY;
        }
    }

    public class ImageItemStackButton
    extends ImageButton {
        final ItemStack iconStack;
        final ItemRenderer itemRenderer;
        final boolean includeTooltip;
        private boolean current;

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, ItemStack displayStack, ItemRenderer itemRenderer) {
            this(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack, itemRenderer, true);
        }

        public ImageItemStackButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.IPressable clickHandler, ItemStack displayStack, ItemRenderer itemRenderer, boolean displayFullTooltip) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, displayStack.func_200301_q());
            this.iconStack = displayStack;
            this.itemRenderer = itemRenderer;
            this.includeTooltip = displayFullTooltip;
        }

        public boolean func_230449_g_() {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        protected boolean func_230992_c_(double mouseX, double mouseY) {
            return super.func_230992_c_(mouseX, mouseY);
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            super.func_230431_b_(matrixStack, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
            this.itemRenderer.func_180450_b(this.iconStack, this.field_230690_l_ + 3, this.field_230691_m_ + 3);
            if (this.field_230693_o_ && this.field_230692_n_) {
                List lines;
                if (this.includeTooltip) {
                    lines = this.iconStack.func_82840_a((PlayerEntity)((GuiOcculus)GuiOcculus.this).field_230706_i_.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                } else {
                    lines = new ArrayList<ITextComponent>();
                    lines.add(this.iconStack.func_200301_q());
                }
                ArrayList<ITextComponent> tt = new ArrayList<ITextComponent>();
                for (ITextComponent comp : lines) {
                    if (!this.includeTooltip) {
                        String unformatted = TextFormatting.func_110646_a((String)comp.getString());
                        StringTextComponent stc = new StringTextComponent(unformatted);
                        stc.func_240699_a_(TextFormatting.ITALIC);
                        tt.add((ITextComponent)stc);
                        continue;
                    }
                    tt.add(comp);
                }
                GuiOcculus.this.currentTooltip = tt;
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    class OcculusEntryList
    extends ExtendedList<OcculusEntry> {
        private int x;
        private OcculusEntry current;

        public <T extends AMRecipeBase> OcculusEntryList(Minecraft mcIn, int x, int y, int widthIn, int heightIn) {
            super(mcIn, widthIn, heightIn, y, y + heightIn, 50);
            this.x = x;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 50);
        }

        public <T extends AMRecipeBase> void addIcon(T recipe, IconTypes type) {
            if (this.current == null || this.current.countIcons() == 4 || recipe.getTier() > this.current.getTier()) {
                this.current = recipe instanceof ISpellComponentRecipe ? new OcculusSpellEntry(recipe.getTier()) : (recipe instanceof ManaweavingPattern ? new OcculusManaweaveEntry(recipe.getTier()) : new OcculusEntry(recipe.getTier()));
                this.func_230513_b_((AbstractList.AbstractListEntry)this.current);
            }
            if (this.current.getTier() > recipe.getTier()) {
                throw new InvalidParameterException("Cannot add a recipe for a lower tier.  Sort recipes ascending by tier for this to work.");
            }
            this.current.addOutputItem(recipe, type);
        }

        public void finalize() {
            for (OcculusEntry e : this.func_231039_at__()) {
                e.finalize();
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            int lastTier = 0;
            for (OcculusEntry entry : this.func_231039_at__()) {
                while (lastTier < entry.getTier()) {
                    ++lastTier;
                    if (yPos + 15 > this.field_230672_i_) {
                        this.field_230668_b_.field_71466_p.getClass();
                        if (yPos + 15 + 9 < this.field_230673_j_) {
                            this.field_230668_b_.field_71466_p.func_238421_b_(matrixStack, String.format("Tier %d", lastTier), (float)xPos, (float)(yPos + 15), 0xFFFFFF);
                        }
                    }
                    yPos += 10;
                }
                yPos += 50;
            }
        }

        protected void func_238478_a_(MatrixStack matrixStack, int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float partialTicks) {
            int count = this.func_230965_k_();
            for (int i = 0; i < count; ++i) {
                int top = this.func_230962_i_(i);
                int bottom = top + this.field_230669_c_;
                if (top < this.field_230672_i_ || bottom > this.field_230673_j_) continue;
                int j1 = this.field_230669_c_ - 4;
                OcculusEntry e = (OcculusEntry)this.func_230953_d_(i);
                e.func_230432_a_(matrixStack, i, top, this.func_230968_n_(), this.func_230949_c_(), j1, p_238478_4_, p_238478_5_, false, partialTicks);
            }
        }

        public int func_230949_c_() {
            return this.field_230670_d_ - 40;
        }

        public int func_230968_n_() {
            return this.x + 12;
        }

        protected int func_230962_i_(int p_230962_1_) {
            OcculusEntry oe = (OcculusEntry)((Object)this.func_231039_at__().get(p_230962_1_));
            return this.field_230672_i_ + 15 - (int)this.func_230966_l_() + p_230962_1_ * this.field_230669_c_ + oe.getTier() * 10;
        }

        protected int func_230945_b_() {
            return (this.func_230965_k_() + 1) * this.field_230669_c_ + 50;
        }

        public class OcculusManaweaveEntry
        extends OcculusEntry {
            private ArrayList<ManaweavingPattern> patterns;

            public OcculusManaweaveEntry(int tier) {
                super(tier);
                this.patterns = new ArrayList();
            }

            @Override
            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                super.addOutputItem(recipe, type);
                if (recipe instanceof ManaweavingPattern) {
                    this.patterns.add((ManaweavingPattern)recipe);
                }
            }

            @Override
            public void renderForeground(MatrixStack matrixStack, int x, int y, float partialTick, ItemStack stack, int index) {
                GuiRenderUtils.bindManaweaveTextureRenderer();
                float scale = 0.1f;
                GuiRenderUtils.renderManaweavePattern(matrixStack, (int)((float)(x + 33) / scale), (int)((float)(y + 4) / scale), scale, this.patterns.get(index));
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                tooltip.add(stack.func_200301_q());
                if (GuiOcculus.this.progression == null) {
                    return;
                }
                scale = 0.7f;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(scale, scale, 1.0f);
                int yCoord = y + 22;
                for (ITextComponent tc : tooltip) {
                    List lines = this.fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)tc, (int)(47.0f / scale), Style.field_240709_b_);
                    for (ITextProperties line : lines) {
                        int len = (int)((float)this.fontRenderer.func_78256_a(line.getString()) * scale);
                        int xCoord = x + 2 + 25 - len / 2;
                        this.fontRenderer.func_238421_b_(matrixStack, line.getString(), (float)xCoord / scale, (float)yCoord / scale, 0xFFFFFF);
                        float f = yCoord;
                        this.fontRenderer.getClass();
                        yCoord = (int)(f + 9.0f * scale);
                    }
                }
                matrixStack.func_227865_b_();
            }
        }

        public class OcculusSpellEntry
        extends OcculusEntry {
            ArrayList<ISpellComponent> spellParts;

            public OcculusSpellEntry(int tier) {
                super(tier);
                this.spellParts = new ArrayList();
            }

            @Override
            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                super.addOutputItem(recipe, type);
                if (recipe instanceof ISpellComponentRecipe) {
                    ResourceLocation spellRLoc;
                    ISpellComponent comp = ((ISpellComponentRecipe)((Object)recipe)).getComponent();
                    ResourceLocation resourceLocation = spellRLoc = comp != null ? comp.getRegistryName() : new ResourceLocation("");
                    if (Registries.Shape.containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.Shape.getValue(spellRLoc));
                    } else if (Registries.Component.containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.Component.getValue(spellRLoc));
                    } else if (Registries.Modifier.containsKey(spellRLoc)) {
                        this.spellParts.add((ISpellComponent)Registries.Modifier.getValue(spellRLoc));
                    }
                }
            }

            @Override
            protected void renderBackground(MatrixStack matrixStack, int x, int y, IconTypes type, int index, boolean tierMet) {
                ISpellComponent comp;
                super.renderBackground(matrixStack, x, y, type, index, tierMet);
                if (index < this.spellParts.size() && (comp = this.spellParts.get(index)) != null && GuiOcculus.this.rote != null) {
                    int color = GuiOcculus.this.rote.isRote(comp) ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)255, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)237, (int)230, (int)9);
                    float prog = GuiOcculus.this.rote.getRoteProgression(comp);
                    if (prog > 0.0f && prog < 0.02f) {
                        prog = 0.02f;
                    }
                    int width = (int)(prog * 50.0f);
                    AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x + 2), (int)(y + 40), (int)(x + 2 + width), (int)(y + 40 + 2), (int)color);
                }
            }

            @Override
            public void renderForeground(MatrixStack matrixStack, int x, int y, float partialTick, ItemStack stack, int index) {
                ISpellComponent part;
                if (index >= 0 && index < this.spellParts.size() && (part = this.spellParts.get(index)) != null) {
                    GuiOcculus.this.field_230706_i_.func_110434_K().func_110577_a(part.getGuiIcon());
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + 19), (int)(y + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                }
                this.renderTextLines(matrixStack, stack, x, y);
            }

            @Override
            protected Faction getFaction(int index) {
                return index >= this.spellParts.size() || this.spellParts.get(index) == null ? Faction.NONE : this.spellParts.get(index).getFactionRequirement();
            }
        }

        public class OcculusEntry
        extends ExtendedList.AbstractListEntry<OcculusEntry> {
            private static final int MAX_ITEMS = 4;
            private ArrayList<ItemStack> outputItems;
            private ArrayList<AMRecipeBase> outputRecipes;
            private ArrayList<IconTypes> iconTypes;
            protected ItemRenderer itemRenderer;
            protected FontRenderer fontRenderer;
            protected int tier;

            public OcculusEntry(int tier) {
                this.itemRenderer = OcculusEntryList.this.field_230668_b_.func_175599_af();
                this.fontRenderer = ((OcculusEntryList)OcculusEntryList.this).field_230668_b_.field_71466_p;
                this.outputItems = new ArrayList();
                this.outputRecipes = new ArrayList();
                this.iconTypes = new ArrayList();
                this.tier = tier;
            }

            public void addOutputItem(AMRecipeBase recipe, IconTypes type) {
                if (this.outputItems.size() == 4) {
                    return;
                }
                if (recipe.getGuiRepresentationStack().func_190926_b()) {
                    return;
                }
                this.outputItems.add(recipe.getGuiRepresentationStack());
                this.outputRecipes.add(recipe);
                this.iconTypes.add(type);
            }

            public void finalize() {
                while (this.outputItems.size() < 4) {
                    this.outputItems.add(ItemStack.field_190927_a);
                }
            }

            public int countIcons() {
                return this.outputItems.size();
            }

            public int getTier() {
                return this.tier;
            }

            protected Faction getFaction(int index) {
                return index >= this.outputRecipes.size() || this.outputRecipes.get(index) == null ? Faction.NONE : this.outputRecipes.get(index).getFactionRequirement();
            }

            private int getFactionX(int index) {
                switch (this.getFaction(index)) {
                    case ANCIENT_WIZARDS: {
                        return 240;
                    }
                    case DEMONS: {
                        return 248;
                    }
                    case FEY_COURT: {
                        return 232;
                    }
                    case UNDEAD: {
                        return 224;
                    }
                }
                return -1;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
                for (int i = 0; i < 4 && !this.outputItems.get(i).func_190926_b(); ++i) {
                    if (GuiOcculus.this.progression == null) {
                        return;
                    }
                    boolean tierMet = this.tier <= GuiOcculus.this.progression.getTier();
                    GL11.glPushAttrib((int)16384);
                    if (!tierMet) {
                        GL11.glColor3f((float)0.5f, (float)0.0f, (float)0.0f);
                    }
                    this.renderBackground(matrixStack, left + i * 58, top, this.iconTypes.get(i), i, tierMet);
                    this.renderForeground(matrixStack, left + i * 58, top, partialTicks, this.outputItems.get(i), i);
                    GL11.glPopAttrib();
                }
            }

            protected void renderBackground(MatrixStack matrixStack, int x, int y, IconTypes type, int index, boolean tierMet) {
                OcculusEntryList.this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + 2), (int)(y + 2), (float)type.getTexX(), (float)type.getTexY(), (int)50, (int)40, (int)256, (int)256);
                int fX = this.getFactionX(index);
                if (fX > -1) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + 50 - 8), (int)(y + 40 - 8), (float)fX, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    if (!tierMet) {
                        GL11.glColor3f((float)0.5f, (float)0.0f, (float)0.0f);
                    }
                }
            }

            public void renderForeground(MatrixStack matrixStack, int x, int y, float partialTick, ItemStack stack, int index) {
                this.itemRenderer.func_175042_a(stack, x + 19, y + 3);
                this.renderTextLines(matrixStack, stack, x, y);
            }

            protected void renderTextLines(MatrixStack matrixStack, ItemStack stack, int x, int y) {
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                tooltip.add(stack.func_200301_q());
                if (GuiOcculus.this.progression == null) {
                    return;
                }
                float scale = 0.7f;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(scale, scale, 1.0f);
                int yCoord = y + 22;
                for (ITextComponent tc : tooltip) {
                    List lines = this.fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)tc, (int)(47.0f / scale), Style.field_240709_b_);
                    for (ITextProperties line : lines) {
                        int len = (int)((float)this.fontRenderer.func_78256_a(line.getString()) * scale);
                        int xCoord = x + 2 + 25 - len / 2;
                        this.fontRenderer.func_238421_b_(matrixStack, line.getString(), (float)xCoord / scale, (float)yCoord / scale, 0xFFFFFF);
                        float f = yCoord;
                        this.fontRenderer.getClass();
                        yCoord = (int)(f + 9.0f * scale);
                    }
                }
                matrixStack.func_227865_b_();
            }
        }
    }
}

