/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.block;

import com.ma.Registries;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralClientConfig;
import com.ma.gui.GuiTextures;
import com.ma.gui.base.SearchableGui;
import com.ma.gui.containers.block.ContainerInscriptionTable;
import com.ma.recipes.ItemAndPatternRecipe;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiInscriptionTable
extends SearchableGui<ContainerInscriptionTable> {
    ImageButton buildButton;
    ImageButton[] pieceWidgets;
    ImageButton activeShapeButton;
    ImageButton activeComponentButton;
    ImageButton[] activeModifierButtons;
    ArrayList<ImageButton> shapeAttributeButtons;
    ArrayList<ImageButton> componentAttributeButtons;
    private SpellPartList spellPartList;
    private ReagentList reagentList;
    final float textScaleFactor = 0.5f;
    final int textColor = 4467972;
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    ITextComponent currentTooltip = null;
    TranslationTextComponent craftMessage = null;
    InscriptionTableTile.CraftCheckResult lastResult;
    IPlayerProgression playerProgression;
    private static long lastModifierClickTime = -1L;
    private static long clickCount = 0L;

    public GuiInscriptionTable(ContainerInscriptionTable screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.activeModifierButtons = new ImageButton[3];
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.spellPartList.func_231047_b_(p_mouseScrolled_1_, p_mouseScrolled_3_)) {
            return this.spellPartList.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }
        if (this.reagentList.func_231047_b_(p_mouseScrolled_1_, p_mouseScrolled_3_)) {
            return this.reagentList.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }
        return true;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playerProgression = (IPlayerProgression)this.field_230706_i_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.spellPartList = new SpellPartList();
        this.field_230705_e_.add(this.spellPartList);
        this.reagentList = new ReagentList();
        this.field_230705_e_.add(this.reagentList);
        int tbWidth = 66;
        int x = this.field_147003_i + 6;
        int y = this.field_147009_r + 30;
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new ArrayList();
        this.setupBuildButton();
        if (((ContainerInscriptionTable)this.field_147002_h).getCurrentShape() != null) {
            this.setupShapeWidgetsFor(((ContainerInscriptionTable)this.field_147002_h).getCurrentShape().getPart());
        }
        if (((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent() != null) {
            this.setupComponentWidgetsFor(((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent().getPart());
        }
        for (int i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i) == null) continue;
            this.setupModifierWidgetsFor(((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i), i);
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
        this.initSearch(x, y, tbWidth, 16);
    }

    @Override
    protected void searchTermChanged(String newTerm) {
        this.currentSearchTerm = newTerm.toLowerCase();
        this.spellPartList.clear();
        this.spellPartList.reInit(this.currentSearchTerm);
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(115, 34, this.shapeAttributeButtons, shape);
    }

    private void setupComponentAttributeButtons(Component component) {
        this.clearAttributeButtons(this.componentAttributeButtons);
        if (component == null) {
            return;
        }
        this.setupAttributeButtons(115, 81, this.componentAttributeButtons, component);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (int i = 0; i < 3; ++i) {
                Modifier modifier = ((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i);
                if (modifier == null || !modifier.modifiesType(attribute.getAttribute())) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButton upButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 15, this.field_147009_r + yOffset, 8, 5, 0, 48, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerInscriptionTable)this.field_147002_h).increaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButton downButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + xOffset + 15, this.field_147009_r + yOffset + 5, 8, 5, 0, 53, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerInscriptionTable)this.field_147002_h).decreaseAttribute(modifiable, attribute.getAttribute(), (World)this.field_230706_i_.field_71441_e, Screen.func_231173_s_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.func_230480_a_((Widget)new AttributeButton(this.field_147003_i + xOffset + 6, this.field_147009_r + yOffset + 1, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, attribute.getAttribute().getLocaleKey()));
            addTo.add(iconButton);
            ++count;
        }
    }

    public static void checkAndShowShiftTooltip() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)GeneralClientConfig.MODIFIER_TIP_SHOWN.get()).booleanValue() && !Screen.func_231173_s_()) {
            if (mc.field_71441_e.func_82737_E() - lastModifierClickTime < 200L) {
                if (++clickCount >= 4L) {
                    GeneralClientConfig.MODIFIER_TIP_SHOWN.set((Object)true);
                    mc.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("helptip.mana-and-artifice.modifier_shift_click").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
                }
            } else {
                clickCount = 0L;
            }
            lastModifierClickTime = mc.field_71441_e.func_82737_E();
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.field_230710_m_.remove(button);
            this.field_230705_e_.remove(button);
        }
        attributeButtons.clear();
    }

    private void setupBuildButton() {
        this.buildButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 81, this.field_147009_r + 9, 25, 14, 0, 20, 0, GuiTextures.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> ((ContainerInscriptionTable)this.field_147002_h).sendStartBuild()));
        this.buildButton.field_230694_p_ = false;
        this.buildButton.field_230693_o_ = false;
    }

    private void setupShapeWidgetsFor(Shape shape) {
        int texSize = 32;
        if (shape != null) {
            if (this.activeShapeButton != null) {
                this.field_230710_m_.remove(this.activeShapeButton);
                this.field_230705_e_.remove(this.activeShapeButton);
            }
            this.activeShapeButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 82, this.field_147009_r + 36, texSize, texSize, 0, 0, 0, shape.getGuiIcon(), texSize, texSize, button -> {
                ((ContainerInscriptionTable)this.field_147002_h).setCurrentShape(null, (World)this.field_230706_i_.field_71441_e);
                this.field_230710_m_.remove(button);
                this.field_230705_e_.remove(button);
                this.setupShapeWidgetsFor(null);
                this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
            }));
        }
        this.setupShapeAttributeButtons(shape);
    }

    private void OnShapeClicked(Shape shape) {
        ((ContainerInscriptionTable)this.field_147002_h).setCurrentShape(shape, (World)this.field_230706_i_.field_71441_e);
        this.setupShapeWidgetsFor(shape);
        this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
    }

    private void setupComponentWidgetsFor(Component component) {
        int texSize = 32;
        if (component != null) {
            if (this.activeComponentButton != null) {
                this.field_230710_m_.remove(this.activeComponentButton);
                this.field_230705_e_.remove(this.activeComponentButton);
            }
            this.activeComponentButton = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 82, this.field_147009_r + 83, 32, 32, 0, 0, 0, component.getGuiIcon(), 32, 32, button -> {
                ((ContainerInscriptionTable)this.field_147002_h).setCurrentComponent(null, (World)this.field_230706_i_.field_71441_e);
                this.field_230710_m_.remove(button);
                this.field_230705_e_.remove(button);
                this.setupComponentWidgetsFor(null);
                this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
            }));
        }
        this.setupComponentAttributeButtons(component);
    }

    private void OnComponentClicked(Component component) {
        ((ContainerInscriptionTable)this.field_147002_h).setCurrentComponent(component, (World)this.field_230706_i_.field_71441_e);
        this.setupComponentWidgetsFor(component);
        this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
    }

    private void setupModifierWidgetsFor(Modifier modifier, int index) {
        ModifiedSpellPart<Component> curComp;
        ModifiedSpellPart<Shape> curShape;
        if (modifier != null) {
            this.activeModifierButtons[index] = (ImageButton)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 82 + 37 * index, this.field_147009_r + 130, 32, 32, 0, 0, 0, modifier.getGuiIcon(), 32, 32, button -> {
                ((ContainerInscriptionTable)this.field_147002_h).setCurrentModifier(index, null, (World)this.field_230706_i_.field_71441_e);
                this.field_230710_m_.remove(button);
                this.field_230705_e_.remove(button);
                this.setupModifierWidgetsFor(null, index);
                this.activeModifierButtons[index] = null;
            }));
        }
        if ((curShape = ((ContainerInscriptionTable)this.field_147002_h).getCurrentShape()) != null) {
            this.setupShapeAttributeButtons(curShape.getPart());
        }
        if ((curComp = ((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent()) != null) {
            this.setupComponentAttributeButtons(curComp.getPart());
        }
    }

    private void OnModifierClicked(Modifier modifier) {
        int i;
        for (i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i) != modifier) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            if (this.activeModifierButtons[i] != null) continue;
            ((ContainerInscriptionTable)this.field_147002_h).setCurrentModifier(i, modifier, (World)this.field_230706_i_.field_71441_e);
            this.setupModifierWidgetsFor(modifier, i);
            break;
        }
        this.reagentList.reInit(((ContainerInscriptionTable)this.field_147002_h).getCurrentReagents().entrySet().stream().map(e -> new ItemStack((IItemProvider)e.getKey(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList()));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip = null;
        this.lastResult = ((ContainerInscriptionTable)this.field_147002_h).isReadyToBuild(this.playerProgression);
        if (this.lastResult == InscriptionTableTile.CraftCheckResult.READY) {
            this.buildButton.field_230694_p_ = true;
            this.buildButton.field_230693_o_ = true;
            this.craftMessage = null;
        } else {
            this.buildButton.field_230694_p_ = false;
            this.buildButton.field_230693_o_ = false;
            if (!this.lastResult.getTranslationKey().isEmpty()) {
                this.craftMessage = (TranslationTextComponent)new TranslationTextComponent(this.lastResult.getTranslationKey()).func_240699_a_(TextFormatting.RED);
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentTooltip != null) {
            this.func_238652_a_(matrixStack, this.currentTooltip, mouseX, mouseY);
        } else {
            this.func_230459_a_(matrixStack, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        int col;
        int row;
        int xPos = 140;
        int yPos = 37;
        int count = 0;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (((ContainerInscriptionTable)this.field_147002_h).getCurrentShape() != null) {
            for (Attribute attribute : ((ContainerInscriptionTable)this.field_147002_h).getCurrentShape().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerInscriptionTable)this.field_147002_h).getCurrentShape().getValue(attribute));
                ++count;
            }
        }
        xPos = 140;
        count = 0;
        yPos = 84;
        if (((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent() != null) {
            for (Attribute attribute : ((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent().getContainedAttributes()) {
                row = (int)Math.floor(count / 2);
                col = count % 2;
                this.drawAttributeValue(matrixStack, xPos + col * 38, yPos + row * 13, ((ContainerInscriptionTable)this.field_147002_h).getCurrentComponent().getValue(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i) == null) continue;
            String s = I18n.func_135052_a((String)((ContainerInscriptionTable)this.field_147002_h).getCurrentModifier(i).getRegistryName().toString(), (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(81 + i * 37) / 0.5f, 244.0f, 4467972);
        }
        float summaryXPos = 202.0f;
        float summaryYPos = 33.0f;
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.mana-and-artifice.complexity", (Object[])new Object[0]) + ":", summaryXPos / 0.5f, summaryYPos / 0.5f, 4467972);
        if (((ContainerInscriptionTable)this.field_147002_h).getComplexity() <= (float)this.playerProgression.getTierMaxComplexity()) {
            this.field_230712_o_.func_238421_b_(matrixStack, String.format("%.1f / %d", Float.valueOf(((ContainerInscriptionTable)this.field_147002_h).getComplexity()), this.playerProgression.getTierMaxComplexity()), summaryXPos / 0.5f, (summaryYPos + 5.0f) / 0.5f, 4467972);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, String.format("%.1f / %d", Float.valueOf(((ContainerInscriptionTable)this.field_147002_h).getComplexity()), this.playerProgression.getTierMaxComplexity()), summaryXPos / 0.5f, (summaryYPos + 5.0f) / 0.5f, TextFormatting.GOLD.func_211163_e().intValue());
        }
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.mana-and-artifice.mana_cost", (Object[])new Object[0]) + ":", summaryXPos / 0.5f, (summaryYPos + 13.0f) / 0.5f, 4467972);
        this.field_230712_o_.func_238421_b_(matrixStack, String.format("%.1f", Float.valueOf(((ContainerInscriptionTable)this.field_147002_h).getManaCost((PlayerEntity)this.field_230706_i_.field_71439_g))), summaryXPos / 0.5f, (summaryYPos + 18.0f) / 0.5f, 4467972);
        if (((ContainerInscriptionTable)this.field_147002_h).getCraftTicks() <= 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE_WIDGETS);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)((int)((summaryXPos + 3.0f) / 0.5f)), (int)((int)((summaryYPos + 25.0f) / 0.5f)), (float)29.0f, (float)20.0f, (int)16, (int)16, (int)128, (int)128);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)((int)((summaryXPos + 18.0f) / 0.5f)), (int)((int)((summaryYPos + 25.0f) / 0.5f)), (float)45.0f, (float)20.0f, (int)16, (int)16, (int)128, (int)128);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)((int)((summaryXPos + 33.0f) / 0.5f)), (int)((int)((summaryYPos + 25.0f) / 0.5f)), (float)61.0f, (float)20.0f, (int)16, (int)16, (int)128, (int)128);
            this.field_230712_o_.func_238421_b_(matrixStack, String.format("x%d", ((ContainerInscriptionTable)this.field_147002_h).getRequiredInk()), (summaryXPos + 4.0f) / 0.5f, (summaryYPos + 35.0f) / 0.5f, 4467972);
            this.field_230712_o_.func_238421_b_(matrixStack, String.format("x%d", ((ContainerInscriptionTable)this.field_147002_h).getRequiredVellum()), (summaryXPos + 19.0f) / 0.5f, (summaryYPos + 35.0f) / 0.5f, 4467972);
            this.field_230712_o_.func_238421_b_(matrixStack, String.format("x%d", ((ContainerInscriptionTable)this.field_147002_h).getRequiredAsh()), (summaryXPos + 34.0f) / 0.5f, (summaryYPos + 35.0f) / 0.5f, 4467972);
            int offsetY = 49;
            if (this.craftMessage != null) {
                List split_string = this.field_230712_o_.func_238420_b_().func_238365_g_(this.craftMessage.getString(), 95, Style.field_240709_b_);
                for (ITextProperties prop : split_string) {
                    this.field_230712_o_.func_238421_b_(matrixStack, prop.getString(), summaryXPos / 0.5f, (summaryYPos + (float)offsetY) / 0.5f, 12129300);
                    offsetY += 5;
                }
                offsetY += 5;
            }
            offsetY = 50;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)501.0f);
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"gui.mana-and-artifice.spell_reagents", (Object[])new Object[0]), (summaryXPos - 2.0f) / 0.5f, (summaryYPos + (float)offsetY + 22.0f) / 0.5f, 4467972);
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    private void drawAttributeValue(MatrixStack matrixStack, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        this.field_230712_o_.func_238421_b_(matrixStack, valueString, (float)x / 0.5f, (float)y / 0.5f, 4467972);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.spellPartList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.reagentList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (((ContainerInscriptionTable)this.field_147002_h).getCraftTicks() > 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE_WIDGETS);
            float pct = (float)((ContainerInscriptionTable)this.field_147002_h).getCraftTicksConsumed() / (float)((ContainerInscriptionTable)this.field_147002_h).getCraftTicks();
            if (pct > 0.0f) {
                GuiInscriptionTable.func_238463_a_((MatrixStack)matrixStack, (int)(i + 110), (int)(j + 6), (float)0.0f, (float)0.0f, (int)((int)(115.0f * pct)), (int)20, (int)128, (int)128);
            }
        }
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.spellPartList._scrolling) {
            return this.spellPartList.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        if (this.reagentList._scrolling) {
            return this.reagentList.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    class AttributeButton
    extends ImageButton {
        private ITextComponent tooltip;

        public AttributeButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int p_i51135_9_, int p_i51135_10_, Button.IPressable onPressIn, String tooltip) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, p_i51135_9_, p_i51135_10_, onPressIn);
            this.tooltip = new TranslationTextComponent(tooltip);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_230449_g_()) {
                GuiInscriptionTable.this.currentTooltip = this.tooltip;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ReagentList
    extends ExtendedList<ReagentListEntry> {
        private boolean _scrolling;

        public ReagentList() {
            super(GuiInscriptionTable.this.field_230706_i_, 45, 55, GuiInscriptionTable.this.field_147009_r + 110, GuiInscriptionTable.this.field_147009_r + 165, 16);
            this._scrolling = false;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 24);
            this.field_230675_l_ = GuiInscriptionTable.this.field_147003_i + 196;
            this.field_230674_k_ = this.field_230675_l_ + 45;
            this.reInit(null);
        }

        public void clear() {
            this.func_230963_j_();
        }

        public void reInit(Collection<ItemStack> stacks) {
            this.clear();
            if (stacks != null) {
                this.addIconsForAll(stacks);
            }
        }

        private void addIconsForAll(Collection<ItemStack> stacks) {
            ArrayList<ItemStack> segment = new ArrayList<ItemStack>();
            for (ItemStack part : stacks) {
                segment.add(part);
                if (segment.size() != 4) continue;
                this.func_230513_b_((AbstractList.AbstractListEntry)new ReagentListEntry(segment));
                segment.clear();
            }
            if (segment.size() > 0) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new ReagentListEntry(segment));
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int scrollBarStartX = this.func_230952_d_();
            int scrollBarEndX = scrollBarStartX + 4;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            if (this.func_230955_e_() > 0) {
                this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE_WIDGETS);
                int scrollBarHeight = 20;
                int top = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarHeight) / this.func_230955_e_() + this.field_230672_i_;
                if (top < this.field_230672_i_) {
                    top = this.field_230672_i_;
                }
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)scrollBarStartX, (int)top, (float)25.0f, (float)20.0f, (int)4, (int)scrollBarHeight, (int)128, (int)128);
            }
            this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE);
            int i = GuiInscriptionTable.this.field_147003_i;
            int j = GuiInscriptionTable.this.field_147009_r;
            this.func_238474_b_(matrixStack, i + 190, j + 85, 190, 85, 52, 25);
            this.func_238474_b_(matrixStack, i, j + GuiInscriptionTable.this.field_147000_g - 91, 0, GuiInscriptionTable.this.field_147000_g - 91, GuiInscriptionTable.this.field_146999_f, 91);
        }

        @Nullable
        protected final ReagentListEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.func_230968_n_();
            int upperXBound = lowerXBound + this.func_230949_c_();
            int adjustedY = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) + (int)this.func_230966_l_();
            int index = adjustedY / this.field_230669_c_;
            if (index >= 0 && adjustedY >= 0 && index < this.func_230965_k_() && mouseX < (double)this.func_230952_d_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (ReagentListEntry)((Object)this.func_231039_at__().get(index));
            }
            return null;
        }

        protected int func_230952_d_() {
            return this.func_230968_n_() + this.func_230949_c_();
        }

        protected int func_230962_i_(int p_getRowTop_1_) {
            return this.field_230672_i_ - (int)this.func_230966_l_() + p_getRowTop_1_ * this.field_230669_c_;
        }

        public int func_230949_c_() {
            return 46;
        }

        protected void func_230947_b_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.func_230947_b_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.func_230952_d_() && p_updateScrollingState_1_ < (double)(this.func_230952_d_() + 6);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            if (p_mouseClicked_5_ == 0) {
                this.func_231037_b__(true);
                return true;
            }
            return this._scrolling;
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        public void setSelected(@Nullable ReagentListEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
        }

        public class ReagentListEntry
        extends ExtendedList.AbstractListEntry<ReagentListEntry> {
            private Collection<ItemStack> stacks;
            private int spacing = 10;
            private ItemStack _hoveredStack;

            public ReagentListEntry(Collection<ItemStack> parts) {
                this.stacks = new ArrayList<ItemStack>(parts);
                this._hoveredStack = null;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                float scale = 0.5f;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 500.0);
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                for (ItemStack stack : this.stacks) {
                    if (stack.func_190926_b()) continue;
                    int x = (int)((float)(5 + left + i++ * this.spacing) / scale);
                    int y = (int)((float)(top + 4) / scale);
                    GuiInscriptionTable.this.field_230706_i_.func_175599_af().func_175042_a(stack, x, y);
                    String str = String.format("%d", stack.func_190916_E());
                    GuiInscriptionTable.this.field_230712_o_.func_238405_a_(matrixStack, str, (float)(x + 14 - GuiInscriptionTable.this.field_230712_o_.func_78256_a(str) / 2), (float)(y + 8), 0xFFFFFF);
                    if (!isHovered || !((float)mouseX >= (float)x * scale) || !((float)mouseX <= (float)(x + this.spacing) * scale)) continue;
                    GuiInscriptionTable.this.currentTooltip = new TranslationTextComponent(stack.func_77977_a());
                    this._hoveredStack = stack;
                }
                RenderSystem.popMatrix();
                matrixStack.func_227865_b_();
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                return true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SpellPartList
    extends ExtendedList<SpellPartEntry> {
        private boolean _scrolling;
        private final int tier;
        private final Faction playerFaction;

        public SpellPartList() {
            super(GuiInscriptionTable.this.field_230706_i_, 65, 111, GuiInscriptionTable.this.field_147009_r + 53, GuiInscriptionTable.this.field_147009_r + 164, 22);
            this._scrolling = false;
            this.func_230943_a_(false);
            this.func_230944_a_(false, 24);
            this.field_230675_l_ = GuiInscriptionTable.this.field_147003_i;
            this.field_230674_k_ = this.field_230675_l_ + 65;
            this.tier = ((IPlayerProgression)this.field_230668_b_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)).getTier();
            this.playerFaction = ((IPlayerProgression)this.field_230668_b_.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)).getAlliedFaction();
            this.reInit("");
        }

        public void clear() {
            this.func_230963_j_();
        }

        public void reInit(String searchTerm) {
            this.addIconsForAll(Registries.Shape.getValues().stream().filter(s -> {
                boolean valid = s.isCraftable(new SpellCraftingContext((PlayerEntity)this.field_230668_b_.field_71439_g)) && (s.getFactionRequirement() == Faction.NONE || s.getFactionRequirement() == this.playerFaction);
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= this.tier;
                }
                return valid;
            }).filter(s -> {
                String translatedName = I18n.func_135052_a((String)s.getRegistryName().toString(), (Object[])new Object[0]).toLowerCase();
                return searchTerm == "" || translatedName.contains(searchTerm);
            }).collect(Collectors.toList()), s -> GuiInscriptionTable.this.OnShapeClicked((Shape)s));
            this.addIconsForAll(Registries.Component.getValues().stream().filter(s -> {
                boolean valid = s.isCraftable(null) && (s.getFactionRequirement() == Faction.NONE || s.getFactionRequirement() == this.playerFaction);
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                if (pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe) {
                    valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= this.tier;
                }
                return valid;
            }).filter(s -> {
                String translatedName = I18n.func_135052_a((String)s.getRegistryName().toString(), (Object[])new Object[0]).toLowerCase();
                return searchTerm == "" || translatedName.contains(searchTerm);
            }).collect(Collectors.toList()), s -> GuiInscriptionTable.this.OnComponentClicked((Component)s));
            this.addIconsForAll(Registries.Modifier.getValues().stream().filter(s -> {
                boolean valid = s.isCraftable(null) && (s.getFactionRequirement() == Faction.NONE || s.getFactionRequirement() == this.playerFaction);
                Optional<IRecipe> pattern = this.field_230668_b_.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_199560_c().equals((Object)s.getRegistryName())).findFirst();
                valid = pattern.isPresent() && pattern.get() instanceof ItemAndPatternRecipe ? (valid &= ((ItemAndPatternRecipe)pattern.get()).getTier() <= this.tier) : false;
                return valid;
            }).filter(s -> {
                String translatedName = I18n.func_135052_a((String)s.getRegistryName().toString(), (Object[])new Object[0]).toLowerCase();
                return searchTerm == "" || translatedName.contains(searchTerm);
            }).collect(Collectors.toList()), s -> GuiInscriptionTable.this.OnModifierClicked((Modifier)s));
        }

        private <T extends ISpellComponent> void addIconsForAll(Collection<T> parts, Consumer<ISpellComponent> clickHandler) {
            ArrayList<ISpellComponent> segment = new ArrayList<ISpellComponent>();
            for (ISpellComponent part : parts) {
                segment.add(part);
                if (segment.size() != 3) continue;
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
                segment.clear();
            }
            if (segment.size() > 0) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new SpellPartEntry(segment, clickHandler));
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int scrollBarStartX = this.func_230952_d_();
            int scrollBarEndX = scrollBarStartX + 4;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xPos = this.func_230968_n_();
            int yPos = this.field_230672_i_ - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, xPos, yPos, mouseX, mouseY, partialTicks);
            if (this.func_230955_e_() > 0) {
                this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE_WIDGETS);
                int scrollBarHeight = 20;
                int top = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarHeight) / this.func_230955_e_() + this.field_230672_i_;
                if (top < this.field_230672_i_) {
                    top = this.field_230672_i_;
                }
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)scrollBarStartX, (int)top, (float)25.0f, (float)20.0f, (int)4, (int)scrollBarHeight, (int)128, (int)128);
            }
            this.field_230668_b_.func_110434_K().func_110577_a(GuiTextures.INSCRIPTION_TABLE);
            int i = GuiInscriptionTable.this.field_147003_i;
            int j = GuiInscriptionTable.this.field_147009_r;
            this.func_238474_b_(matrixStack, i, j, 0, 0, GuiInscriptionTable.this.field_146999_f, 53);
            this.func_238474_b_(matrixStack, i, j + GuiInscriptionTable.this.field_147000_g - 91, 0, GuiInscriptionTable.this.field_147000_g - 91, GuiInscriptionTable.this.field_146999_f, 91);
        }

        @Nullable
        protected final SpellPartEntry getEntryAtPos(double mouseX, double mouseY) {
            int lowerXBound = this.func_230968_n_();
            int upperXBound = lowerXBound + this.func_230949_c_();
            int adjustedY = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) + (int)this.func_230966_l_();
            int index = adjustedY / this.field_230669_c_;
            if (index >= 0 && adjustedY >= 0 && index < this.func_230965_k_() && mouseX < (double)this.func_230952_d_() && mouseX >= (double)lowerXBound && mouseX <= (double)upperXBound) {
                return (SpellPartEntry)((Object)this.func_231039_at__().get(index));
            }
            return null;
        }

        protected int func_230952_d_() {
            return this.func_230968_n_() + this.func_230949_c_();
        }

        protected int func_230962_i_(int p_getRowTop_1_) {
            return this.field_230672_i_ - (int)this.func_230966_l_() + p_getRowTop_1_ * this.field_230669_c_;
        }

        public int func_230949_c_() {
            return 60;
        }

        protected void func_230947_b_(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
            super.func_230947_b_(p_updateScrollingState_1_, p_updateScrollingState_3_, p_updateScrollingState_5_);
            this._scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.func_230952_d_() && p_updateScrollingState_1_ < (double)(this.func_230952_d_() + 6);
        }

        public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
            if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
                return false;
            }
            SpellPartEntry e = this.getEntryAtPos(p_mouseClicked_1_, p_mouseClicked_3_);
            if (e != null) {
                if (e.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                    e.func_231049_c__(true);
                    return true;
                }
            } else if (p_mouseClicked_5_ == 0) {
                this.func_231037_b__(true);
                return true;
            }
            return this._scrolling;
        }

        public int func_230955_e_() {
            return Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
        }

        public void setSelected(@Nullable SpellPartEntry selected) {
            super.func_241215_a_((AbstractList.AbstractListEntry)selected);
        }

        @OnlyIn(value=Dist.CLIENT)
        public class SpellPartEntry
        extends ExtendedList.AbstractListEntry<SpellPartEntry> {
            private Collection<ISpellComponent> parts;
            private int spacing = 18;
            private ISpellComponent _hoveredComponent;
            private Consumer<ISpellComponent> _clickHandler;

            public SpellPartEntry(Collection<ISpellComponent> parts, Consumer<ISpellComponent> clickHandler) {
                this.parts = new ArrayList<ISpellComponent>(parts);
                this._hoveredComponent = null;
                this._clickHandler = clickHandler;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float p_render_9_) {
                int i = 0;
                for (ISpellComponent part : this.parts) {
                    if (part == null) continue;
                    int x = 5 + left + i++ * this.spacing;
                    int y = top + 4;
                    this.renderIcon(matrixStack, x, y, part.getGuiIcon());
                    if (!isHovered || mouseX < x || mouseX > x + this.spacing) continue;
                    GuiInscriptionTable.this.currentTooltip = new TranslationTextComponent(part.getRegistryName().toString());
                    this._hoveredComponent = part;
                }
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                SpellPartList.this.setSelected(this);
                if (this._clickHandler != null && this._hoveredComponent != null) {
                    this._clickHandler.accept(this._hoveredComponent);
                }
                return true;
            }

            private void renderIcon(MatrixStack matrixStack, int x, int y, ResourceLocation item) {
                SpellPartList.this.field_230668_b_.func_110434_K().func_110577_a(item);
                int size = 16;
                AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)GuiInscriptionTable.this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
            }
        }
    }
}

