/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.ManaAndArtifice;
import com.ma.effects.EffectInit;
import com.ma.effects.particles.EffectWithCustomClientParticles;
import com.ma.network.ServerMessageDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PotionEventHandler {
    @SubscribeEvent
    public static void onPotionRemoved(PotionEvent.PotionRemoveEvent event) {
        PotionEventHandler.handlePotionRemoved(event.getPotion(), event.getEntityLiving());
    }

    @SubscribeEvent
    public static void onPotionExpired(PotionEvent.PotionExpiryEvent event) {
        PotionEventHandler.handlePotionRemoved(event.getPotionEffect().func_188419_a(), event.getEntityLiving());
    }

    private static void handlePotionRemoved(Effect effect, LivingEntity entity) {
        if (effect == EffectInit.MIST_FORM.get()) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
                player.field_71075_bZ.field_75100_b = false;
                player.field_70145_X = false;
                player.setForcedPose(null);
                entity.func_82142_c(false);
                player.func_213323_x_();
            }
        } else if ((effect == EffectInit.MIND_VISION.get() || effect == EffectInit.POSSESSION.get()) && entity instanceof ServerPlayerEntity) {
            ServerMessageDispatcher.sendPlayerMindVisionMessage((ServerPlayerEntity)entity, null);
            entity.getPersistentData().func_82580_o("posessed_entity_id");
        }
        if (effect instanceof EffectWithCustomClientParticles) {
            ((EffectWithCustomClientParticles)effect).setFlags(entity, false);
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (event.getPotionEffect().func_188419_a() == EffectInit.MIST_FORM.get() && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
            player.field_71075_bZ.field_75100_b = true;
            player.field_70145_X = true;
            player.setForcedPose(Pose.FALL_FLYING);
            player.func_82142_c(true);
            player.func_213323_x_();
        }
        if (event.getPotionEffect().func_188419_a() instanceof EffectWithCustomClientParticles) {
            ((EffectWithCustomClientParticles)event.getPotionEffect().func_188419_a()).setFlags(event.getEntityLiving(), true);
        }
    }
}

