/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.ManaAndArtifice;
import com.ma.items.ItemInit;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MissingMappingsHandler {
    private static final Map<String, ResourceLocation> reMap = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("mana-and-artifice")) {
            Block remapped;
            ResourceLocation key = mapping.key;
            String path = key.func_110623_a();
            ResourceLocation remappedId = reMap.get(path);
            if (remappedId == null || (remapped = (Block)ForgeRegistries.BLOCKS.getValue(remappedId)) == null) continue;
            ManaAndArtifice.LOGGER.warn("Remapping block '{}' to '{}'", (Object)key, (Object)remappedId);
            try {
                mapping.remap((IForgeRegistryEntry)remapped);
            }
            catch (Throwable t) {
                ManaAndArtifice.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)key, (Object)remappedId, (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void remapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("mana-and-artifice")) {
            Item remapped;
            ResourceLocation key = mapping.key;
            String path = key.func_110623_a();
            ResourceLocation remappedId = reMap.get(path);
            if (remappedId == null || (remapped = (Item)ForgeRegistries.ITEMS.getValue(remappedId)) == null) continue;
            ManaAndArtifice.LOGGER.warn("Remapping item '{}' to '{}'", (Object)key, (Object)remappedId);
            try {
                mapping.remap((IForgeRegistryEntry)remapped);
            }
            catch (Throwable t) {
                ManaAndArtifice.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)key, (Object)remappedId, (Object)t);
            }
        }
    }

    static {
        reMap.put("ritual_kit", ItemInit.PRACTITIONERS_POUCH.getId());
        reMap.put("fast_ritual_kit", ItemInit.PRACTITIONERS_POUCH.getId());
        reMap.put("component_pouch", ItemInit.PRACTITIONERS_POUCH.getId());
        reMap.put("stone_rune_bag", ItemInit.PRACTITIONERS_POUCH.getId());
        reMap.put("enchantment_focus_air", ItemInit.MOTE_AIR.getId());
        reMap.put("enchantment_focus_earth", ItemInit.MOTE_EARTH.getId());
        reMap.put("enchantment_focus_fire", ItemInit.MOTE_FIRE.getId());
        reMap.put("enchantment_focus_water", ItemInit.MOTE_WATER.getId());
        reMap.put("enchantment_focus_arcane", ItemInit.MOTE_ARCANE.getId());
        reMap.put("enchantment_focus_ender", ItemInit.MOTE_ENDER.getId());
        reMap.put("ley_line_bracelet", ItemInit.ELDRIN_BRACELET.getId());
        reMap.put("sight_unguent", ItemInit.SIGHT_UNGUENT.getId());
    }
}

