/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.spells.DamageTypes;
import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.effects.EffectInit;
import com.ma.effects.interfaces.INoCreeperLingering;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.gui.containers.providers.NamedGuideBook;
import com.ma.items.ItemGuideBook;
import com.ma.items.ItemInit;
import com.ma.items.armor.CouncilArmorItem;
import com.ma.items.armor.DemonArmorItem;
import com.ma.items.artifice.ItemEnderguardAmulet;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.SummonUtils;
import com.ma.tools.math.MathUtils;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.LecternBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    @SubscribeEvent
    public static void onItemRightClicked(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && event.getItemStack() != null && event.getItemStack().func_77973_b() == Items.field_151116_aA) {
            CommonEventHandler.handleRightClick_Leather(player, event);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)GeneralModConfig.MA_SUMMON_INTERACTIONS.get()).booleanValue() && event.getEntityLiving() instanceof LivingEntity && SummonUtils.isSummon(event.getEntityLiving())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    private static void handleRightClick_Leather(PlayerEntity player, PlayerInteractEvent.RightClickItem event) {
        ItemStack activeStack = player.func_184586_b(event.getHand());
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        BlockRayTraceResult raytraceresult = player.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            int level;
            BlockState state = player.field_70170_p.func_180495_p(raytraceresult.func_216350_a());
            if (state == Blocks.field_150355_j.func_176223_P()) {
                ItemStack vellum = new ItemStack((IItemProvider)ItemInit.VELLUM.get());
                if (!event.getPlayer().func_191521_c(vellum)) {
                    event.getPlayer().func_146097_a(vellum, true, true);
                }
                activeStack.func_190918_g(1);
            } else if (state.func_177230_c() instanceof CauldronBlock && (level = ((Integer)state.func_177229_b((Property)BlockStateProperties.field_208130_ae)).intValue()) > 0) {
                ItemStack vellum = new ItemStack((IItemProvider)ItemInit.VELLUM.get(), 2);
                if (!event.getPlayer().func_191521_c(vellum)) {
                    event.getPlayer().func_146097_a(vellum, true, true);
                }
                ((CauldronBlock)state.func_177230_c()).func_176590_a(player.field_70170_p, raytraceresult.func_216350_a(), state, level - 1);
                activeStack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        IWorldMagic worldMagic;
        ItemStack bookStack;
        TileEntity te;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_222428_lQ && (te = world.func_175625_s(event.getPos())) instanceof LecternTileEntity && (bookStack = ((LecternTileEntity)te).func_214033_c()).func_77973_b() == ItemInit.GUIDE_BOOK.get()) {
            event.setCanceled(true);
            if (event.getPlayer().func_225608_bj_()) {
                ((LecternTileEntity)te).func_214045_a(ItemStack.field_190927_a);
                LecternBlock.func_220155_a((World)world, (BlockPos)event.getPos(), (BlockState)world.func_180495_p(event.getPos()), (boolean)false);
                if (!event.getPlayer().func_191521_c(bookStack)) {
                    event.getPlayer().func_199701_a_(bookStack);
                }
            } else if (!((ItemGuideBook)ItemInit.GUIDE_BOOK.get()).checkMagicUnlock((ServerWorld)world, event.getPlayer())) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)event.getPlayer()), (INamedContainerProvider)new NamedGuideBook());
            }
            return;
        }
        LazyOptional worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent() && !(worldMagic = (IWorldMagic)worldMagicContainer.orElse(null)).canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClicked(PlayerInteractEvent.LeftClickBlock event) {
        IWorldMagic worldMagic;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        LazyOptional worldMagicContainer = world.getCapability(WorldMagicProvider.MAGIC);
        if (worldMagicContainer.isPresent() && !(worldMagic = (IWorldMagic)worldMagicContainer.orElse(null)).canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = (World)event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        IWorldMagic worldMagic = (IWorldMagic)world.getCapability(WorldMagicProvider.MAGIC).orElse(null);
        if (worldMagic != null && !worldMagic.canPlayerUnlock(event.getPos(), event.getPlayer())) {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.rune_warding.warded"), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int id;
        Entity e;
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.TRICKERY_BRACELET.get(), (LivingEntity)event.player).ifPresent(t -> event.player.func_82142_c(event.player.func_225608_bj_() || event.player.func_70644_a(Effects.field_76441_p) || event.player.func_70644_a((Effect)EffectInit.MIST_FORM.get()) || event.player.func_70644_a((Effect)EffectInit.TRUE_INVISIBILITY.get())));
        if (!event.player.field_70170_p.field_72995_K && event.player.func_70090_H() && event.player.func_70644_a((Effect)EffectInit.MIST_FORM.get()) && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
            event.player.func_70097_a(DamageTypes.causeDispersionDamage(), 5.0f);
        }
        if (event.player.func_70644_a((Effect)EffectInit.POSSESSION.get()) && event.player.getPersistentData().func_74764_b("posessed_entity_id") && ((e = event.player.field_70170_p.func_73045_a(id = event.player.getPersistentData().func_74762_e("posessed_entity_id"))) == null || !(e instanceof MobEntity) || !e.func_70089_S())) {
            event.player.getPersistentData().func_82580_o("posessed_entity_id");
            event.player.func_195063_d((Effect)EffectInit.POSSESSION.get());
        }
        event.player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getAlliedFaction() == Faction.UNDEAD) {
                if (CommonEventHandler.isPlayerInDaylight(event.player) && !event.player.func_203008_ap()) {
                    if (event.player.func_190630_a(EquipmentSlotType.HEAD)) {
                        if (event.player.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
                            ItemStack headslot = event.player.func_184582_a(EquipmentSlotType.HEAD);
                            headslot.func_222118_a(1, (LivingEntity)event.player, e -> {});
                        }
                    } else {
                        event.player.func_70015_d(8);
                    }
                } else if (event.player.func_70090_H() && event.player.func_70660_b(Effects.field_76427_o) == null) {
                    event.player.func_195064_c(new EffectInstance(Effects.field_76427_o, 200));
                }
            }
        });
        if (((CouncilArmorItem)ItemInit.COUNCIL_ARMOR__CHEST.get()).isSetEquipped((LivingEntity)event.player)) {
            CouncilArmorItem.tickReflectCharges(event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupItem(EntityItemPickupEvent event) {
        ItemStack pickedUpItem = event.getItem().func_92059_d();
        int originalQty = pickedUpItem.func_190916_E();
        PlayerInventory inv = event.getPlayer().field_71071_by;
        boolean modifiedCollection = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ItemPractitionersPouch)) continue;
            ItemPractitionersPouch pouchItem = (ItemPractitionersPouch)invStack.func_77973_b();
            if (pouchItem.getPatchLevel(invStack, PractitionersPouchPatches.COLLECTION) > 0 && pouchItem.hasRoomForItem(invStack, pickedUpItem)) {
                boolean bl = modifiedCollection = originalQty != (pickedUpItem = pouchItem.insertItem(invStack, pickedUpItem)).func_190916_E();
            }
            if (pickedUpItem.func_190926_b()) {
                event.getPlayer().func_71001_a((Entity)event.getItem(), originalQty);
                event.setCanceled(true);
                event.getItem().func_70106_y();
                return;
            }
            if (pouchItem.getPatchLevel(invStack, PractitionersPouchPatches.VOID) <= 0 || !pouchItem.shouldVoidItem(invStack, pickedUpItem)) continue;
            event.getPlayer().func_71001_a((Entity)event.getItem(), originalQty);
            event.setCanceled(true);
            event.getItem().func_70106_y();
            return;
        }
        if (modifiedCollection && !pickedUpItem.func_190926_b()) {
            event.setCanceled(true);
            event.getItem().func_92058_a(pickedUpItem);
            ForgeEventFactory.onItemPickup((ItemEntity)event.getItem(), (PlayerEntity)event.getPlayer());
        }
    }

    private static boolean isPlayerInDaylight(PlayerEntity player) {
        if (player.field_70170_p.func_72935_r() && !player.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = player.func_70013_c();
            BlockPos blockPos = blockpos = player.func_184187_bx() instanceof BoatEntity ? new BlockPos(player.func_226277_ct_(), (double)Math.round(player.func_226278_cu_()), player.func_226281_cx_()).func_177984_a() : new BlockPos(player.func_226277_ct_(), (double)Math.round(player.func_226278_cu_()), player.func_226281_cx_());
            if (f > 0.5f && player.field_70170_p.field_73012_v.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && player.field_70170_p.func_226660_f_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        MobEntity monster;
        LivingEntity living = event.getEntityLiving();
        if (living.func_70660_b((Effect)EffectInit.WATERY_GRAVE.get()) != null && living.func_70090_H()) {
            living.func_70024_g(0.0, -0.2, 0.0);
        }
        if (!(living.func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) == null || living.func_233570_aj_() || living.func_70090_H() || living.func_180799_ab())) {
            living.func_70024_g(0.0, -0.2, 0.0);
        }
        if (living.func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            if (!living.getPersistentData().func_74767_n("pilgrim_applied")) {
                living.field_70138_W += 1.0f;
                living.getPersistentData().func_74757_a("pilgrim_applied", true);
            }
        } else if (living.getPersistentData().func_74767_n("pilgrim_applied")) {
            living.field_70138_W = MathUtils.clamp(living.field_70138_W - 1.0f, 0.6f, living.field_70138_W);
            living.getPersistentData().func_74757_a("pilgrim_applied", false);
        }
        if (living instanceof MobEntity && (monster = (MobEntity)living).func_70638_az() != null && monster.func_70638_az().func_70660_b((Effect)EffectInit.TRUE_INVISIBILITY.get()) != null && monster.func_70068_e((Entity)monster.func_70638_az()) > 9.0) {
            monster.func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_70660_b((Effect)EffectInit.PILGRIM.get()) != null) {
            event.getEntityLiving().func_70024_g((double)((float)(event.getEntityLiving().func_213322_ci().field_72450_a * 0.15)), 0.25, (double)((float)(event.getEntityLiving().func_213322_ci().field_72449_c * 0.15)));
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            ((DemonArmorItem)ItemInit.DEMON_ARMOR_BOOTS.get()).handlePlayerJump((PlayerEntity)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer().func_70660_b((Effect)EffectInit.CHRONO_ANCHOR.get()) != null) {
            event.getPlayer().func_195063_d((Effect)EffectInit.CHRONO_ANCHOR.get());
        }
        SummonUtils.getSummons(event.getPlayer(), (World)event.getPlayer().func_184102_h().func_71218_a(event.getFrom())).forEach(s -> s.func_174812_G());
        event.getPlayer().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            m.setSyncGrimoire();
            m.setSyncRote();
            m.getCantripData().setNeedsSync();
            m.getCastingResource().setNeedsSync();
            m.forceSync();
        });
        ServerMessageDispatcher.sendWellspringPowerNetworkSyncMessage((RegistryKey<World>)event.getTo(), (ServerPlayerEntity)event.getPlayer(), true);
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerWakeUpEvent event) {
        BlockPos bp = event.getPlayer().func_233580_cy_();
        BlockState bedState = event.getPlayer().field_70170_p.func_180495_p(bp);
        if (bedState.func_177230_c() == BlockInit.COFFIN.get()) {
            PlayerEntity player = event.getPlayer();
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                if (p.getAlliedFaction() == Faction.UNDEAD) {
                    long lastRestTime = player.getPersistentData().func_74763_f("last_coffin_boost");
                    long curTime = player.field_70170_p.func_82737_E();
                    if (curTime - lastRestTime < 18000L) {
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("block.mana-and-artifice.coffin.time"), Util.field_240973_b_);
                        }
                        return;
                    }
                    event.getPlayer().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                        m.getCastingResource().restore(m.getCastingResource().getMaxAmount() * 0.25f);
                        player.getPersistentData().func_74772_a("last_coffin_boost", curTime);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMobGriefingEvent(EntityMobGriefingEvent event) {
        CreeperEntity creeper;
        Optional player;
        if (event.getEntity() instanceof CreeperEntity && (player = creeper.field_70170_p.func_175647_a(PlayerEntity.class, (creeper = (CreeperEntity)event.getEntity()).func_174813_aQ().func_186662_g(5.0), p -> ((ItemEnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).isEquippedAndHasMana((LivingEntity)p, 50.0f, false)).stream().findFirst()).isPresent()) {
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.ENDERGUARD_AMULET.get(), (LivingEntity)player.get()).ifPresent(t -> {
                if (((ItemEnderguardAmulet)ItemInit.ENDERGUARD_AMULET.get()).consumeMana((ItemStack)t.right, 50.0f, (PlayerEntity)player.get())) {
                    int count = 0;
                    while (count++ < 50) {
                        double z;
                        double y;
                        double x = creeper.func_226277_ct_() + (creeper.func_70681_au().nextDouble() - 0.5) * 32.0;
                        Vector3d newPos = new Vector3d(x, y = MathHelper.func_151237_a((double)(creeper.func_226278_cu_() + (double)(creeper.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(creeper.field_70170_p.func_234938_ad_() - 1)), z = creeper.func_226281_cx_() + (creeper.func_70681_au().nextDouble() - 0.5) * 32.0);
                        if (!(newPos.func_72436_e(((PlayerEntity)player.get()).func_213303_ch()) >= 36.0) || !creeper.func_213373_a(x, y, z, true)) continue;
                        event.setResult(Event.Result.DENY);
                        creeper.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        break;
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Entity mount = event.getPlayer().func_184187_bx();
        if (mount != null && mount instanceof EntityAnimatedConstruct) {
            ((EntityAnimatedConstruct)mount).soundHorn();
        }
    }

    @SubscribeEvent
    public static void onPlayerSize(EntityEvent.Size event) {
        EffectInstance mistForm;
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntity()).func_193076_bZ() != null && (mistForm = player.func_70660_b((Effect)EffectInit.MIST_FORM.get())) != null && mistForm.func_76459_b() > 5) {
            event.setNewSize(EntitySize.func_220311_c((float)0.5f, (float)0.5f));
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof CreatureEntity && SummonUtils.isSummon(event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDropXP(LivingExperienceDropEvent event) {
        if (event.getEntityLiving() instanceof CreatureEntity && SummonUtils.isSummon(event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AreaEffectCloudEntity && ((AreaEffectCloudEntity)event.getEntity()).field_184503_f.stream().anyMatch(e -> e.func_188419_a() instanceof INoCreeperLingering)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void canEntityContinueSleeping(SleepingTimeCheckEvent event) {
        EffectInstance e = event.getPlayer().func_70660_b((Effect)EffectInit.COLD_DARK.get());
        if (e != null) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

