/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.api.spells.attributes.Attribute;
import com.ma.entities.EntityInit;
import com.ma.entities.ai.CastSpellAtTargetGoal;
import com.ma.entities.ai.CastSpellOnSelfGoal;
import com.ma.gui.containers.entity.ContainerWanderingWizard;
import com.ma.items.ItemInit;
import com.ma.items.manaweaving.ItemManaweavingPattern;
import com.ma.items.ritual.ItemThaumaturgicLink;
import com.ma.network.ServerMessageDispatcher;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternSerializer;
import com.ma.spells.SpellsInit;
import com.ma.spells.crafting.SpellRecipe;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;

public class WanderingWizardEntity
extends WanderingTraderEntity {
    public WanderingWizardEntity(EntityType<? extends WanderingTraderEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_94061_f(true);
    }

    public WanderingWizardEntity(World worldIn) {
        this((EntityType<? extends WanderingTraderEntity>)((EntityType)EntityInit.WANDERING_WIZARD.get()), worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, new CastSpellOnSelfGoal<WanderingWizardEntity>(this, this.createInvisibilitySpell(), trader -> this.field_70170_p.func_226690_K_() && !trader.func_82150_aj()));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(6, new CastSpellAtTargetGoal<WanderingWizardEntity>(this, this.createRandomAttackSpell(), 0.35, 40, 10.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, p_234199_0_ -> p_234199_0_ instanceof IMob && !(p_234199_0_ instanceof CreeperEntity)));
    }

    private ItemStack createInvisibilitySpell() {
        ItemStack invisSpell = new ItemStack((IItemProvider)ItemInit.SPELL.get());
        SpellRecipe invis = new SpellRecipe();
        invis.setShape(SpellsInit.SELF);
        invis.addComponent(SpellsInit.INVISIBILITY);
        invis.changeComponentAttributeValue(0, Attribute.DURATION, 120.0f);
        invis.writeToNBT(invisSpell.func_196082_o());
        return invisSpell;
    }

    private ItemStack createRandomAttackSpell() {
        ItemStack attackSpell = new ItemStack((IItemProvider)ItemInit.SPELL.get());
        SpellRecipe boom = new SpellRecipe();
        boom.setShape(SpellsInit.BOLT);
        if (Math.random() < 0.5) {
            boom.addComponent(SpellsInit.FROST_DAMAGE);
            boom.changeComponentAttributeValue(0, Attribute.DAMAGE, 10.0f);
            boom.addComponent(SpellsInit.SLOW);
            boom.changeComponentAttributeValue(1, Attribute.MAGNITUDE, 2.0f);
            boom.changeComponentAttributeValue(1, Attribute.DURATION, 5.0f);
        } else {
            boom.addComponent(SpellsInit.MAGIC_DAMAGE);
            boom.changeComponentAttributeValue(0, Attribute.DAMAGE, 10.0f);
            boom.addComponent(SpellsInit.FLING);
            boom.changeComponentAttributeValue(1, Attribute.SPEED, 2.0f);
        }
        boom.writeToNBT(attackSpell.func_196082_o());
        return attackSpell;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 30) {
            this.func_94061_f(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70173_aa < 30) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        return super.func_184199_a(player, vec, hand);
    }

    public void func_213707_a(PlayerEntity player, ITextComponent displayName, int level) {
        MerchantOffers merchantoffers;
        int bufferCount = 10;
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, player2) -> new ContainerWanderingWizard(id, playerInventory, (IMerchant)this), displayName));
        if (player.field_71070_bA != null && !(merchantoffers = this.func_213706_dY()).isEmpty()) {
            MutableInt count = new MutableInt(0);
            MutableInt totalCount = new MutableInt(0);
            MerchantOffers packetOffers = new MerchantOffers();
            merchantoffers.forEach(o -> {
                boolean isFinal;
                packetOffers.add(o);
                count.increment();
                totalCount.increment();
                boolean bl = isFinal = totalCount.getValue() >= merchantoffers.size();
                if (count.getValue() >= 10 || isFinal) {
                    ServerMessageDispatcher.sendWanderingWizardContainerMessage(((ServerPlayerEntity)player).field_71139_cq, packetOffers, level, this.func_213708_dV(), this.func_213705_dZ(), this.func_223340_ej(), isFinal, (ServerPlayerEntity)player);
                    count.setValue(0);
                    packetOffers.clear();
                }
            });
        }
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_213717_a(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        MerchantOffer offer;
        ItemStack stack;
        givenMerchantOffers.clear();
        ItemStack costItem = new ItemStack((IItemProvider)ItemInit.VINTEUM_INGOT.get());
        for (ManaweavingPattern pattern : ManaweavingPatternSerializer.ALL_RECIPES.values()) {
            stack = new ItemStack((IItemProvider)ItemInit.RECIPE_SCRAP_MANAWEAVING_PATTERN.get());
            ItemManaweavingPattern.setRecipe(stack, pattern);
            offer = new MerchantOffer(costItem.func_77946_l(), stack, 5, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
        for (Structure structure : ForgeRegistries.STRUCTURE_FEATURES.getValues()) {
            stack = new ItemStack((IItemProvider)ItemInit.THAUMATURGIC_LINK.get());
            ItemThaumaturgicLink.setLocationKey(stack, structure);
            offer = new MerchantOffer(costItem.func_77946_l(), stack, 5, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            stack = new ItemStack((IItemProvider)ItemInit.THAUMATURGIC_LINK.get());
            ItemThaumaturgicLink.setLocationKey(stack, biome);
            offer = new MerchantOffer(costItem.func_77946_l(), stack, 5, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

