/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDisplayReagents
extends Entity {
    public static final int DISPLAY_SWITCH_FREQUENCY = 20;
    private static final int MAX_AGE = 200;
    private static final DataParameter<CompoundNBT> RESOURCE_LOCATIONS = EntityDataManager.func_187226_a(EntityDisplayReagents.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final String NBT_ENTITY_AGE = "entity_age";
    private static final String NBT_LOCATIONS_COUNT = "locations_count";
    private static final String NBT_LOCATIONS_PREFIX = "location_";
    private int age = 0;

    public EntityDisplayReagents(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        this.setAge(this.getAge() + 1);
        if (this.getAge() >= 200) {
            this.remove(false);
        }
    }

    public void setResourceLocations(List<ResourceLocation> list) {
        CompoundNBT data = new CompoundNBT();
        this.writeNBT(data, list);
        this.field_70180_af.func_187227_b(RESOURCE_LOCATIONS, (Object)data);
    }

    public List<ResourceLocation> getResourceLocations() {
        CompoundNBT data = (CompoundNBT)this.field_70180_af.func_187225_a(RESOURCE_LOCATIONS);
        return this.readNBT(data);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RESOURCE_LOCATIONS, (Object)new CompoundNBT());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b(NBT_ENTITY_AGE)) {
            this.setAge(compound.func_74762_e(NBT_ENTITY_AGE));
        }
        this.setResourceLocations(this.readNBT(compound));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_ENTITY_AGE, this.getAge());
        List<ResourceLocation> locations = this.getResourceLocations();
        this.writeNBT(compound, locations);
    }

    private List<ResourceLocation> readNBT(CompoundNBT compound) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        if (!compound.func_74764_b(NBT_LOCATIONS_COUNT)) {
            return locations;
        }
        int count = compound.func_74762_e(NBT_LOCATIONS_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!compound.func_74764_b(NBT_LOCATIONS_PREFIX + i)) continue;
            locations.add(new ResourceLocation(compound.func_74779_i(NBT_LOCATIONS_PREFIX + i)));
        }
        return locations;
    }

    private void writeNBT(CompoundNBT compound, List<ResourceLocation> locations) {
        compound.func_74768_a(NBT_LOCATIONS_COUNT, locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            compound.func_74778_a(NBT_LOCATIONS_PREFIX + i, locations.get(i).toString());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

