/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.ManaAndArtifice;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityFlatLandsProjectile;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFlatLands
extends Entity {
    private BlockPos AABB1;
    private BlockPos AABB2;
    private BlockPos[] targets;
    private int curIndex;
    private int age;
    PlayerEntity caster_reference;
    UUID casterID;

    public EntityFlatLands(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.curIndex >= this.targets.length) {
            this.remove(false);
            return;
        }
        ++this.age;
        if (this.getCaster() == null) {
            if (this.age > 20) {
                this.remove(false);
            }
            return;
        }
        if (this.age % 10 == 0) {
            BlockPos me = this.func_233580_cy_();
            BlockPos target = this.targets[this.curIndex++];
            EntityFlatLandsProjectile proj = (EntityFlatLandsProjectile)((EntityType)EntityInit.FLAT_LANDS_PROJECTILE.get()).func_220331_a((ServerWorld)this.field_70170_p, null, null, me, SpawnReason.NATURAL, true, true);
            proj.setPoints(me, target);
            proj.setCaster(this.getCaster());
            proj.SetSeed(this.field_70170_p.field_73012_v.nextInt());
        }
    }

    public void setBounds(AxisAlignedBB bounds) {
        this.AABB1 = new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c);
        this.AABB2 = new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
        double xDim = bounds.func_216364_b();
        double yDim = bounds.func_216360_c();
        double zDim = bounds.func_216362_d();
        ArrayList<BlockPos> allPoints = new ArrayList<BlockPos>();
        int x = 1;
        while ((double)x <= xDim - 1.0) {
            int y = 1;
            while ((double)y <= yDim - 1.0) {
                int z = 1;
                while ((double)z <= zDim - 1.0) {
                    allPoints.add(new BlockPos(bounds.field_72340_a + (double)x, bounds.field_72338_b + (double)y, bounds.field_72339_c + (double)z));
                    if (!((double)(z += 3) >= zDim) || !((double)z < zDim + 2.0) || (zDim - 2.0) % 3.0 == 0.0) continue;
                    z = (int)(zDim - 1.0);
                }
                if (!((double)(y += 3) > yDim - 1.0) || !((double)y < yDim + 2.0) || (yDim - 2.0) % 3.0 == 0.0) continue;
                y = (int)(yDim - 1.0);
            }
            if (!((double)(x += 3) > xDim - 1.0) || !((double)x < xDim + 2.0) || (xDim - 2.0) % 3.0 == 0.0) continue;
            x = (int)(xDim - 1.0);
        }
        this.targets = new BlockPos[allPoints.size()];
        this.targets = allPoints.toArray(this.targets);
        this.curIndex = 0;
    }

    public void setCaster(PlayerEntity caster) {
        this.caster_reference = caster;
    }

    private PlayerEntity getCaster() {
        if (this.caster_reference == null && this.casterID != null) {
            this.caster_reference = this.field_70170_p.func_217371_b(this.casterID);
        }
        return this.caster_reference;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("min_x") && compound.func_74764_b("min_y") && compound.func_74764_b("min_z")) {
            this.AABB1 = new BlockPos(compound.func_74762_e("min_x"), compound.func_74762_e("min_y"), compound.func_74762_e("min_z"));
        }
        if (compound.func_74764_b("max_x") && compound.func_74764_b("max_y") && compound.func_74764_b("max_z")) {
            this.AABB2 = new BlockPos(compound.func_74762_e("max_x"), compound.func_74762_e("max_y"), compound.func_74762_e("max_z"));
        }
        if (this.AABB1 != null && this.AABB2 != null) {
            AxisAlignedBB bb = MathUtils.createInclusiveBB(this.AABB1, this.AABB2);
            this.setBounds(bb);
        }
        if (compound.func_74764_b("curIndex")) {
            this.curIndex = compound.func_74762_e("curIndex");
        }
        if (compound.func_74764_b("age")) {
            this.age = compound.func_74762_e("age");
        }
        if (compound.func_74764_b("caster_uuid")) {
            try {
                this.casterID = UUID.fromString(compound.func_74779_i("caster_uuid"));
            }
            catch (Exception e) {
                ManaAndArtifice.LOGGER.error("Error loading caster UUID for flat lands projectile!");
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("min_x", this.AABB1.func_177958_n());
        compound.func_74768_a("min_y", this.AABB1.func_177956_o());
        compound.func_74768_a("min_z", this.AABB1.func_177952_p());
        compound.func_74768_a("max_x", this.AABB2.func_177958_n());
        compound.func_74768_a("max_y", this.AABB2.func_177956_o());
        compound.func_74768_a("max_z", this.AABB2.func_177952_p());
        compound.func_74768_a("curIndex", this.curIndex);
        compound.func_74768_a("age", this.age);
        compound.func_74778_a("caster_uuid", this.caster_reference != null ? this.caster_reference.func_110124_au().toString() : "");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

