/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.LivingUtilityEntity;
import com.ma.items.ItemInit;
import com.ma.tools.math.MathUtils;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDemonLord
extends LivingUtilityEntity {
    public static final byte STATE_WAITING_ITEM = 0;
    public static final byte STATE_CONSUMING = 1;
    public static final byte STATE_POINTING = 2;
    public static final byte STATE_IMBUING = 3;
    private Vector3f leftHandTransform;

    public EntityDemonLord(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.stateMachine.addSequenceEntry("consume", 0).onComplete(() -> {
            this.setCurrentAnimation("consuming_item");
            if (!this.field_70170_p.field_72995_K && this.caster != null) {
                this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 100));
            }
        });
        this.stateMachine.addSequenceEntry("consume", 40).onTick(c -> {
            this.animationPct = (float)c.intValue() / 40.0f;
        }).onComplete(() -> {
            if (!this.field_70170_p.field_72995_K) {
                this.setState((byte)2);
            }
            this.stateMachine.runSequence("point");
        });
        this.stateMachine.addSequenceEntry("point", 0).onComplete(() -> this.setCurrentAnimation("pointing_caster"));
        this.stateMachine.addSequenceEntry("point", 20).onTick(c -> {
            this.animationPct = (float)c.intValue() / 20.0f;
        }).onComplete(() -> {
            if (!this.field_70170_p.field_72995_K) {
                this.setState((byte)3);
            }
            this.stateMachine.runSequence("imbue");
        });
        this.stateMachine.addSequenceEntry("imbue", 0).onComplete(() -> {
            this.setCurrentAnimation("lifting_caster");
            if (!this.field_70170_p.field_72995_K) {
                if (this.caster != null) {
                    this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 240, 1));
                }
            } else if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.DEMON_SUMMON_CHANNEL, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        this.stateMachine.addSequenceEntry("imbue", 60).onTick(c -> {
            this.animationPct = (float)c.intValue() / 60.0f;
        }).onComplete(() -> {
            if (!this.field_70170_p.field_72995_K && this.caster != null) {
                this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 190, 2));
            }
        });
        this.stateMachine.addSequenceEntry("imbue", 140).onTick(c -> {
            if (c % 10 == 0 && this.caster != null) {
                this.caster.func_70097_a(DamageSource.field_76370_b, 2.0f);
            }
        }).onComplete(() -> {
            this.setCurrentAnimation("");
            if (!this.field_70170_p.field_72995_K) {
                IPlayerProgression progression;
                if (this.caster.func_70089_S() && (progression = (IPlayerProgression)this.caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null && progression.getTier() < 5) {
                    if (progression.getAlliedFaction() == Faction.NONE) {
                        progression.setAlliedFaction(Faction.DEMONS, this.caster);
                        this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ally_demons"), Util.field_240973_b_);
                    }
                    if (progression.getAlliedFaction() == Faction.DEMONS) {
                        progression.setTier(progression.getTier() + 1, this.caster);
                        this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.advanced", new Object[]{progression.getTier()}), Util.field_240973_b_);
                    }
                }
                this.remove(false);
            }
        });
    }

    @Override
    public void func_70071_h_() {
        boolean remove;
        super.func_70071_h_();
        boolean bl = remove = this.field_70173_aa > 700;
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        byte state = this.getState();
        if (this.caster != null && this.caster.func_70068_e((Entity)this) < 256.0) {
            this.updateRotations(this.caster);
            if (this.getState() == 0) {
                this.updateArmRaise(this.caster);
            } else {
                this.stateMachine.tick();
                if (state >= 2) {
                    this.field_70733_aJ = 0.5f;
                }
                remove = state == 3 && this.stateMachine.isComplete();
            }
        } else {
            remove = true;
        }
        if (remove && !this.field_70170_p.field_72995_K) {
            this.remove(false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K) {
            PlayerEntity player;
            for (int i = 0; i < 75; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.func_226277_ct_() - 0.5 + Math.random(), this.func_226278_cu_() + Math.random() * 1.5, this.func_226281_cx_() - 0.5 + Math.random(), -0.01 + Math.random() * 0.02, (double)0.15f, -0.01 + Math.random() * 0.02);
            }
            UUID caster = this.getCasterUUID();
            if (caster != null && (player = this.field_70170_p.func_217371_b(caster)) != null && player.func_70032_d((Entity)this) < 8.0f) {
                for (int i = 0; i < 75; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), -0.25 + Math.random() * 0.5, (double)0.15f, -0.25 + Math.random() * 0.5);
                }
            }
        }
        this.disableFlightFor(this.caster);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        PlayerEntity mySummoner;
        if (this.getState() != 0) {
            return ActionResultType.FAIL;
        }
        UUID caster = this.getCasterUUID();
        if (caster != null && player != (mySummoner = this.field_70170_p.func_217371_b(caster))) {
            return ActionResultType.FAIL;
        }
        if (player.func_184586_b(hand).func_77973_b() == ItemInit.MOTE_FIRE.get()) {
            player.func_184607_cu().func_190918_g(1);
            this.setState((byte)1);
            this.stateMachine.runSequence("consume");
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == STATE && this.getState() == 1) {
            this.stateMachine.runSequence("consume");
        }
        super.func_184206_a(key);
    }

    private void updateRotations(PlayerEntity player) {
        float targetRotation;
        double d0 = this.func_226277_ct_() - player.func_226277_ct_();
        double d1 = this.func_226281_cx_() - player.func_226281_cx_();
        this.field_70126_B = this.field_70177_z;
        this.field_70177_z = targetRotation = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) + 90.0f;
        this.field_70759_as = targetRotation;
    }

    private void updateArmRaise(PlayerEntity player) {
        float animPct = this.lastTickAnimationPct;
        animPct = player.func_70068_e((Entity)this) > 64.0 ? (animPct -= 0.1f) : (animPct += 0.1f);
        animPct = MathUtils.clamp01(animPct);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(CURRENT_ANIMATION, (Object)"waiting_item");
        }
        this.animationPct = animPct;
    }

    private void spawnParticles() {
        for (int i = 0; i < 10; ++i) {
            Vector3f offset = new Vector3f(-0.25f + (float)Math.random() * 0.5f, 0.0f, -0.3f + (float)Math.random() * 0.6f);
            Quaternion q = Vector3f.field_229181_d_.func_229193_c_(this.field_70177_z);
            offset.func_214905_a(q);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.func_226277_ct_() + (double)offset.func_195899_a(), this.func_226278_cu_() + (double)1.15f, this.func_226281_cx_() + (double)offset.func_195902_c(), -0.01 + Math.random() * 0.02, 0.0, -0.01 + Math.random() * 0.02);
        }
        if (this.leftHandTransform != null) {
            if (this.getState() == 0) {
                Quaternion q = Vector3f.field_229181_d_.func_229193_c_((float)((double)(-this.field_70761_aq / 180.0f) * Math.PI));
                this.leftHandTransform.func_195904_b(-1.3f, -0.7f, 0.7f);
                this.leftHandTransform.func_214905_a(q);
                this.leftHandTransform.func_195898_a(0.5f);
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), this.func_226277_ct_() - (double)this.leftHandTransform.func_195899_a(), this.func_226278_cu_() - (double)this.leftHandTransform.func_195900_b(), this.func_226281_cx_() - (double)this.leftHandTransform.func_195902_c(), 0.0, 0.0, 0.0);
            } else if (this.getState() >= 3 && this.caster != null) {
                Quaternion q = Vector3f.field_229181_d_.func_229193_c_((float)((double)(-this.field_70761_aq / 180.0f) * Math.PI));
                this.leftHandTransform.func_195904_b(-1.0f, -0.7f, -0.7f);
                this.leftHandTransform.func_214905_a(q);
                this.leftHandTransform.func_195898_a(0.5f);
                Vector3d diff = this.caster.func_174824_e(0.0f).func_72441_c(-0.6 * Math.random() * 1.2, -0.6 * Math.random() * 1.2, -0.6 * Math.random() * 1.2).func_178786_a(0.0, (double)0.05f, 0.0).func_178788_d(this.func_213303_ch().func_178786_a((double)this.leftHandTransform.func_195899_a(), (double)this.leftHandTransform.func_195900_b(), (double)this.leftHandTransform.func_195902_c())).func_216372_d((double)0.1f, (double)0.1f, (double)0.1f);
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.func_226277_ct_() - (double)this.leftHandTransform.func_195899_a(), this.func_226278_cu_() - (double)this.leftHandTransform.func_195900_b(), this.func_226281_cx_() - (double)this.leftHandTransform.func_195902_c(), diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
                }
            }
        }
    }

    @Override
    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setLeftHandTransform(Vector3f transform) {
        this.leftHandTransform = transform;
    }
}

