/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers.player;

import com.ma.entities.renderers.player.HandParticleLayer;
import com.ma.entities.renderers.player.SpectralElytraLayer;
import com.ma.items.ItemInit;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.WorldRenderUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerRenderEvents {
    private static boolean addedElytraLayer = false;
    private static boolean addedSpellLayer = false;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        if (!addedElytraLayer) {
            event.getRenderer().func_177094_a(new SpectralElytraLayer(event.getRenderer()));
            addedElytraLayer = true;
        }
        if (!addedSpellLayer) {
            event.getRenderer().func_177094_a(new HandParticleLayer(event.getRenderer()));
            addedSpellLayer = true;
        }
        if (event.getPlayer().getPersistentData().func_74767_n("eldrin_flight")) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.ELDRITCH_ORB.get(), (LivingEntity)event.getPlayer()).ifPresent(t -> {
            Vector3f translation = new Vector3f(1.0f, 2.0f, 0.0f);
            Quaternion rotation = Vector3f.field_229180_c_.func_229193_c_((float)((double)(MathUtils.lerpf(event.getPlayer().field_70758_at, event.getPlayer().field_70759_as, event.getPartialRenderTick()) / 180.0f) * Math.PI));
            translation.func_214905_a(rotation);
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227861_a_((double)translation.func_195899_a(), (double)translation.func_195900_b(), (double)translation.func_195902_c());
            WorldRenderUtils.renderRadiant((Entity)event.getPlayer(), event.getMatrixStack(), event.getBuffers(), new int[]{0, 51, 102}, new int[]{179, 217, 255}, 255, 0.01f);
            event.getMatrixStack().func_227865_b_();
        });
    }
}

