/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.models;

import com.ma.tools.math.Vector3;
import java.util.HashMap;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelPositionData {
    private HashMap<ModelRenderer, VectorPair> positionData = new HashMap();

    public ModelPositionData addPositionDegrees(ModelRenderer renderer, Vector3 startRotation, Vector3 endRotation) {
        startRotation = startRotation.scale((float)(-Math.PI) / 180);
        endRotation = endRotation.scale((float)(-Math.PI) / 180);
        this.positionData.put(renderer, new VectorPair(startRotation, endRotation));
        return this;
    }

    public ModelPositionData addPositionDegrees(ModelRenderer renderer, Vector3 endRotation) {
        Vector3 startRotation = new Vector3(renderer.field_78795_f, renderer.field_78796_g, renderer.field_78808_h);
        endRotation = endRotation.scale((float)(-Math.PI) / 180);
        this.positionData.put(renderer, new VectorPair(startRotation, endRotation));
        return this;
    }

    public ModelPositionData addPositionDegrees(ModelRenderer renderer) {
        Vector3 startRotation = new Vector3(renderer.field_78795_f, renderer.field_78796_g, renderer.field_78808_h);
        this.positionData.put(renderer, new VectorPair(startRotation, startRotation));
        return this;
    }

    public void startLerp() {
        this.positionData.forEach((renderer, pair) -> pair.setStart(new Vector3(renderer.field_78795_f, renderer.field_78796_g, renderer.field_78808_h)));
    }

    public void lerpRotations(float t) {
        this.positionData.forEach((renderer, pair) -> {
            Vector3 interp = pair.lerp(t);
            renderer.field_78795_f = interp.x;
            renderer.field_78796_g = interp.y;
            renderer.field_78808_h = interp.z;
        });
    }

    private class VectorPair {
        private Vector3 start;
        private final Vector3 end;

        public VectorPair(Vector3 start, Vector3 end) {
            this.start = start;
            this.end = end;
        }

        public void setStart(Vector3 start) {
            this.start = start;
        }

        public Vector3 lerp(float t) {
            return Vector3.lerp(this.start, this.end, t);
        }
    }
}

