/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.items.IFactionSpecific;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.EntityInit;
import com.ma.items.ItemInit;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityBroker
extends WanderingTraderEntity
implements IAnimatable {
    private static List<Item> allFactionItems;
    private static final HashMap<Faction, Item> faction_tokens;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private MerchantOffers customerLimitedOffers;
    private static final DataParameter<Boolean> DESPAWNING;

    public EntityBroker(EntityType<? extends WanderingTraderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityBroker(World world) {
        this((EntityType<? extends WanderingTraderEntity>)((EntityType)EntityInit.BROKER.get()), world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public SoundEvent func_213714_ea() {
        return SFX.Entity.Broker.DEAL;
    }

    protected SoundEvent func_213721_r(boolean getYesSound) {
        if (getYesSound) {
            return SFX.Entity.Broker.DEAL;
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESPAWNING, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!((Boolean)this.field_70180_af.func_187225_a(DESPAWNING)).booleanValue() && this.func_213735_eg() == 1) {
            this.func_213728_s(10);
            this.field_70180_af.func_187227_b(DESPAWNING, (Object)true);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Spell.Impact.AoE.ARCANE, SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            for (int i = 0; i < 100; ++i) {
                int type = (int)Math.floor(Math.random() * 4.0);
                if (type != 2) {
                    this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)(type == 0 ? (ParticleType)ParticleInit.ARCANE.get() : (type == 2 ? (ParticleType)ParticleInit.DUST.get() : (ParticleType)ParticleInit.FLAME.get()))), this.func_226277_ct_() + Math.random() * 2.0 - 1.0, this.func_226278_cu_() + Math.random() * 2.5, this.func_226281_cx_() + Math.random() * 2.0 - 1.0, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.func_226277_ct_() + Math.random() * 2.0 - 1.0, this.func_226278_cu_() + Math.random() * 2.5, this.func_226281_cx_() + Math.random() * 2.0 - 1.0, 0.18, 0.3, 0.03);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (!((Boolean)this.field_70180_af.func_187225_a(DESPAWNING)).booleanValue()) {
            this.func_213728_s(10);
            this.field_70180_af.func_187227_b(DESPAWNING, (Object)true);
        }
        return false;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public void func_213704_a(MerchantOffer offer) {
        this.field_213724_bz.stream().filter(o -> o.func_222204_a(offer.func_222205_b(), offer.func_222202_c())).findFirst().ifPresent(o -> o.func_222219_j());
        this.func_184185_a(this.func_213721_r(true), this.func_70599_aP(), this.func_70647_i());
        super.func_213704_a(offer);
    }

    protected void func_213717_a(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        givenMerchantOffers.clear();
        if (allFactionItems == null) {
            allFactionItems = ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof IFactionSpecific).collect(Collectors.toList());
        }
        Random rand = new Random();
        for (Item factionItem : allFactionItems) {
            Faction thisFaction = ((IFactionSpecific)factionItem).getFaction();
            ItemStack output = new ItemStack((IItemProvider)factionItem);
            List opposingFactionItems = allFactionItems.stream().filter(i -> ((IFactionSpecific)i).getFaction() != Faction.NONE && ((IFactionSpecific)i).getFaction() != thisFaction).collect(Collectors.toList());
            ItemStack opposingItemPrice = new ItemStack((IItemProvider)opposingFactionItems.get(rand.nextInt(opposingFactionItems.size())));
            ItemStack tokenPrice = this.getRandomOpposingToken(thisFaction);
            tokenPrice.func_190920_e(32 + rand.nextInt(32));
            MerchantOffer offer = new MerchantOffer(opposingItemPrice, tokenPrice, output, 1, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
    }

    private ItemStack getRandomOpposingToken(Faction faction) {
        List otherFactions = Arrays.asList(Faction.values()).stream().filter(f -> f != faction && f != Faction.NONE).collect(Collectors.toList());
        Collections.shuffle(otherFactions);
        Faction selected = (Faction)((Object)otherFactions.get(0));
        return new ItemStack((IItemProvider)faction_tokens.get((Object)selected));
    }

    protected void func_213712_ef() {
        MerchantOffers merchantoffers = this.func_213706_dY();
        this.func_213717_a(merchantoffers, null, 5);
    }

    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
            this.func_213712_ef();
        }
        return this.customerLimitedOffers != null ? this.customerLimitedOffers : this.field_213724_bz;
    }

    public void func_70932_a_(PlayerEntity player) {
        super.func_70932_a_(player);
        if (player != null) {
            this.func_213706_dY();
            this.customerLimitedOffers = new MerchantOffers(this.field_213724_bz.func_222199_a());
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                for (int i = 0; i < this.customerLimitedOffers.size(); ++i) {
                    MerchantOffer offer = (MerchantOffer)this.customerLimitedOffers.get(i);
                    Item output = offer.func_222206_f().func_77973_b();
                    Optional<ManaweavingRecipe> recipe = this.field_70170_p.func_199532_z().func_241447_a_(RecipeInit.MANAWEAVING_RECIPE_TYPE).stream().filter(r -> r.func_77571_b().func_77973_b() == output).findFirst();
                    if (recipe != null && recipe.isPresent() && recipe.get().getTier() <= p.getTier()) continue;
                    offer.func_222216_p();
                }
            });
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!((Boolean)this.field_70180_af.func_187225_a(DESPAWNING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", Boolean.valueOf(true)));
        } else {
            event.getController().transitionLengthTicks = 5.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.slam", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    static {
        faction_tokens = new HashMap();
        faction_tokens.put(Faction.ANCIENT_WIZARDS, (Item)ItemInit.MARK_OF_THE_COUNCIL.get());
        faction_tokens.put(Faction.DEMONS, (Item)ItemInit.MARK_OF_THE_NETHER.get());
        faction_tokens.put(Faction.FEY_COURT, (Item)ItemInit.MARK_OF_THE_FEY.get());
        faction_tokens.put(Faction.UNDEAD, (Item)ItemInit.MARK_OF_THE_UNDEAD.get());
        DESPAWNING = EntityDataManager.func_187226_a(EntityBroker.class, (IDataSerializer)DataSerializers.field_187198_h);
    }
}

