/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.animated;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.attributes.AttributeInit;
import com.ma.entities.constructs.ai.ConstructActivate;
import com.ma.entities.constructs.ai.ConstructBreed;
import com.ma.entities.constructs.ai.ConstructButcher;
import com.ma.entities.constructs.ai.ConstructChop;
import com.ma.entities.constructs.ai.ConstructCommandFollowLodestar;
import com.ma.entities.constructs.ai.ConstructCommandFollowOwner;
import com.ma.entities.constructs.ai.ConstructCommandReturnToTable;
import com.ma.entities.constructs.ai.ConstructCommandStay;
import com.ma.entities.constructs.ai.ConstructDropItem;
import com.ma.entities.constructs.ai.ConstructHarvest;
import com.ma.entities.constructs.ai.ConstructMove;
import com.ma.entities.constructs.ai.ConstructPatrol;
import com.ma.entities.constructs.ai.ConstructPlaceBlock;
import com.ma.entities.constructs.ai.ConstructPlaceItem;
import com.ma.entities.constructs.ai.ConstructPlant;
import com.ma.entities.constructs.ai.ConstructRuneforge;
import com.ma.entities.constructs.ai.ConstructRunescribe;
import com.ma.entities.constructs.ai.ConstructShear;
import com.ma.entities.constructs.ai.ConstructTakeItem;
import com.ma.entities.constructs.ai.ConstructWait;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.AnimatedConstructConstruction;
import com.ma.entities.constructs.animated.AnimatedConstructDiagnostics;
import com.ma.entities.sorcery.targeting.EntitySpellProjectile;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.constructs.parts._base.ConstructSlot;
import com.ma.items.constructs.parts._base.ItemConstructPart;
import com.ma.items.constructs.parts.head.ConstructPartHornHead;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.MATags;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.easing.EasingType;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityAnimatedConstruct
extends GolemEntity
implements IAnimPacketSync<EntityAnimatedConstruct>,
IAnimatable,
AnimationController.ICustomInstructionListener,
IJumpingMount {
    private static final String NBT_OWNER = "owner";
    private static final float PART_DROP_CHANCE = 0.5f;
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Float> MANA = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_MANA = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BUOYANCY = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> STEERABLE = EntityDataManager.func_187226_a(EntityAnimatedConstruct.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimatedConstructConstruction constructCapabilities;
    AnimatedConstructDiagnostics constructDiagnostics;
    private boolean needsSync = true;
    private boolean requestingDiagnostics = false;
    private PlayerEntity cached_owner;
    private AnimationFactory animFactory;
    protected boolean constructJumping;
    private final HashMap<ConstructActions, ConstructCommand> _registeredCommands;
    private ConstructCommand current;
    private static ArrayList<DamageSource> irresistibleDamageTypes = new ArrayList();
    private static final float MANA_PER_RANGED_ATTACK = 5.0f;
    private int chargeCounter = 0;
    protected float jumpPower;
    private int hornDelay = 0;
    private double lastYd;
    private boolean ANIM_PACKET = false;
    private boolean isRangedAttacking = false;
    private boolean redirectingDamage = false;

    public EntityAnimatedConstruct(EntityType<? extends GolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.5f;
        this.animFactory = new AnimationFactory((IAnimatable)this);
        this.constructCapabilities = new AnimatedConstructConstruction();
        this.constructDiagnostics = new AnimatedConstructDiagnostics();
        this._registeredCommands = new HashMap();
        this._registeredCommands.put(ConstructActions.STAY, new ConstructCommandStay(this));
        this._registeredCommands.put(ConstructActions.FOLLOW_DEFEND, new ConstructCommandFollowOwner(this));
        this._registeredCommands.put(ConstructActions.MODIFY, new ConstructCommandReturnToTable(this));
        this._registeredCommands.put(ConstructActions.LODESTAR, new ConstructCommandFollowLodestar(this));
        this._registeredCommands.put(ConstructActions.TAKE, new ConstructTakeItem(this));
        this._registeredCommands.put(ConstructActions.PLACE_ITEM, new ConstructPlaceItem(this));
        this._registeredCommands.put(ConstructActions.RUNESCRIBE, new ConstructRunescribe(this));
        this._registeredCommands.put(ConstructActions.RUNEFORGE, new ConstructRuneforge(this));
        this._registeredCommands.put(ConstructActions.ACTIVATE, new ConstructActivate(this));
        this._registeredCommands.put(ConstructActions.HARVEST, new ConstructHarvest(this));
        this._registeredCommands.put(ConstructActions.PLANT, new ConstructPlant(this));
        this._registeredCommands.put(ConstructActions.CHOP, new ConstructChop(this));
        this._registeredCommands.put(ConstructActions.BUTCHER, new ConstructButcher(this));
        this._registeredCommands.put(ConstructActions.BREED, new ConstructBreed(this));
        this._registeredCommands.put(ConstructActions.PATROL, new ConstructPatrol(this));
        this._registeredCommands.put(ConstructActions.PLACE_BLOCK, new ConstructPlaceBlock(this));
        this._registeredCommands.put(ConstructActions.MOVE, new ConstructMove(this));
        this._registeredCommands.put(ConstructActions.WAIT, new ConstructWait(this));
        this._registeredCommands.put(ConstructActions.DROP_ITEM, new ConstructDropItem(this));
        this._registeredCommands.put(ConstructActions.SHEAR, new ConstructShear(this));
    }

    public EntityAnimatedConstruct(World worldIn) {
        this((EntityType<? extends GolemEntity>)((EntityType)EntityInit.ANIMATED_CONSTRUCT.get()), worldIn);
    }

    private void recalculateAll() {
        if (this.constructCapabilities != null) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.constructCapabilities.calculateMaxHealth());
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)this.constructCapabilities.calculateSpeed());
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)this.constructCapabilities.calculateDamage());
            this.func_110148_a(Attributes.field_233825_h_).func_111128_a((double)this.constructCapabilities.calculateAttackRate());
            this.func_110148_a(Attributes.field_233824_g_).func_111128_a((double)this.constructCapabilities.calculateKnockback());
            this.func_110148_a(Attributes.field_233820_c_).func_111128_a((double)this.constructCapabilities.calculateKnockbackResistance());
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a((double)this.constructCapabilities.calculateArmor());
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a((double)this.constructCapabilities.calculateToughness());
            this.func_110148_a((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).func_111128_a((double)this.constructCapabilities.calculatePerception());
            this.func_110148_a((Attribute)AttributeInit.INTELLIGENCE.get()).func_111128_a((double)this.constructCapabilities.calculateIntelligence());
            this.func_110148_a((Attribute)AttributeInit.RANGED_DAMAGE.get()).func_111128_a((double)this.constructCapabilities.calculateRangedDamage());
            this.field_70180_af.func_187227_b(MAX_MANA, (Object)Float.valueOf(this.constructCapabilities.calculateMana()));
            this.field_70180_af.func_187227_b(BUOYANCY, (Object)Float.valueOf(this.constructCapabilities.calculateBuoyancy()));
            this.field_70699_by.func_212239_d(this.func_204231_K());
            if (this.func_204231_K()) {
                this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(2.0);
            }
        }
    }

    public void setConstructParts(@Nonnull ItemConstructPart head, @Nonnull ItemConstructPart torso, @Nonnull ItemConstructPart left_arm, @Nonnull ItemConstructPart right_arm, @Nonnull ItemConstructPart legs) {
        this.constructCapabilities.setPart(head, false);
        this.constructCapabilities.setPart(torso, false);
        this.constructCapabilities.setPart(left_arm, false);
        this.constructCapabilities.setPart(right_arm, false);
        this.constructCapabilities.setPart(legs, true);
        this.recalculateAll();
    }

    public void setConstructParts(AnimatedConstructConstruction construction) {
        this.constructCapabilities = construction.copy();
        this.recalculateAll();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_82168_bl();
        if (this.hornDelay > 0) {
            --this.hornDelay;
        }
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.needsSync) {
            this.needsSync = false;
            if (!this.field_70170_p.field_72995_K) {
                ServerMessageDispatcher.sendEntityStateMessage(this);
            } else {
                ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.requestingDiagnostics && this.field_70173_aa % 20 == 0) {
            ClientMessageDispatcher.sendAnimatedConstructSyncRequestMessage(this, true);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                if (this.func_70090_H() && (double)this.getWaterLevelAbove() - this.func_226278_cu_() > 0.5) {
                    if (this.func_204231_K()) {
                        if (this.func_213322_ci().func_82617_b() < 0.0) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(0.01f * this.getBuoyancy()), 0.0));
                        }
                    } else {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01 * (double)this.getBuoyancy(), 0.0));
                    }
                    this.lastYd = 0.0;
                }
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.field_70138_W = 1.5f;
                if (this.jumpPower > 0.0f && !this.isJumping() && this.field_70122_E) {
                    double d0 = this.getJumpStrength() * (double)this.jumpPower * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    float horizontalScale = 1.8f;
                    Vector3d vector3d = this.func_213322_ci();
                    this.func_213293_j(vector3d.field_72450_a * (double)horizontalScale, d1, vector3d.field_72449_c * (double)horizontalScale);
                    this.func_70637_d(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * 0.35f);
                    super.func_213352_e(new Vector3d((double)f, travelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.func_70637_d(false);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                this.jumpPower = 0.02f;
                super.func_213352_e(travelVector);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        this.setRiderPosition(passenger, Entity::func_70107_b);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.lastYd = this.func_213322_ci().field_72448_b;
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public float func_189749_co() {
        return this.canSwim() ? 0.9f : super.func_189749_co();
    }

    protected boolean func_184219_q(Entity entityIn) {
        return this.getConstructData().isCapabilityEnabled(ConstructCapability.CARRY_PLAYER) && entityIn == this.getOwner();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return ((Float)this.field_70180_af.func_187225_a(BUOYANCY)).floatValue() >= 1.0f;
    }

    public boolean func_205710_ba() {
        return ((Float)this.field_70180_af.func_187225_a(BUOYANCY)).floatValue() >= 1.0f;
    }

    public boolean func_82171_bF() {
        return (Boolean)this.field_70180_af.func_187225_a(STEERABLE);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI();
    }

    public boolean func_184776_b() {
        return true;
    }

    public double func_70042_X() {
        return 0.43;
    }

    public boolean isJumping() {
        return this.constructJumping;
    }

    public double getJumpStrength() {
        return 1.25;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nullable
    public PlayerEntity getOwner() {
        if (this.field_70180_af.func_187225_a(OWNER_UUID) == null || !((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent()) {
            return null;
        }
        if (this.cached_owner == null || !this.cached_owner.func_70089_S()) {
            this.cached_owner = this.field_70170_p.func_217371_b((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get());
        }
        return this.cached_owner;
    }

    public <T extends ConstructCommand> T getCommand(ConstructActions type) {
        return (T)((Object)this._registeredCommands.get((Object)type));
    }

    public int getCarrySize() {
        return Math.max(1, 2 * this.constructCapabilities.getAffinityScore(Affinity.ENDER));
    }

    public int getIntelligence() {
        return (int)this.func_110148_a((Attribute)AttributeInit.INTELLIGENCE.get()).func_111126_e();
    }

    public Hand[] getEmptyHands() {
        ArrayList emptyHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                emptyHands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (p.getModelTypeMutex() == 1 && this.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
                emptyHands.add(Hand.OFF_HAND);
            }
        });
        return emptyHands.toArray(new Hand[0]);
    }

    public Hand[] getCarryingHands() {
        return this.getCarryingHands(null);
    }

    public Hand[] getCarryingHands(Predicate<ItemStack> filter) {
        ArrayList carryingHands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            ItemStack left;
            if (p.getModelTypeMutex() == 1 && !(left = this.func_184586_b(Hand.MAIN_HAND)).func_190926_b() && (filter == null || filter.test(left))) {
                carryingHands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            ItemStack right;
            if (p.getModelTypeMutex() == 1 && !(right = this.func_184586_b(Hand.OFF_HAND)).func_190926_b() && (filter == null || filter.test(right))) {
                carryingHands.add(Hand.OFF_HAND);
            }
        });
        return carryingHands.toArray(new Hand[0]);
    }

    public boolean func_70648_aU() {
        return this.getConstructData().isCapabilityEnabled(ConstructCapability.BREATHE_UNDERWATER);
    }

    public boolean func_184585_cz() {
        return this.getConstructData().isCapabilityEnabled(ConstructCapability.BLOCK) && !this.isRangedAttacking && !this.field_82175_bq;
    }

    public AnimatedConstructConstruction getConstructData() {
        return this.constructCapabilities;
    }

    public boolean canSwim() {
        return ((Float)this.field_70180_af.func_187225_a(BUOYANCY)).floatValue() >= 1.0f;
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.ANIM_PACKET) {
            nbt.func_74774_a("anim", (byte)1);
            if (this.field_184622_au != null) {
                nbt.func_74774_a("hand", (byte)this.field_184622_au.ordinal());
            }
            nbt.func_74757_a("is_ranged_attacking", this.isRangedAttacking);
        } else if (!this.requestingDiagnostics) {
            this.constructCapabilities.WriteNBT(nbt);
        } else {
            nbt.func_218657_a("diag", (INBT)this.constructDiagnostics.writeToNBT());
        }
        return nbt;
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    public LinkedList<String> getDiagnostics() {
        return this.constructDiagnostics.getMessages();
    }

    public Optional<Hand> getHandWithCapability(ConstructCapability capability) {
        ArrayList hands = new ArrayList();
        this.constructCapabilities.getPart(ConstructSlot.LEFT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(Hand.MAIN_HAND);
            }
        });
        this.constructCapabilities.getPart(ConstructSlot.RIGHT_ARM).ifPresent(p -> {
            if (Arrays.asList(p.getEnabledCapabilities()).contains((Object)capability)) {
                hands.add(Hand.OFF_HAND);
            }
        });
        if (hands.size() > 0) {
            Random r = new Random();
            Hand h = (Hand)hands.get(r.nextInt(hands.size()));
            return Optional.of(h);
        }
        return Optional.empty();
    }

    public boolean hasManaForRangedAttack() {
        return this.getMana() >= 5.0f;
    }

    public float getMaxMana() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_MANA)).floatValue();
    }

    public boolean isRangedAttacking() {
        return this.isRangedAttacking;
    }

    public float getMana() {
        return ((Float)this.field_70180_af.func_187225_a(MANA)).floatValue();
    }

    public float getManaPct() {
        if (this.getMaxMana() == 0.0f) {
            return 1.0f;
        }
        return MathUtils.clamp01(this.getMana() / Math.max(this.getMaxMana(), 1.0f));
    }

    public float getBuoyancy() {
        return ((Float)this.field_70180_af.func_187225_a(BUOYANCY)).floatValue();
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public void setOwner(UUID playerID) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(playerID));
    }

    public void setCurrentCommand(PlayerEntity player, ConstructCommand cmd) {
        ConstructCommand myCommand;
        if (((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent() && !((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get()).equals(player.func_110124_au())) {
            this.pushDiagnosticMessage(new TranslationTextComponent("mana-and-artifice.constructs.feedback.notowner", new Object[]{player.func_145748_c_().getString()}).getString());
            return;
        }
        if (this.current != null) {
            this.field_70714_bg.func_85156_a((Goal)this.current);
        }
        if ((myCommand = this._registeredCommands.get((Object)cmd.getType())) != cmd) {
            myCommand.copyFrom(cmd);
        }
        myCommand.onTaskSet();
        this.current = myCommand;
        this.field_70714_bg.func_75776_a(1, (Goal)myCommand);
        if (this.current != null && (this.current.getType() == ConstructActions.FOLLOW_DEFEND || this.current.getType() == ConstructActions.STAY)) {
            this.field_70180_af.func_187227_b(STEERABLE, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(STEERABLE, (Object)false);
        }
    }

    public void setRequestingDiagnostics(boolean requesting) {
        this.requestingDiagnostics = requesting;
    }

    public void func_70637_d(boolean jumping) {
        this.constructJumping = jumping;
    }

    public void adjustMana(float amount) {
        float mana = this.getMana();
        if ((mana += amount) > this.getMaxMana()) {
            mana = this.getMaxMana();
        }
        this.field_70180_af.func_187227_b(MANA, (Object)Float.valueOf(mana));
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn == null && !this.field_70170_p.field_72995_K) {
            this.resetAttackState();
        }
        if (entitylivingbaseIn == this || entitylivingbaseIn == this.getOwner()) {
            return;
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    public void func_184775_b(int jumpPower) {
    }

    public void func_184777_r_() {
    }

    private void setRiderPosition(Entity entity, Entity.IMoveCallback callback) {
        if (this.func_184196_w(entity)) {
            Vector3d fwd = Vector3d.func_189984_a((Vector2f)this.func_189653_aC()).func_72432_b().func_186678_a(-0.25);
            double d0 = this.func_226278_cu_() + this.func_70042_X();
            callback.accept(entity, this.func_226277_ct_() + fwd.field_72450_a, d0, this.func_226281_cx_() + fwd.field_72449_c);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        if (offHand.func_77973_b() != ItemInit.CONSTRUCT_CONTROL_ROD.get() && mainHand.func_77973_b() != ItemInit.CONSTRUCT_CONTROL_ROD.get() && offHand.func_77973_b() != ItemInit.CONSTRUCT_DIAGNOSTICS_ROD.get() && mainHand.func_77973_b() != ItemInit.CONSTRUCT_DIAGNOSTICS_ROD.get() && this.func_184219_q((Entity)player)) {
            this.mountTo(player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70125_A = this.field_70125_A;
            player.field_70177_z = this.field_70177_z;
            player.func_184220_m((Entity)this);
            if (this.current != null && (this.current.getType() == ConstructActions.FOLLOW_DEFEND || this.current.getType() == ConstructActions.STAY)) {
                this.field_70180_af.func_187227_b(STEERABLE, (Object)true);
            } else {
                this.field_70180_af.func_187227_b(STEERABLE, (Object)false);
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityAnimatedConstruct) {
            return;
        }
        super.func_82167_n(entityIn);
    }

    public void soundHorn() {
        if (this.hornDelay > 0) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            ClientMessageDispatcher.dispatchConstructHorn(this.func_145782_y());
        } else {
            Optional<ItemConstructPart> head = this.getConstructData().getPart(ConstructSlot.HEAD);
            if (head.isPresent() && head.get() instanceof ConstructPartHornHead) {
                this.func_184185_a(SFX.Entity.Construct.HORN, 1.0f, (float)(0.9 + Math.random() * 0.2));
                this.hornDelay = 100;
            }
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        super.func_213345_d(damageSourceIn);
        for (ConstructSlot slot : ConstructSlot.values()) {
            this.constructCapabilities.getPart(slot).ifPresent(p -> {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack drops = ItemStack.field_190927_a;
                    if (Math.random() > 0.5) {
                        drops = new ItemStack((IItemProvider)p);
                    } else {
                        switch (p.getMaterial()) {
                            case DIAMOND: {
                                drops = new ItemStack((IItemProvider)Items.field_151045_i, 3);
                                break;
                            }
                            case GOLD: {
                                drops = new ItemStack((IItemProvider)Items.field_151043_k, 3);
                                break;
                            }
                            case IRON: {
                                drops = new ItemStack((IItemProvider)Items.field_151042_j, 3);
                                break;
                            }
                            case OBSIDIAN: {
                                drops = new ItemStack((IItemProvider)Items.field_221655_bP, 3);
                                break;
                            }
                            case STONE: {
                                drops = new ItemStack((IItemProvider)Items.field_221574_b, 3);
                                break;
                            }
                            case WOOD: {
                                List<Item> items = MATags.smartLookupItem(new ResourceLocation("logs"));
                                if (items == null || items.size() <= 0) break;
                                drops = new ItemStack((IItemProvider)items.get((int)(Math.random() * (double)items.size())), 3);
                                break;
                            }
                        }
                    }
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), drops);
                    if (damageSourceIn.func_94541_c()) {
                        itementity.func_213293_j(-0.5 + Math.random(), Math.random() * 0.5, -0.5 + Math.random());
                    }
                    itementity.func_174869_p();
                    this.field_70170_p.func_217376_c((Entity)itementity);
                }
            });
        }
    }

    public void pushDiagnosticMessage(String message) {
        this.pushDiagnosticMessage(message, true);
    }

    protected void func_82168_bl() {
        int i = 16;
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    public void resetAttackState() {
        this.chargeCounter = 0;
        this.isRangedAttacking = false;
        this.ANIM_PACKET = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.ANIM_PACKET = false;
    }

    public void consumeManaForRangedAttack() {
        this.adjustMana(-5.0f);
    }

    public boolean performRangedAttack(LivingEntity attackTarget) {
        if (!this.func_70635_at().func_75522_a((Entity)attackTarget)) {
            this.func_70661_as().func_75497_a((Entity)attackTarget, this.func_233637_b_(Attributes.field_233821_d_));
            return false;
        }
        this.field_70180_af.func_187227_b(STEERABLE, (Object)false);
        this.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
        ++this.chargeCounter;
        this.func_70661_as().func_75499_g();
        if (this.chargeCounter == 1) {
            this.isRangedAttacking = true;
            this.getHandWithCapability(ConstructCapability.RANGED_ATTACK).ifPresent(h -> {
                this.field_184622_au = h;
            });
            this.ANIM_PACKET = true;
            ServerMessageDispatcher.sendEntityStateMessage(this);
            this.ANIM_PACKET = false;
        } else if (this.chargeCounter == 20) {
            Affinity aff = this.getConstructData().getRandomContainedAffinity();
            EntitySpellProjectile esp = new EntitySpellProjectile((LivingEntity)this, this.field_70170_p);
            esp.setForcedDamageAffinityAndTarget(aff, (float)this.func_110148_a((Attribute)AttributeInit.RANGED_DAMAGE.get()).func_111126_e(), (Entity)this.func_70638_az());
            esp.shoot((Entity)this, attackTarget.func_174824_e(0.0f).func_178788_d(this.func_213303_ch()), 1.0f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)esp);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Spell.Cast.ForAffinity(aff), SoundCategory.NEUTRAL, 0.25f, (float)(0.9 + Math.random() * 0.1));
            this.consumeManaForRangedAttack();
        } else if (this.chargeCounter == 40) {
            this.resetAttackState();
            this.field_70180_af.func_187227_b(STEERABLE, (Object)true);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.constructDiagnostics.pushDiagnosticMessage(new TranslationTextComponent("mana-and-artifice.constructs.feedback.death").getString(), false);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source.func_76364_f() == this.func_184179_bs()) {
            return false;
        }
        if (source.func_76364_f() != null && this.getOwner() != null && source.func_76364_f() == this.getOwner()) {
            return false;
        }
        if (this.func_184179_bs() != null && !this.redirectingDamage) {
            this.redirectingDamage = true;
            this.func_184179_bs().func_70097_a(source, amount);
            this.redirectingDamage = false;
            return false;
        }
        float resistance = 0.0f;
        if (!(source.func_76357_e() || source.func_76363_c() || irresistibleDamageTypes.contains(source))) {
            if (source.func_82725_o()) {
                resistance = 0.05f * (float)this.constructCapabilities.getAffinityScore(Affinity.ARCANE);
            } else if (!source.func_94541_c() && !source.func_76347_k()) {
                resistance = 0.05f * (float)this.constructCapabilities.getAffinityScore(Affinity.EARTH);
            }
        }
        if (source.func_94541_c()) {
            resistance += this.constructCapabilities.calculateExplosionResistance();
        }
        amount -= amount * resistance;
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.constructCapabilities.getAffinityScore(Affinity.FIRE) > 0) {
                entityIn.func_70015_d(this.constructCapabilities.getAffinityScore(Affinity.FIRE));
            }
            if (this.constructCapabilities.isCapabilityEnabled(ConstructCapability.TAUNT) && entityIn instanceof CreatureEntity) {
                ((CreatureEntity)entityIn).func_70624_b((LivingEntity)this);
                if (Math.random() < 0.01) {
                    this.func_184185_a(SFX.Entity.Construct.HORN, 1.0f, (float)(0.9 + Math.random() * 0.2));
                }
            }
            return true;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.constructCapabilities != null) {
            this.constructCapabilities.WriteNBT(compound);
        }
        compound.func_74778_a(NBT_OWNER, this.field_70180_af.func_187225_a(OWNER_UUID) != null && ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent() ? ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get()).toString() : "");
        if (this.current != null) {
            compound.func_218657_a("currentGoal", (INBT)this.current.writeNBT());
        }
        compound.func_74776_a("mana", ((Float)this.field_70180_af.func_187225_a(MANA)).floatValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.constructCapabilities.ReadNBT(compound);
        if (compound.func_74764_b(NBT_OWNER)) {
            try {
                this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(UUID.fromString(compound.func_74779_i(NBT_OWNER))));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Error loading construct owner UUID.  It is now unclaimed and can be claimed by any player.");
            }
        }
        this.recalculateAll();
        if (compound.func_74764_b("mana")) {
            this.field_70180_af.func_187227_b(MANA, (Object)Float.valueOf(compound.func_74760_g("mana")));
        }
        if (compound.func_74764_b("currentGoal")) {
            CompoundNBT goalData = compound.func_74775_l("currentGoal");
            ConstructActions action = ConstructCommand.getTypeFromNBT(goalData);
            this.current = this.getCommand(action);
            this.current.readNBT(goalData);
            if (this.current != null && (this.current.getType() == ConstructActions.FOLLOW_DEFEND || this.current.getType() == ConstructActions.STAY)) {
                this.field_70180_af.func_187227_b(STEERABLE, (Object)true);
            } else {
                this.field_70180_af.func_187227_b(STEERABLE, (Object)false);
            }
            this.field_70714_bg.func_75776_a(1, (Goal)this.current);
        }
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233825_h_, 20.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get(), 8.0).func_233815_a_((Attribute)AttributeInit.INTELLIGENCE.get(), 8.0).func_233815_a_((Attribute)AttributeInit.RANGED_DAMAGE.get(), 0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(MANA, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(MAX_MANA, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(STEERABLE, (Object)false);
        this.field_70180_af.func_187214_a(BUOYANCY, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new ConstructSwimGoal());
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        if (nbt.func_74764_b("anim")) {
            if (nbt.func_74764_b("hand")) {
                this.field_184622_au = Hand.values()[nbt.func_74771_c("hand")];
            }
            this.isRangedAttacking = nbt.func_74767_n("is_ranged_attacking");
        } else {
            this.constructCapabilities.ReadNBT(nbt);
            this.recalculateAll();
        }
        if (nbt.func_74764_b("diag")) {
            this.constructDiagnostics.readFromNBT(nbt.func_150295_c("diag", 8));
        }
    }

    public void pushDiagnosticMessage(String message, boolean allowDuplicates) {
        this.constructDiagnostics.pushDiagnosticMessage(message, allowDuplicates);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isAddedToWorld()) {
            return PlayState.STOP;
        }
        event.getController().easingType = EasingType.Linear;
        if (this.isRangedAttacking) {
            if (this.field_184622_au == null || this.field_184622_au == Hand.MAIN_HAND) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.shoot_left", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.shoot_right", Boolean.valueOf(false)));
            }
        } else if (this.field_82175_bq) {
            if (this.field_184622_au == Hand.MAIN_HAND) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.swing_left", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.swing_right", Boolean.valueOf(false)));
            }
        } else if (!this.field_70122_E) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.airborne", Boolean.valueOf(true)));
        } else {
            double speed = this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c();
            event.getController().transitionLengthTicks = 5.0;
            if (speed > (double)0.4f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.sprint", Boolean.valueOf(true)));
            } else if (speed > (double)0.2f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.run", Boolean.valueOf(true)));
            } else if (speed > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.walk", Boolean.valueOf(true)));
            } else {
                event.getController().transitionLengthTicks = 10.0;
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.animated_construct.idle", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public void executeInstruction(CustomInstructionKeyframeEvent event) {
    }

    static {
        irresistibleDamageTypes.add(DamageSource.field_191291_g);
        irresistibleDamageTypes.add(DamageSource.field_76369_e);
        irresistibleDamageTypes.add(DamageSource.field_205132_u);
        irresistibleDamageTypes.add(DamageSource.field_76379_h);
        irresistibleDamageTypes.add(DamageSource.field_76368_d);
        irresistibleDamageTypes.add(DamageSource.field_76380_i);
        irresistibleDamageTypes.add(DamageSource.field_76366_f);
    }

    class ConstructSwimGoal
    extends Goal {
        public ConstructSwimGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            EntityAnimatedConstruct.this.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            if (!EntityAnimatedConstruct.this.canSwim()) {
                return false;
            }
            return EntityAnimatedConstruct.this.func_70090_H() && EntityAnimatedConstruct.this.func_233571_b_((ITag)FluidTags.field_206959_a) > EntityAnimatedConstruct.this.func_233579_cu_() || EntityAnimatedConstruct.this.func_180799_ab();
        }

        public void func_75246_d() {
            if (EntityAnimatedConstruct.this.func_70681_au().nextFloat() < 0.8f) {
                EntityAnimatedConstruct.this.field_70767_i.func_75660_a();
            }
        }
    }
}

