/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class ConstructPlaceBlock
extends ConstructCommand {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = 20;
    protected BlockPos blockPos;
    protected Direction side;

    public ConstructPlaceBlock(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.blockPos != null && this.side != null;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.construct.getCarryingHands().length == 0) {
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_block_hands_empty", new Object[0]));
            }
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            return;
        }
        if (!this.construct.field_70170_p.isAreaLoaded(this.blockPos, 1) || !this.construct.field_70170_p.func_175623_d(this.blockPos)) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_block_not_clear", new Object[0]));
            this.isFinished = true;
            return;
        }
        this.moveBlockTarget = this.blockPos;
        if (this.doMove(8.0f)) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else if (this.interactTimer == 0) {
                Hand[] carrying = this.construct.getCarryingHands(i -> i.func_77973_b() instanceof BlockItem);
                if (carrying.length == 0) {
                    this.isFinished = true;
                    return;
                }
                boolean placed = false;
                String blockTranslated = "";
                for (int i2 = 0; i2 < carrying.length; ++i2) {
                    ItemStack stack = this.construct.func_184586_b(carrying[i2]);
                    ActionResultType result = ((BlockItem)stack.func_77973_b()).func_195942_a(new BlockItemUseContext(this.getOrCreatePlayer(), carrying[i2], stack, new BlockRayTraceResult(new Vector3d((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p()), this.side, this.blockPos, true)));
                    if (result != ActionResultType.SUCCESS && result != ActionResultType.CONSUME) continue;
                    blockTranslated = this.translate(stack);
                    stack.func_190918_g(1);
                    this.construct.func_184609_a(carrying[i2]);
                    break;
                }
                if (!placed) {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_block_failed", new Object[0]));
                } else {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_block_success", blockTranslated, this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()));
                    this.isSuccess = true;
                }
                this.isFinished = true;
                return;
            }
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.PLACE_BLOCK;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructPlaceBlock) {
            this.side = ((ConstructPlaceBlock)other).side;
            this.blockPos = ((ConstructPlaceBlock)other).blockPos;
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.func_74768_a("direction", this.side.func_176745_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("blockPos")) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("blockPos"));
        }
        if (nbt.func_74764_b("direction")) {
            this.side = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
        }
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.blockPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
            this.side = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(marker);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

