/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.blocks.tileentities.MagiciansWorkbenchTile;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.InventoryUtilities;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ConstructCraft
extends ConstructCommandTileEntityInteract<MagiciansWorkbenchTile> {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[0];
    private int interactTimer = 20;
    private BlockPos interactPos = null;
    private NonNullList<ItemStack> requiredItem = NonNullList.func_191196_a();
    private ItemStack output = ItemStack.field_190927_a;

    public ConstructCraft(EntityAnimatedConstruct construct) {
        super(construct, MagiciansWorkbenchTile.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.interactPos == null || !this.construct.field_70170_p.func_195588_v(this.interactPos)) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_missing", new Object[0]), false);
            return false;
        }
        return true;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.moveBlockTarget = this.interactPos;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                ItemStack output = this.performCraft();
                if (!output.func_190926_b()) {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_success", new Object[0]), true);
                    this.insertOrDropItem(output);
                } else {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.craft_failed", new Object[0]), true);
                }
                this.interactTimer = 20;
                this.construct.func_184609_a(Math.random() < 0.5 ? Hand.MAIN_HAND : Hand.OFF_HAND);
                this.isFinished = true;
            }
        }
    }

    private ItemStack performCraft() {
        MagiciansWorkbenchTile te = (MagiciansWorkbenchTile)this.getTileEntity();
        if (te == null) {
            return ItemStack.field_190927_a;
        }
        InvWrapper invWrapper = new InvWrapper((IInventory)te);
        for (ItemStack stack : this.requiredItem) {
            if (InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandlerModifiable)invWrapper)) continue;
            return ItemStack.field_190927_a;
        }
        for (ItemStack stack : this.requiredItem) {
            InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandlerModifiable)invWrapper);
        }
        return this.output.func_77946_l();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.CRAFT;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(11);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructCraft) {
            this.interactPos = ((ConstructCraft)other).interactPos;
            this.output = ((ConstructCraft)other).output;
            this.requiredItem.clear();
            this.requiredItem.addAll(((ConstructCraft)other).requiredItem);
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.interactPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
        }
        this.requiredItem.clear();
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = config.func_70301_a(i + 1);
            if (ingredient.func_190926_b()) continue;
            this.requiredItem.add((Object)ingredient.func_77946_l());
        }
        this.output = config.func_70301_a(10);
    }

    @Override
    public boolean isFullyConfigured() {
        return this.interactPos != null && !this.output.func_190926_b() && this.requiredItem.size() > 0;
    }
}

