/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.entities.EntityInit;
import com.ma.items.ItemInit;
import com.ma.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityMagicBroom
extends GolemEntity {
    private static final float detection_radius = 16.0f;
    private static final float detection_height = 4.0f;
    private static final float max_distance_from_container = 48.0f;
    private static final float movement_speed = 0.4f;
    public static final int BROOM_TYPE_NORMAL = 0;
    public static final int BROOM_TYPE_VORTEX = 1;
    private static final Predicate<ItemEntity> ITEM_SELECTOR = e -> {
        if (e.getPersistentData().func_74764_b("PreventRemoteMovement")) {
            return false;
        }
        return !e.func_174874_s() && e.func_70089_S();
    };
    private int deposit_counter = 0;
    private boolean depositing = false;
    private static final DataParameter<BlockPos> CONTAINER_POSITION = EntityDataManager.func_187226_a(EntityMagicBroom.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> BROOM_TYPE = EntityDataManager.func_187226_a(EntityMagicBroom.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String KEY_TARGETPOS = "magic_broom_targetPosition";
    private static final String KEY_BROOM_TYPE = "magic_broom_type";
    private float moveCounter = 0.0f;
    private float moveRotation = 0.0f;

    public EntityMagicBroom(EntityType<? extends GolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.field_70138_W = 1.8f;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0);
    }

    private void updateRotations() {
        if (Math.abs(this.func_213322_ci().func_72433_c()) > (double)0.1f) {
            this.moveCounter += 0.3f;
            this.moveRotation = (float)Math.sin(this.moveCounter) - (float)Math.sin(this.moveCounter - 1.0f);
            if ((int)this.moveCounter % 3 == 0 && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187579_bV, SoundCategory.NEUTRAL, 0.25f, 1.0f, false);
            }
        } else {
            this.moveCounter = 1.57f;
            if (this.moveRotation > 0.0f) {
                this.moveRotation -= 0.1f;
                if (this.moveRotation < 0.0f) {
                    this.moveRotation = 0.0f;
                }
            } else if (this.moveRotation < 0.0f) {
                this.moveRotation += 0.1f;
                if (this.moveRotation > 0.0f) {
                    this.moveRotation = 0.0f;
                }
            }
        }
    }

    public float getRotation() {
        return this.moveRotation;
    }

    public EntityMagicBroom(World worldIn) {
        super((EntityType)EntityInit.MAGIC_BROOM.get(), worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new DepositItemsGoal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CONTAINER_POSITION, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BROOM_TYPE, (Object)0);
    }

    public int getBroomType() {
        return (Integer)this.field_70180_af.func_187225_a(BROOM_TYPE);
    }

    public void setBroomType(int type) {
        this.field_70180_af.func_187227_b(BROOM_TYPE, (Object)type);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getBroomType() == 1) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)0.3f, (double)0.05f, 0.5);
            }
            this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(16.0)).forEach(e -> {
                if (e != null && e.func_70089_S() && this.func_70685_l((Entity)e)) {
                    Vector3d tPos = e.func_213303_ch();
                    Vector3d cPos = this.func_213303_ch();
                    Vector3d delta = cPos.func_178788_d(tPos).func_72432_b();
                    e.func_213317_d(delta.func_186678_a((double)0.15f));
                }
            });
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (player.func_225608_bj_() && !this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.func_98053_h(false);
            this.remove(false);
            ItemEntity entity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack(this.getBroomType() == 0 ? (IItemProvider)ItemInit.MAGIC_BROOM.get() : (IItemProvider)ItemInit.VORTEX_BROOM.get()));
            entity.func_174867_a(20);
            this.field_70170_p.func_217376_c((Entity)entity);
            this.func_213345_d(this.func_189748_bU());
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public BlockPos getContainerPosition() {
        return (BlockPos)this.field_70180_af.func_187225_a(CONTAINER_POSITION);
    }

    public void setContainerPosition(BlockPos pos) {
        this.field_70180_af.func_187227_b(CONTAINER_POSITION, (Object)pos);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack curStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (curStack.func_190926_b()) {
            return true;
        }
        return curStack.func_77973_b() == stack.func_77973_b() && curStack.func_190916_E() <= curStack.func_77976_d() - stack.func_190916_E();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateRotations();
        if (this.field_70170_p.field_72995_K && Math.abs(this.func_213322_ci().func_72433_c()) > (double)0.1f) {
            float particle_spread = 0.05f;
            Vector3d velocity = new Vector3d((double)-0.05f + Math.random() * (double)0.1f, (double)0.025f, (double)-0.05f + Math.random() * (double)0.1f);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), this.func_226277_ct_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226278_cu_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), this.func_226281_cx_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
        if (this.func_70089_S()) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0))) {
                if (!itementity.func_70089_S() || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                this.func_175445_a(itementity);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (itemEntity.func_174874_s() || itemEntity.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack mhStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        ItemStack groundStack = itemEntity.func_92059_d();
        if (mhStack.func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, groundStack);
            this.func_71001_a((Entity)itemEntity, mhStack.func_190916_E());
            itemEntity.func_70106_y();
        } else if (groundStack.func_77969_a(mhStack)) {
            int space = mhStack.func_77976_d() - mhStack.func_190916_E();
            int qtyCollected = Math.min(space, groundStack.func_190916_E());
            ItemStack pickupStack = groundStack.func_77979_a(qtyCollected);
            mhStack.func_190920_e(mhStack.func_190916_E() + pickupStack.func_190916_E());
            this.func_184201_a(EquipmentSlotType.MAINHAND, mhStack);
            if (groundStack.func_190916_E() <= 0) {
                itemEntity.func_70106_y();
            } else {
                itemEntity.func_92058_a(groundStack);
            }
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b()) {
            this.func_199701_a_(itemstack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockPos target = this.getContainerPosition();
        CompoundNBT targetPos = new CompoundNBT();
        targetPos.func_74768_a("x", target.func_177958_n());
        targetPos.func_74768_a("y", target.func_177956_o());
        targetPos.func_74768_a("z", target.func_177952_p());
        compound.func_218657_a(KEY_TARGETPOS, (INBT)targetPos);
        compound.func_74768_a(KEY_BROOM_TYPE, ((Integer)this.field_70180_af.func_187225_a(BROOM_TYPE)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(KEY_TARGETPOS)) {
            CompoundNBT targetPos = compound.func_74775_l(KEY_TARGETPOS);
            this.setContainerPosition(new BlockPos(targetPos.func_74762_e("x"), targetPos.func_74762_e("y"), targetPos.func_74762_e("z")));
        }
        if (compound.func_74764_b(KEY_BROOM_TYPE)) {
            this.field_70180_af.func_187227_b(BROOM_TYPE, (Object)compound.func_74762_e(KEY_BROOM_TYPE));
        }
    }

    class DepositItemsGoal
    extends Goal {
        private TileEntity targetTE;
        private boolean abort = false;

        public DepositItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.abort) {
                this.abort = false;
                return false;
            }
            if (EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            return EntityMagicBroom.this.func_233580_cy_().func_218141_a((Vector3i)EntityMagicBroom.this.getContainerPosition(), 48.0);
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityMagicBroom.this.depositing = false;
            EntityMagicBroom.this.deposit_counter = 10;
        }

        public void func_75249_e() {
            BlockPos target = EntityMagicBroom.this.getContainerPosition();
            EntityMagicBroom.this.func_70661_as().func_75492_a((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p(), (double)0.4f);
            this.targetTE = EntityMagicBroom.this.func_130014_f_().func_175625_s(EntityMagicBroom.this.getContainerPosition());
            this.abort = false;
        }

        public void func_75246_d() {
            if (this.targetTE == null) {
                this.abort = true;
                return;
            }
            LazyOptional handler = this.targetTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)EntityMagicBroom.this.field_70170_p));
            if (!handler.isPresent()) {
                this.abort = true;
                return;
            }
            ItemStack activeStack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
            BlockPos target = EntityMagicBroom.this.getContainerPosition();
            double dist = EntityMagicBroom.this.func_70092_e(target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
            if (dist < 4.0) {
                EntityMagicBroom.this.field_70699_by.func_75499_g();
                if (!EntityMagicBroom.this.depositing) {
                    EntityMagicBroom.this.depositing = true;
                    if (this.targetTE instanceof IInventory) {
                        ((IInventory)this.targetTE).func_174889_b((PlayerEntity)player);
                    }
                }
                if (EntityMagicBroom.this.deposit_counter <= 0) {
                    EntityMagicBroom.this.deposit_counter = 10;
                    if (InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), activeStack, 10)) {
                        EntityMagicBroom.this.depositing = false;
                    }
                } else {
                    EntityMagicBroom.this.deposit_counter--;
                }
                if (!EntityMagicBroom.this.depositing && this.targetTE instanceof IInventory) {
                    ((IInventory)this.targetTE).func_174886_c((PlayerEntity)player);
                }
            } else {
                EntityMagicBroom.this.func_70661_as().func_75492_a((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p(), (double)0.4f);
            }
        }
    }

    class FindItemsGoal
    extends Goal {
        private BlockPos originPos;
        private boolean abort = false;
        private ArrayList<Integer> ignoredEntityIDs;
        private int stuck_count;
        private Vector3d last_pos;

        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.ignoredEntityIDs = new ArrayList();
        }

        public boolean func_75250_a() {
            if (EntityMagicBroom.this.depositing) {
                return false;
            }
            if (this.abort) {
                this.abort = false;
                return false;
            }
            List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), e -> {
                if (EntityMagicBroom.this.func_70685_l((Entity)e)) {
                    return ITEM_SELECTOR.test(e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                ItemStack stack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
                if (stack.func_190916_E() == stack.func_77976_d()) {
                    return false;
                }
                if (stack.func_190926_b()) {
                    return true;
                }
                for (ItemEntity item : list) {
                    if (item.func_92059_d().func_77973_b() != EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b()) continue;
                    return true;
                }
            }
            return false;
        }

        public void func_75246_d() {
            if (this.originPos == null || !EntityMagicBroom.this.field_70170_p.func_195588_v(this.originPos)) {
                this.abort = true;
                return;
            }
            this.stuck_count = this.last_pos != null && EntityMagicBroom.this.func_213303_ch().func_72438_d(this.last_pos) < 0.25 ? ++this.stuck_count : 0;
            ItemStack itemstack = EntityMagicBroom.this.func_184582_a(EquipmentSlotType.MAINHAND);
            ItemEntity pickupTarget = null;
            if (itemstack.func_190926_b()) {
                List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.originPos).func_72314_b(16.0, 4.0, 16.0), e -> !this.ignoredEntityIDs.contains(e.func_145782_y()) && ITEM_SELECTOR.test(e));
                if (!list.isEmpty()) {
                    pickupTarget = (ItemEntity)list.get(0);
                }
            } else {
                List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.originPos).func_72314_b(16.0, 4.0, 16.0), item -> !this.ignoredEntityIDs.contains(item.func_145782_y()) && !item.func_174874_s() && item.func_70089_S() && item.func_92059_d().func_77973_b() == itemstack.func_77973_b());
                if (!list.isEmpty() && itemstack.func_190916_E() < itemstack.func_77976_d()) {
                    pickupTarget = (ItemEntity)list.get(0);
                }
            }
            if (!(pickupTarget == null || this.stuck_count != 20 && EntityMagicBroom.this.func_70661_as().func_75497_a((Entity)pickupTarget, (double)0.4f))) {
                this.ignoredEntityIDs.add(pickupTarget.func_145782_y());
                this.stuck_count = 0;
            }
        }

        public void func_75249_e() {
            this.ignoredEntityIDs.clear();
            this.stuck_count = 0;
            this.last_pos = null;
            this.originPos = EntityMagicBroom.this.getContainerPosition();
            this.abort = false;
            List list = EntityMagicBroom.this.field_70170_p.func_175647_a(ItemEntity.class, EntityMagicBroom.this.func_174813_aQ().func_72314_b(16.0, 1.0, 16.0), e -> {
                if (EntityMagicBroom.this.func_70685_l((Entity)e)) {
                    return ITEM_SELECTOR.test(e);
                }
                return false;
            });
            if (!list.isEmpty()) {
                EntityMagicBroom.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)0.4f);
            }
        }
    }
}

