/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.boss;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.collections.Components;
import com.ma.api.spells.collections.Shapes;
import com.ma.effects.EffectInit;
import com.ma.entities.EntityInit;
import com.ma.entities.boss.BossMonster;
import com.ma.entities.boss.EntityBifrost;
import com.ma.entities.boss.attacks.AllfatherAxeThrownEntity;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.items.ItemInit;
import com.ma.particles.types.movers.ParticleOrbitMover;
import com.ma.spells.crafting.SpellRecipe;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class EntityOdin
extends BossMonster<EntityOdin> {
    private final ServerBossInfo bossEvent = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20).func_186741_a(true);
    private static final DataParameter<Byte> DATA_AXE_SLOT = EntityDataManager.func_187226_a(BossMonster.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> ENRAGED = EntityDataManager.func_187226_a(BossMonster.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final EntityPredicate TARGETING_CONDITIONS_SNOWBLIND = new EntityPredicate().func_221013_a(40.0).func_221012_a(LIVING_ENTITY_SELECTOR);
    public static final byte AXE_SLOT_BACK = 0;
    public static final byte AXE_SLOT_HAND = 1;
    public static final byte AXE_SLOT_THROW = 2;
    private static final int ACTION_FROST_SPELL = 2;
    private static final int ACTION_LIGHTNING_SPELL = 4;
    private static final int ACTION_THROW_AXE = 8;
    private static final int ACTION_ENRAGE = 16;
    private static final int ACTION_OFFER = 32;
    private static final int ACTION_LEAVE = 64;
    private static final ItemStack FROST_SPELL = new ItemStack((IItemProvider)ItemInit.SPELL.get());
    private static final ItemStack LIGHTNING_SPELL = new ItemStack((IItemProvider)ItemInit.SPELL.get());

    public EntityOdin(EntityType<? extends MonsterEntity> p_i48553_1_, World p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.field_70138_W = 1.6f;
    }

    public EntityOdin(World world) {
        this((EntityType<? extends MonsterEntity>)((EntityType)EntityInit.ODIN.get()), world);
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, (double)0.6f).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217373_a(TARGETING_CONDITIONS_SNOWBLIND, (LivingEntity)this, this.func_174813_aQ().func_186662_g(40.0)).forEach(p -> p.func_195064_c(new EffectInstance((Effect)EffectInit.SNOWBLIND.get(), 100, 0)));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_AXE_SLOT, (Object)0);
        this.field_70180_af.func_187214_a(ENRAGED, (Object)false);
    }

    public byte getAxeSlot() {
        return (Byte)this.field_70180_af.func_187225_a(DATA_AXE_SLOT);
    }

    public void setAxeSlot(byte slot) {
        this.field_70180_af.func_187227_b(DATA_AXE_SLOT, (Object)slot);
    }

    @Override
    protected ServerBossInfo getBossEvent() {
        return this.bossEvent;
    }

    @Override
    protected <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getInvulnerableTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.summon", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.flagSet(32)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.offerAxe", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.flagSet(64)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.bifrostLeave", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (!this.flagSet(1)) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.idle", Boolean.valueOf(true)));
            }
        } else if (this.flagSet(4) || this.flagSet(8)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.axeThrow", Boolean.valueOf(false)));
        } else if (this.flagSet(2)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.spellCast", Boolean.valueOf(false)));
        } else if (this.flagSet(16)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.axeImbue", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.odin.axeHit", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(110);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getInvulnerableTicks() > 0) {
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 <= 0) {
                this.func_70691_i(this.func_110138_aP());
            }
            this.setInvulnerableTicks(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(50.0f);
            }
            if (j1 == 11) {
                this.setAxeSlot((byte)1);
            }
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.flagSet(1) || this.isOnCooldown(1) || (Byte)this.field_70180_af.func_187225_a(DATA_AXE_SLOT) == 2) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>("", 14, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 18, "", this::handleDelayCallback));
        this.updateState(1);
        return true;
    }

    @Override
    protected void spawnParticles() {
        if (this.flagSet(16)) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 0.1f, -0.01f, 1.0)), this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource type, float amount) {
        if (this.flagSet(32)) {
            return false;
        }
        if (this.flagSet(64)) {
            return false;
        }
        return super.func_70097_a(type, amount);
    }

    public void func_70645_a(DamageSource type) {
        this.func_70606_j(1.0f);
        this.func_70691_i(300.0f);
        if (type.func_76346_g() instanceof PlayerEntity) {
            this.setOfferingAxe();
        } else {
            this.setLeaving();
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vector, Hand hand) {
        if (this.flagSet(32)) {
            this.giveAxe(player);
            this.setLeaving();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean damageEntity(Entity entityIn) {
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        boolean flag = entityIn.func_70097_a((Boolean)this.field_70180_af.func_187225_a(ENRAGED) != false ? DamageTypes.causeSourcedFrostDamage((LivingEntity)this) : DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity;
                this.maybeDisableShield(playerentity, (playerentity = (PlayerEntity)entityIn).func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_130011_c(entityIn);
            if (this.field_70146_Z.nextFloat() < 0.4f && entityIn instanceof MobEntity) {
                ((MobEntity)entityIn).func_70624_b((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(PlayerEntity player, ItemStack playerItem) {
        if (!playerItem.func_190926_b() && playerItem.func_77973_b().isShield(playerItem, (LivingEntity)player)) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                player.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    public void hideAxe() {
        this.field_70180_af.func_187227_b(DATA_AXE_SLOT, (Object)2);
    }

    public void showAxe() {
        this.field_70180_af.func_187227_b(DATA_AXE_SLOT, (Object)1);
    }

    private void setOfferingAxe() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.clearState();
        this.updateState(32);
        this.hideBossBar();
        if (!this.field_70170_p.field_72995_K) {
            this.threat.forEach((entityID, threat) -> {
                Entity e = this.field_70170_p.func_73045_a(entityID.intValue());
                if (e instanceof PlayerEntity) {
                    ((PlayerEntity)e).func_145747_a((ITextComponent)new TranslationTextComponent("entity.mana-and-artifice.odin.defeated"), Util.field_240973_b_);
                }
            });
        }
    }

    public void func_70624_b(LivingEntity target) {
        this.threat.initializeThreat(target);
        super.func_70624_b(target);
    }

    private void setLeaving() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.clearState();
        this.updateState(64);
        this.setAxeSlot((byte)2);
        EntityBifrost bifrost = new EntityBifrost(this.field_70170_p, this.func_213303_ch().func_72441_c(0.0, 10.0, 0.0));
        bifrost.setNoSummon();
        this.field_70170_p.func_217376_c((Entity)bifrost);
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("leave", 130, "leave", this::handleDelayCallback));
    }

    private void giveAxe(PlayerEntity player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack reward = new ItemStack((IItemProvider)ItemInit.ALLFATHER_AXE.get());
        if (!player.func_191521_c(reward)) {
            player.func_146097_a(reward, false, false);
        }
    }

    private void handleDelayCallback(String id, Entity e) {
        if (this.flagSet(1)) {
            if (this.flagSet(16)) {
                this.field_70180_af.func_187227_b(ENRAGED, (Object)true);
                this.func_184185_a(SFX.Entity.Odin.ENRAGE, 1.0f, 1.0f);
            } else {
                this.damageEntity(e);
                this.func_184185_a(SFX.Entity.Odin.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
            }
        }
    }

    private void handleDelayCallback(String id, String command) {
        if (command == "leave") {
            this.func_70106_y();
            return;
        }
        if (this.flagSet(16)) {
            this.clearState(16);
        }
        if (this.flagSet(8)) {
            this.clearState(8);
        }
        this.clearState(1);
        this.setCooldown(1, (Boolean)this.field_70180_af.func_187225_a(ENRAGED) != false ? 10 : 20);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("axe_slot")) {
            this.setAxeSlot(nbt.func_74771_c("axe_slot"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a("axe_slot", this.getAxeSlot());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BossMonster.DoNothingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new BossMonster.DoNothingGoal(32));
        this.field_70714_bg.func_75776_a(0, (Goal)new BossMonster.DoNothingGoal(64));
        this.field_70714_bg.func_75776_a(1, (Goal)new Enrage());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BossMonster.CastSpellAtTargetGoal(FROST_SPELL, 0.35f, 200, 16.0f, 4.0f, true, 2, 12, 20, this::handleDelayCallback));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrowAxeAtTargetGoal(0.35f, 200, 6.0f, 2.0f, true, 16, 4, this::handleDelayCallback));
        this.field_70714_bg.func_75776_a(3, (Goal)new BossMonster.CastSpellAtTargetGoal(LIGHTNING_SPELL, 0.35f, 200, 16.0f, 4.0f, true, 4, 12, 20, this::handleDelayCallback).setUsePredicate(b -> (Byte)this.field_70180_af.func_187225_a(DATA_AXE_SLOT) != 1));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, (double)0.35f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, le -> true));
    }

    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SFX.Entity.Odin.HIT;
    }

    @Override
    protected void playSoundForAnim(String sound) {
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Entity.Odin.DRAW, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
    }

    static {
        SpellRecipe frost = new SpellRecipe();
        frost.setShape(Shapes.PROJECTILE).addComponent(Components.FROST_DAMAGE).addComponent(Components.SLOW);
        frost.changeShapeAttributeValue(com.ma.api.spells.attributes.Attribute.SPEED, 1.75f);
        frost.changeComponentAttributeValue(0, com.ma.api.spells.attributes.Attribute.DAMAGE, 15.0f);
        frost.changeComponentAttributeValue(0, com.ma.api.spells.attributes.Attribute.DURATION, 7.0f);
        frost.changeComponentAttributeValue(1, com.ma.api.spells.attributes.Attribute.MAGNITUDE, 2.0f);
        frost.writeToNBT(FROST_SPELL.func_196082_o());
        SpellRecipe lightning = new SpellRecipe();
        lightning.setShape(Shapes.PROJECTILE).addComponent(Components.LIGHTNING_DAMAGE).addComponent(Components.GRAVITY_WELL);
        lightning.changeShapeAttributeValue(com.ma.api.spells.attributes.Attribute.SPEED, 1.75f);
        lightning.changeComponentAttributeValue(0, com.ma.api.spells.attributes.Attribute.DAMAGE, 15.0f);
        lightning.changeComponentAttributeValue(1, com.ma.api.spells.attributes.Attribute.DURATION, 10.0f);
        lightning.writeToNBT(LIGHTNING_SPELL.func_196082_o());
    }

    public class ThrowAxeAtTargetGoal
    extends Goal {
        private final double moveSpeedAmp;
        private final float maxAttackDistance;
        private final float minAttackDistance;
        private final int attackCooldown;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private final boolean randomThreatTarget;
        private LivingEntity target;
        private boolean isWaitingOnAnim = false;
        private final int effectDelayTicks;
        private final int resetTicks;
        private final BiConsumer<String, String> callbackFunction;

        public ThrowAxeAtTargetGoal(double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn, float minAttackDistanceIn, boolean randomTargetFromThreatTable, int delayTicks, int resetTicks, BiConsumer<String, String> resetCallback) {
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.minAttackDistance = minAttackDistanceIn * minAttackDistanceIn;
            this.attackCooldown = attackCooldownIn;
            this.effectDelayTicks = delayTicks;
            this.resetTicks = resetTicks;
            this.callbackFunction = resetCallback;
            this.randomThreatTarget = randomTargetFromThreatTable;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityOdin.this.func_70638_az() != null && !EntityOdin.this.isOnCooldown(8) && !EntityOdin.this.isOnCooldown(1) && EntityOdin.this.func_70638_az().func_70068_e((Entity)EntityOdin.this) >= (double)this.minAttackDistance && (Byte)EntityOdin.this.field_70180_af.func_187225_a(DATA_AXE_SLOT) != 2;
        }

        public boolean func_75253_b() {
            if (this.target == null || this.target.func_233643_dh_() || this.target.func_213303_ch().func_72436_e(EntityOdin.this.func_213303_ch()) > EntityOdin.this.func_233637_b_(Attributes.field_233819_b_)) {
                return false;
            }
            if (!EntityOdin.this.isOnCooldown(8)) {
                return false;
            }
            if (this.isWaitingOnAnim) {
                return true;
            }
            return this.func_75250_a() || !EntityOdin.this.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.target = this.randomThreatTarget ? EntityOdin.this.getRandomThreatTableTarget(EntityOdin.this.func_233637_b_(Attributes.field_233819_b_)) : EntityOdin.this.func_70638_az();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityOdin.this.setCooldown(8, this.attackCooldown);
            this.target = null;
            this.seeTime = 0;
            this.isWaitingOnAnim = false;
        }

        private void throwCallback(String identifier, LivingEntity target) {
            Vector3d origin = EntityOdin.this.func_213303_ch().func_72441_c(0.0, (double)EntityOdin.this.func_70047_e(), 0.0);
            Vector3d targetPos = target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0);
            Vector3d targetVelocity = target.func_213303_ch().func_178786_a(target.field_70142_S, target.field_70137_T, target.field_70136_U);
            targetVelocity = targetVelocity.func_178786_a(0.0, target.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111126_e(), 0.0);
            if (target.func_233570_aj_()) {
                targetVelocity = targetVelocity.func_72441_c(0.0, -targetVelocity.field_72448_b, 0.0);
            }
            double distance = origin.func_72438_d(targetPos);
            double speed = 1.0;
            int ticksToArrive = (int)Math.round(distance / speed);
            Vector3d adjustedTargetPos = targetPos.func_178787_e(targetVelocity.func_186678_a((double)ticksToArrive));
            Vector3d delta = adjustedTargetPos.func_178788_d(origin).func_72432_b();
            EntityOdin.this.hideAxe();
            AllfatherAxeThrownEntity thrown = new AllfatherAxeThrownEntity((LivingEntity)EntityOdin.this, EntityOdin.this.field_70170_p, null);
            thrown.func_70186_c(delta.field_72450_a, delta.field_72448_b, delta.field_72449_c, 1.0f, 0.0f);
            EntityOdin.this.field_70170_p.func_217376_c((Entity)thrown);
            this.func_75251_c();
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.func_75251_c();
                return;
            }
            if (this.isWaitingOnAnim) {
                return;
            }
            LivingEntity livingentity = EntityOdin.this.func_70638_az();
            if (livingentity != null) {
                boolean positiveSeeTime;
                double d0 = EntityOdin.this.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
                boolean canSee = EntityOdin.this.func_70635_at().func_75522_a((Entity)livingentity);
                boolean bl = positiveSeeTime = this.seeTime > 0;
                if (canSee != positiveSeeTime) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    EntityOdin.this.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    EntityOdin.this.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)EntityOdin.this.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)EntityOdin.this.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    EntityOdin.this.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    EntityOdin.this.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    EntityOdin.this.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!canSee && this.seeTime < -60) {
                    this.func_75251_c();
                } else if (canSee) {
                    DelayedEventQueue.pushEvent(EntityOdin.this.field_70170_p, new TimedDelayedEvent<LivingEntity>("throw", this.effectDelayTicks, livingentity, this::throwCallback));
                    DelayedEventQueue.pushEvent(EntityOdin.this.field_70170_p, new TimedDelayedEvent<String>("resetAttack", this.resetTicks, "", this.callbackFunction));
                    EntityOdin.this.updateState(1, 8);
                    this.isWaitingOnAnim = true;
                }
            }
        }
    }

    class Enrage
    extends Goal {
        public Enrage() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityOdin.this.field_70173_aa > 3600 && !EntityOdin.this.flagSet(1) && (Boolean)EntityOdin.this.field_70180_af.func_187225_a(ENRAGED) == false;
        }

        public void func_75249_e() {
            DelayedEventQueue.pushEvent(EntityOdin.this.field_70170_p, new TimedDelayedEvent<LivingEntity>("cast", 100, (LivingEntity)EntityOdin.this, (x$0, x$1) -> EntityOdin.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntityOdin.this.field_70170_p, new TimedDelayedEvent<String>("resetAttack", 100, "", (x$0, x$1) -> EntityOdin.this.handleDelayCallback(x$0, x$1)));
            EntityOdin.this.updateState(1, 16);
        }

        public boolean func_75253_b() {
            return EntityOdin.this.flagSet(1);
        }
    }
}

