/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.boss;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.boss.EntityOdin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBifrost
extends Entity {
    private static final Vector3d DOWN = new Vector3d(0.0, -1.0, 0.0);
    private boolean summon = true;

    public EntityBifrost(EntityType<? extends EntityBifrost> type, World world) {
        super((EntityType)EntityInit.BIFROST.get(), world);
        this.func_189654_d(true);
        this.func_230245_c_(false);
    }

    public EntityBifrost(World worldIn, Vector3d position) {
        this((EntityType<? extends EntityBifrost>)((EntityType)EntityInit.BIFROST.get()), worldIn);
        this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
    }

    public void spawnParticles(int particleCount, float partialTick) {
        for (int i = 0; i < particleCount; ++i) {
            Vector3d pos = this.summon ? this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)partialTick * Math.random())) : this.func_213303_ch().func_178787_e(DOWN.func_186678_a((double)(-1.0f * partialTick) * Math.random()));
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setColor((float)Math.random() * 255.0f, (float)Math.random() * 255.0f, (float)Math.random() * 255.0f).setScale(0.08f).setMaxAge(50), pos.field_72450_a, this.summon ? pos.field_72448_b : pos.field_72448_b - 10.0, pos.field_72449_c, (double)0.6f * Math.random() + (double)0.1f, (double)-0.2f, 0.5);
            if (this.field_70173_aa <= 50) continue;
            Vector3d vel = new Vector3d(Math.random() - 0.5, 0.0, Math.random() - 0.5);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setColor((float)Math.random() * 255.0f, (float)Math.random() * 255.0f, (float)Math.random() * 255.0f).setScale(0.1f), pos.field_72450_a + vel.field_72450_a, pos.field_72448_b - 10.0 + Math.random(), pos.field_72449_c + vel.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa == 2 && !this.field_70170_p.field_72995_K) {
            this.func_184185_a(SFX.Entity.Odin.BIFROST, 1.0f, 1.0f);
        }
        if (this.field_70173_aa > 100) {
            if (this.summon && !this.field_70170_p.field_72995_K) {
                EntityOdin odin = new EntityOdin(this.field_70170_p);
                odin.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 10.0, this.func_226281_cx_());
                odin.setupSpawn();
                this.field_70170_p.func_217376_c((Entity)odin);
            }
            this.remove(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBifrost.func_184183_bd()) * d0;
    }

    public void spawnParticleBurst(String identifier, Float radius) {
        MAParticleType particle = (MAParticleType)ParticleInit.AIR_VELOCITY.get();
        int count = 100;
        double angleRads = 0.0;
        double step = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            Vector3d dir = new Vector3d(Math.cos(angleRads += step), Math.random() * 0.1, Math.sin(angleRads)).func_72432_b();
            Vector3d vel = dir.func_186678_a((double)(0.3f * radius.floatValue()));
            dir = dir.func_186678_a(0.2);
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType(particle).setColor((float)Math.random(), (float)Math.random(), (float)Math.random()), this.func_226277_ct_() + dir.field_72450_a, this.func_226278_cu_() + 1.0 + Math.random(), this.func_226281_cx_() + dir.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("summon")) {
            this.summon = nbt.func_74767_n("summon");
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74757_a("summon", this.summon);
    }

    public void setNoSummon() {
        this.summon = false;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(15.0);
    }
}

