/*
 * Decompiled with CFR 0.152.
 */
package com.ma.commands;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.WellspringNode;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.commands.AffinityArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CommandCreateWellspring {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"makewellspring").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> CommandCreateWellspring.makeWellspring((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"position"))))).then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"affinity", (ArgumentType)new AffinityArgument()).executes(context -> CommandCreateWellspring.makeWellspring((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"position"), AffinityArgument.getAffinity(context, "affinity")))))).then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"affinity", (ArgumentType)new AffinityArgument()).then(Commands.func_197056_a((String)"strength", (ArgumentType)FloatArgumentType.floatArg((float)5.0f, (float)25.0f)).executes(context -> CommandCreateWellspring.makeWellspring((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"position"), AffinityArgument.getAffinity(context, "affinity"), FloatArgumentType.getFloat((CommandContext)context, (String)"strength")))))));
    }

    private static int makeWellspring(CommandSource source, BlockPos position) {
        return CommandCreateWellspring.makeWellspring(source, position, Affinity.values()[(int)(Math.random() * (double)Affinity.values().length)], (float)(5.0 + Math.random() * 20.0));
    }

    private static int makeWellspring(CommandSource source, BlockPos position, Affinity aff) {
        return CommandCreateWellspring.makeWellspring(source, position, aff, (float)(5.0 + Math.random() * 20.0));
    }

    private static int makeWellspring(CommandSource source, BlockPos position, Affinity aff, float strength) {
        MutableBoolean success = new MutableBoolean(true);
        source.func_197023_e().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            Optional<WellspringNode> existing = m.getWellspringRegistry().getNodeAt(position);
            if (existing.isPresent()) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.wellspring.nodeoverlap"));
                success.setFalse();
                return;
            }
            if (!m.getWellspringRegistry().addNode(position, new WellspringNode(aff, strength), true)) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.wellspring.failed", new Object[]{position.func_229422_x_()}));
                success.setFalse();
                return;
            }
        });
        if (success.booleanValue()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.wellspring.success", new Object[]{aff.name(), position.toString()}), true);
        }
        return 0;
    }
}

