/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.rote;

import com.ma.Registries;
import com.ma.api.capabilities.IPlayerRoteSpells;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.tools.math.MathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class PlayerRoteSpells
implements IPlayerRoteSpells {
    private HashMap<ISpellComponent, Integer> _roteParts = new HashMap();
    private boolean isDirty = true;

    @Override
    public boolean isRote(ISpellComponent part) {
        if (!this._roteParts.containsKey(part)) {
            return false;
        }
        return this._roteParts.get(part) >= part.requiredXPForRote();
    }

    @Override
    public boolean addRoteXP(ISpellComponent part) {
        return this.addRoteXP(part, 1);
    }

    @Override
    public boolean addRoteXP(ISpellComponent part, int xp) {
        if (this.isRote(part) || part == null) {
            return false;
        }
        if (!this._roteParts.containsKey(part)) {
            this._roteParts.put(part, xp);
        } else {
            this._roteParts.put(part, Math.max(this._roteParts.get(part) + xp, 0));
        }
        this.setDirty();
        return this.isRote(part);
    }

    @Override
    public void setRoteXP(ResourceLocation rLoc, int xp) {
        ISpellComponent comp = this.lookupSpellComponent(rLoc);
        if (comp != null) {
            this._roteParts.put(comp, xp);
        }
    }

    private ISpellComponent lookupSpellComponent(ResourceLocation rLoc) {
        if (rLoc == null) {
            return null;
        }
        if (Registries.Shape.containsKey(rLoc)) {
            return (ISpellComponent)Registries.Shape.getValue(rLoc);
        }
        if (Registries.Component.containsKey(rLoc)) {
            return (ISpellComponent)Registries.Component.getValue(rLoc);
        }
        if (Registries.Modifier.containsKey(rLoc)) {
            return (ISpellComponent)Registries.Modifier.getValue(rLoc);
        }
        return null;
    }

    @Override
    public List<Shape> getRoteShapes() {
        return this._roteParts.entrySet().stream().filter(e -> e.getKey() instanceof Shape && (Integer)e.getValue() >= ((ISpellComponent)e.getKey()).requiredXPForRote()).map(e -> (Shape)e.getKey()).collect(Collectors.toList());
    }

    @Override
    public List<Component> getRoteComponents() {
        return this._roteParts.entrySet().stream().filter(e -> e.getKey() instanceof Component && (Integer)e.getValue() >= ((ISpellComponent)e.getKey()).requiredXPForRote()).map(e -> (Component)e.getKey()).collect(Collectors.toList());
    }

    @Override
    public List<Modifier> getRoteModifiers() {
        return this._roteParts.entrySet().stream().filter(e -> e.getKey() instanceof Modifier && (Integer)e.getValue() >= ((ISpellComponent)e.getKey()).requiredXPForRote()).map(e -> (Modifier)e.getKey()).collect(Collectors.toList());
    }

    @Override
    public HashMap<ISpellComponent, Integer> getRoteData() {
        return this._roteParts;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public void copyFrom(IPlayerRoteSpells other) {
        this._roteParts = new HashMap();
        for (Map.Entry<ISpellComponent, Integer> p : other.getRoteData().entrySet()) {
            this._roteParts.put(p.getKey(), p.getValue());
        }
        this.setDirty();
    }

    @Override
    public float getRoteProgression(ISpellComponent spellPart) {
        if (!this._roteParts.containsKey(spellPart)) {
            return 0.0f;
        }
        return MathUtils.clamp01((float)this._roteParts.get(spellPart).intValue() / (float)spellPart.requiredXPForRote());
    }
}

