/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic.resources;

import com.ma.api.capabilities.resource.ICastingResourceGuiProvider;
import com.ma.api.capabilities.resource.ICastingResourceGuiRegistry;
import com.ma.capabilities.playerdata.magic.resources.CastingResourceRegistry;
import com.ma.capabilities.playerdata.magic.resources.Mana;
import com.ma.capabilities.playerdata.magic.resources.Souls;
import com.ma.gui.GuiTextures;
import java.security.InvalidParameterException;
import java.util.HashMap;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CastingResourceGuiRegistry
implements ICastingResourceGuiRegistry {
    private HashMap<ResourceLocation, ICastingResourceGuiProvider> _guiProviders = new HashMap();
    public static final CastingResourceGuiRegistry Instance = new CastingResourceGuiRegistry();

    public void registerDefaults() {
        Instance.registerResourceGui(Mana.IDENTIFIER, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getBadge() {
                return GuiTextures.MANA_BADGE;
            }

            @Override
            public int getXPBarColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)0, (int)255);
            }

            @Override
            public int getLevelColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)100, (int)0, (int)100);
            }

            @Override
            public int getBarColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)110, (int)17, (int)191);
            }

            @Override
            public int getBarSecondaryColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)128, (int)66, (int)135, (int)245);
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getBorderColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)190, (int)190, (int)190);
            }
        });
        Instance.registerResourceGui(Souls.IDENTIFIER, new ICastingResourceGuiProvider(){

            @Override
            public ResourceLocation getBadge() {
                return GuiTextures.SOULS_BADGE;
            }

            @Override
            public int getXPBarColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)100, (int)0, (int)100);
            }

            @Override
            public int getLevelColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)200, (int)50, (int)50);
            }

            @Override
            public int getBarColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)0, (int)0);
            }

            @Override
            public int getBarSecondaryColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)128, (int)0, (int)200, (int)0);
            }

            @Override
            public int getBadgeSize() {
                return 64;
            }

            @Override
            public int getBorderColor() {
                return ColorHelper.PackedColor.func_233006_a_((int)255, (int)190, (int)190, (int)190);
            }
        });
    }

    @Override
    public void registerResourceGui(ResourceLocation identifier, ICastingResourceGuiProvider guiProvider) {
        if (identifier == null) {
            return;
        }
        if (this._guiProviders.containsKey(identifier)) {
            throw new InvalidParameterException("The Casting Resource Identifier " + identifier.toString() + " is already in use.");
        }
        if (CastingResourceRegistry.Instance.getRegisteredClass(identifier) == null) {
            throw new InvalidParameterException("The Casting Resource Identifier " + identifier.toString() + " was not registered in the CastingResourceRegistrationEvent event.  Subscribe to this and map the resource to a class.");
        }
        this._guiProviders.put(identifier, guiProvider);
    }

    public ICastingResourceGuiProvider getGuiProvider(ResourceLocation key) {
        return this._guiProviders.getOrDefault(key, this._guiProviders.get(Mana.IDENTIFIER));
    }
}

