/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerCantrips;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.capabilities.resource.ICastingResource;
import com.ma.api.capabilities.resource.SyncStatus;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.ChronoAnchorData;
import com.ma.capabilities.playerdata.magic.PlayerCantrips;
import com.ma.capabilities.playerdata.magic.resources.CastingResourceRegistry;
import com.ma.capabilities.playerdata.magic.resources.Mana;
import com.ma.effects.EffectInit;
import com.ma.events.EventDispatcher;
import com.ma.inventory.SpellInventory;
import com.ma.items.ItemInit;
import com.ma.items.artifice.SpellModifierRing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerMagic
implements IPlayerMagic {
    private static final float EXHAUSTION_PER_TICK = 3.3333333E-4f;
    private static int MAGIC_LEVELS_PER_MILESTONE = 15;
    private static final int SYNC_INTERVAL = 10;
    private ICastingResource castingResource = new Mana();
    private int tick_count = 10;
    private int teleport_salt;
    private int portal_cooldown = 0;
    private int magicLevel = 0;
    private int magicXP = 0;
    private int air_casts = 0;
    private int air_jumps = 0;
    private HashMap<Integer, Float> armor_repair_accumulation;
    private ArrayList<Vector3f> rememberedPoints = new ArrayList();
    private ArrayList<Vector3f> rememberedLooks = new ArrayList();
    private HashMap<Affinity, Float> affinityDepths;
    private Inventory riftInventory;
    private SpellInventory grimoireInventory;
    private SpellInventory roteInventory;
    private ChronoAnchorData chronoData = new ChronoAnchorData();
    private PlayerCantrips cantripData;
    private Vector3d liftPosition;
    private boolean syncGrimoire = true;
    private boolean syncRote = true;
    private boolean didAllowFlight = false;
    private boolean needsChronoExhaustion = false;
    private boolean hadWizardSight = false;
    private boolean modifierPressed = false;

    public PlayerMagic() {
        this.affinityDepths = new HashMap();
        for (Affinity aff : Affinity.values()) {
            this.affinityDepths.put(aff, Float.valueOf(0.0f));
        }
        this.armor_repair_accumulation = new HashMap();
        this.riftInventory = new Inventory(54);
        this.grimoireInventory = new SpellInventory(16);
        this.cantripData = new PlayerCantrips();
        this.roteInventory = new SpellInventory(16);
        for (int i = 0; i < this.roteInventory.func_70302_i_(); ++i) {
            this.roteInventory.func_70299_a(i, new ItemStack((IItemProvider)ItemInit.SPELL.get()));
        }
    }

    @Override
    public boolean isMagicUnlocked() {
        return this.getMagicLevel() > 0;
    }

    @Override
    public void unlockMagic() {
        if (this.getMagicLevel() == 0) {
            this.setMagicLevel(1);
        }
    }

    @Override
    public void copyFrom(IPlayerMagic other) {
        int i;
        this.setCastingResourceType(other.getCastingResource().getRegistryName());
        this.getCastingResource().copyFrom(other.getCastingResource());
        this.setTeleportSalt(other.getTeleportSalt());
        this.setMagicXP(other.getMagicXP());
        this.setMagicLevel(other.getMagicLevel());
        this.setPortalCooldown(0);
        this.setAirCasts(0);
        for (i = 0; i < other.getGrimoireInventory().func_70302_i_(); ++i) {
            this.grimoireInventory.func_70299_a(i, other.getGrimoireInventory().func_70301_a(i));
        }
        for (i = 0; i < other.getRiftInventory().func_70302_i_(); ++i) {
            this.riftInventory.func_70299_a(i, other.getRiftInventory().func_70301_a(i));
        }
        for (i = 0; i < other.getRoteInventory().func_70302_i_(); ++i) {
            this.roteInventory.func_70299_a(i, other.getRoteInventory().func_70301_a(i));
        }
        for (Affinity aff : Affinity.values()) {
            this.setAffinityDepth(aff, other.getAffinityDepth(aff));
        }
        this.cantripData = new PlayerCantrips();
        this.cantripData.readFromNBT(((PlayerCantrips)other.getCantripData()).writeToNBT(false));
        this.forceSync();
    }

    @Override
    public void tick(PlayerEntity attachedPlayer) {
        if (this.needsChronoExhaustion) {
            try {
                attachedPlayer.func_195064_c(new EffectInstance((Effect)EffectInit.CHRONO_EXHAUSTION.get(), 6000));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to apply chrono exhaustion to " + attachedPlayer != null ? attachedPlayer.func_200200_C_().getString() : "unknown player");
                ManaAndArtifice.LOGGER.catching((Throwable)ex);
            }
            finally {
                this.needsChronoExhaustion = false;
            }
        }
        if (this.portal_cooldown > 0) {
            --this.portal_cooldown;
        }
        if (attachedPlayer.func_233570_aj_()) {
            this.setAirCasts(0);
            this.setAirJumps(0);
        }
        if (this.getCastingResource().getAmount() == this.getCastingResource().getMaxAmount()) {
            return;
        }
        if (attachedPlayer.func_184812_l_()) {
            this.getCastingResource().setAmount(this.getCastingResource().getMaxAmount());
        } else if (this.canRegenerate()) {
            attachedPlayer.func_71024_bL().func_75113_a(3.3333333E-4f);
            float regen_pct_per_tick = 1.0f / (float)this.getCastingResource().getRegenerationRate();
            float restored_mana = this.getCastingResource().getMaxAmount() * regen_pct_per_tick;
            if (this.getCastingResource().hungerAffectsRegenRate() && attachedPlayer.func_71024_bL().func_75115_e() > 0.0f) {
                this.getCastingResource().restore(restored_mana * 3.0f);
            } else {
                this.getCastingResource().restore(restored_mana);
            }
        }
        ++this.tick_count;
        if (this.getCastingResource().getAmount() == this.getCastingResource().getMaxAmount()) {
            this.forceSync();
        }
    }

    @Override
    public boolean needsSync() {
        return this.tick_count >= 10 || this.getCastingResource().getSyncStatus() == SyncStatus.IMMEDIATE;
    }

    @Override
    public boolean shouldSyncGrimoire() {
        return this.syncGrimoire;
    }

    @Override
    public void setSyncGrimoire() {
        this.syncGrimoire = true;
    }

    @Override
    public void setSyncRote() {
        this.syncRote = true;
    }

    @Override
    public boolean shouldSyncRote() {
        return this.syncRote;
    }

    @Override
    public void clearSyncFlags() {
        this.tick_count = 0;
        this.syncGrimoire = false;
        this.syncRote = false;
        this.getCastingResource().clearSyncStatus();
        this.getCantripData().clearSync();
    }

    @Override
    public int getTeleportSalt() {
        return this.teleport_salt;
    }

    @Override
    public void resetTeleportSalt() {
        this.teleport_salt = (int)(Math.random() * 2.147483647E9);
    }

    @Override
    public void setTeleportSalt(int salt) {
        this.teleport_salt = salt;
    }

    @Override
    public void clearRememberedPoints() {
        this.rememberedPoints.clear();
        this.rememberedLooks.clear();
    }

    @Override
    public void addRememberedPoint(Vector3f point, Vector3f look) {
        this.rememberedPoints.add(point);
        this.rememberedLooks.add(look);
    }

    @Override
    public Vector3f[] getRememberedPoints() {
        Vector3f[] points = new Vector3f[this.rememberedPoints.size()];
        return this.rememberedPoints.toArray(points);
    }

    @Override
    public int getPortalCooldown() {
        return this.portal_cooldown;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.portal_cooldown = cooldown;
    }

    @Override
    public Vector3f getAverageLook() {
        if (this.rememberedLooks.size() == 0) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        float aX = 0.0f;
        float aY = 0.0f;
        float aZ = 0.0f;
        for (int i = 0; i < this.rememberedLooks.size(); ++i) {
            aX += this.rememberedLooks.get(i).func_195899_a();
            aY += this.rememberedLooks.get(i).func_195900_b();
            aZ += this.rememberedLooks.get(i).func_195902_c();
        }
        return new Vector3f(aX /= (float)this.rememberedLooks.size(), aY /= (float)this.rememberedLooks.size(), aZ /= (float)this.rememberedLooks.size());
    }

    @Override
    public Vector3f[] getRememberedLooks() {
        Vector3f[] points = new Vector3f[this.rememberedLooks.size()];
        return this.rememberedLooks.toArray(points);
    }

    @Override
    public Inventory getRiftInventory() {
        return this.riftInventory;
    }

    @Override
    public SpellInventory getGrimoireInventory() {
        return this.grimoireInventory;
    }

    @Override
    public int getMagicLevel() {
        return this.magicLevel;
    }

    @Override
    public void setMagicLevel(int level) {
        this.magicLevel = level;
        this.getCastingResource().setMaxAmountByLevel(level);
        this.forceSync();
    }

    private boolean canAdvanceToNextMagicLevel(IPlayerProgression progression) {
        return this.magicLevel < progression.getTier() * MAGIC_LEVELS_PER_MILESTONE;
    }

    @Override
    public int getXPForLevel(int level) {
        int baseline = 150;
        int amountPerLevel = (int)Math.pow(level - 1, 2.1f);
        return baseline + amountPerLevel;
    }

    private int getXPForNextLevel() {
        return this.getXPForLevel(this.magicLevel + 1);
    }

    @Override
    public int getMagicXP() {
        return this.magicXP;
    }

    @Override
    public void setMagicXP(int amount) {
        this.magicXP = amount;
    }

    @Override
    public void addMagicXP(int amount, PlayerEntity player, IPlayerProgression progression) {
        if (!this.canAdvanceToNextMagicLevel(progression)) {
            return;
        }
        this.magicXP += Math.max(amount, 1);
        if (this.magicXP > this.getXPForNextLevel()) {
            this.magicLevelUp(player, progression);
        }
    }

    @Override
    public float getAffinityDepth(Affinity affinity) {
        return this.affinityDepths.get((Object)affinity).floatValue();
    }

    @Override
    public void setAffinityDepth(Affinity affinity, float depth) {
        this.affinityDepths.put(affinity, Float.valueOf(depth));
        this.sortAffinities();
    }

    @Override
    public void shiftAffinity(Affinity affinity, float amount) {
        if (affinity == Affinity.UNKNOWN) {
            return;
        }
        affinity = affinity.getShiftAffinity();
        float halfshift = amount / 2.0f;
        for (Affinity aff : Affinity.values()) {
            if (aff == affinity) {
                this.affinityDepths.put(aff, Float.valueOf(Math.min(this.affinityDepths.get((Object)aff).floatValue() + amount, 100.0f)));
                continue;
            }
            this.affinityDepths.put(aff, Float.valueOf(Math.max(this.affinityDepths.get((Object)aff).floatValue() - halfshift, 0.0f)));
        }
        this.sortAffinities();
    }

    @Override
    public void magicLevelUp(PlayerEntity player, IPlayerProgression progression) {
        if (!this.canAdvanceToNextMagicLevel(progression)) {
            return;
        }
        if (!EventDispatcher.DispatchPlayerLevelUp(player, this.magicLevel + 1)) {
            return;
        }
        ++this.magicLevel;
        this.getCastingResource().setMaxAmountByLevel(this.magicLevel);
        this.getCastingResource().setAmount(this.getCastingResource().getMaxAmount());
        this.magicXP = 0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SFX.Event.Player.MAGIC_LEVEL_UP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        this.forceSync();
    }

    @Override
    public int getAirCasts() {
        return this.air_casts;
    }

    @Override
    public int getAirCastLimit(PlayerEntity player) {
        int base = 2;
        if (player != null && ((SpellModifierRing)ItemInit.AIR_CAST_RING.get()).isEquippedAndHasMana((LivingEntity)player, 1.0f, false)) {
            ++base;
        }
        return base;
    }

    @Override
    public void setAirCasts(int casts) {
        this.air_casts = casts;
    }

    @Override
    public void incrementAirCasts(PlayerEntity player) {
        Optional t;
        ++this.air_casts;
        if (this.air_casts > 2 && player != null && this.air_casts < this.getAirCastLimit(player) && (t = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)player)).isPresent()) {
            ((SpellModifierRing)ItemInit.AIR_CAST_RING.get()).consumeMana((ItemStack)((ImmutableTriple)t.get()).right, 1.0f, player);
        }
    }

    @Override
    public int getAirJumps() {
        return this.air_jumps;
    }

    @Override
    public void incrementAirJumps(PlayerEntity source) {
        ++this.air_jumps;
    }

    @Override
    public void setAirJumps(int jumps) {
        this.air_jumps = jumps;
    }

    @Override
    public ChronoAnchorData getChronoAnchorData() {
        return this.chronoData;
    }

    @Override
    public Vector3d getLiftPosition() {
        return this.liftPosition;
    }

    @Override
    public void setLiftPosition(Vector3d pos) {
        this.liftPosition = pos;
    }

    @Override
    public boolean didAllowFlying() {
        return this.didAllowFlight;
    }

    @Override
    public void setDidAllowFlying(boolean flight) {
        this.didAllowFlight = flight;
    }

    private void sortAffinities() {
        LinkedList<Map.Entry<Affinity, Float>> list = new LinkedList<Map.Entry<Affinity, Float>>(this.affinityDepths.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Affinity, Float>>(){

            @Override
            public int compare(Map.Entry<Affinity, Float> o1, Map.Entry<Affinity, Float> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<Affinity, Float> temp = new LinkedHashMap<Affinity, Float>();
        for (Map.Entry entry : list) {
            temp.put((Affinity)((Object)entry.getKey()), (Float)entry.getValue());
        }
        this.affinityDepths = temp;
    }

    @Override
    public Map<Affinity, Float> getSortedAffinityDepths() {
        return (Map)this.affinityDepths.clone();
    }

    @Override
    public void forceSync() {
        this.forceSync(0);
    }

    @Override
    public void forceSync(int forceFlags) {
        if ((forceFlags & 1) == 1) {
            this.getCastingResource().setNeedsSync();
        }
        if ((forceFlags & 2) == 2) {
            this.syncGrimoire = true;
        }
        if ((forceFlags & 4) == 4) {
            this.syncRote = true;
        }
        this.tick_count = 10;
    }

    @Override
    public boolean canRegenerate() {
        return this.getCastingResource().getRegenerationRate() > 0;
    }

    @Override
    public void setNeedsChronoExhaustion() {
        this.needsChronoExhaustion = true;
    }

    @Override
    public SpellInventory getRoteInventory() {
        return this.roteInventory;
    }

    @Override
    public boolean getHadWizardSight() {
        return this.hadWizardSight;
    }

    @Override
    public void setHadWizardSight(boolean had) {
        this.hadWizardSight = had;
    }

    @Override
    public IPlayerCantrips getCantripData() {
        return this.cantripData;
    }

    @Override
    public int bankArmorRepair(int slot, float amount) {
        if (!this.armor_repair_accumulation.containsKey(slot)) {
            this.armor_repair_accumulation.put(slot, Float.valueOf(0.0f));
        }
        float newAmt = this.armor_repair_accumulation.get(slot).floatValue() + amount;
        int returnAmt = (int)Math.floor(newAmt);
        this.armor_repair_accumulation.put(slot, Float.valueOf(newAmt -= (float)returnAmt));
        return returnAmt;
    }

    @Override
    public HashMap<Integer, Float> getBankedArmorRepair() {
        return this.armor_repair_accumulation;
    }

    @Override
    public void setBankedArmorRepair(HashMap<Integer, Float> data) {
        this.armor_repair_accumulation = data;
    }

    @Override
    public void setModifierPressed(boolean pressed) {
        this.modifierPressed = pressed;
    }

    @Override
    public boolean isModifierPressed() {
        return this.modifierPressed;
    }

    @Override
    public ICastingResource getCastingResource() {
        return this.castingResource;
    }

    @Override
    public void setCastingResourceType(ResourceLocation rLoc) {
        if (rLoc == null || rLoc.func_110623_a() == "") {
            return;
        }
        Class<? extends ICastingResource> clazz = CastingResourceRegistry.Instance.getRegisteredClass(rLoc);
        try {
            this.castingResource = clazz.newInstance();
            this.castingResource.setMaxAmountByLevel(this.getMagicLevel());
            this.castingResource.setAmount(this.castingResource.getMaxAmount());
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Failed to set casting resource type from identifier " + rLoc.toString());
            ManaAndArtifice.LOGGER.error((Object)e);
        }
    }

    @Override
    public void validate() {
        SpellInventory spellInv = this.getRoteInventory();
        for (int i = 0; i < spellInv.getActiveSpells().length; ++i) {
            ItemStack stack = spellInv.getActiveSpells()[i];
            if (stack.func_77973_b() == ItemInit.SPELL.get()) continue;
            ItemStack replacement = new ItemStack((IItemProvider)ItemInit.SPELL.get(), 1, stack.func_77978_p());
            spellInv.func_70299_a(i, replacement);
        }
    }
}

