/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.api.cantrips.ICantrip;
import com.ma.api.capabilities.IPlayerCantrip;
import com.ma.api.capabilities.IPlayerCantrips;
import com.ma.cantrips.Cantrip;
import com.ma.cantrips.CantripRegistry;
import com.ma.capabilities.playerdata.magic.PlayerCantrip;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.inventory.InventoryCantrips;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;

public class PlayerCantrips
implements IPlayerCantrips {
    private List<IPlayerCantrip> cantrips = new ArrayList<IPlayerCantrip>();
    private boolean _needsSync = true;

    public PlayerCantrips() {
        CantripRegistry.INSTANCE.getCantrips().forEach(c -> this.cantrips.add(new PlayerCantrip((ICantrip)c)));
    }

    @Override
    @Nullable
    public ICantrip matchAndCastCantrip(PlayerEntity player, Hand hand, List<IRecipe<?>> recipes) {
        MutableInt playerTier = new MutableInt(1);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        ArrayList<ManaweavingPattern> patterns = new ArrayList<ManaweavingPattern>();
        for (IRecipe<?> recipe : recipes) {
            if (!(recipe instanceof ManaweavingPattern)) continue;
            patterns.add((ManaweavingPattern)recipe);
        }
        for (IPlayerCantrip cantrip : this.cantrips) {
            Optional<ICantrip> registeredCantrip;
            if (!cantrip.matches(patterns) || (registeredCantrip = CantripRegistry.INSTANCE.getCantrip(cantrip.getCantripID())) == null || !registeredCantrip.isPresent() || registeredCantrip.get().getTier() > playerTier.getValue()) continue;
            ((Cantrip)registeredCantrip.get()).callEffector(player, hand);
            return registeredCantrip.get();
        }
        return null;
    }

    @Override
    public CompoundNBT writeToNBT(boolean patternsOnly) {
        CompoundNBT nbt = new CompoundNBT();
        this.cantrips.forEach(c -> nbt.func_218657_a(c.getCantripID().toString(), (INBT)c.writeToNBT()));
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.cantrips.forEach(c -> {
            if (nbt.func_74764_b(c.getCantripID().toString())) {
                c.readFromNBT((CompoundNBT)nbt.func_74781_a(c.getCantripID().toString()));
            }
        });
    }

    @Override
    public void setPattern(ResourceLocation cantripID, List<ResourceLocation> manaweavingPatterns) {
        this.cantrips.stream().filter(c -> c.getCantripID().equals((Object)cantripID)).findFirst().ifPresent(c -> {
            c.setPatterns(manaweavingPatterns);
            this._needsSync = true;
        });
    }

    @Override
    public Optional<IPlayerCantrip> getCantrip(ResourceLocation cantripID) {
        return this.cantrips.stream().filter(c -> c.getCantripID().equals((Object)cantripID)).findFirst();
    }

    @Override
    public List<IPlayerCantrip> getCantrips() {
        return this.cantrips;
    }

    @Override
    public IInventory getAsInventory() {
        return new InventoryCantrips(this);
    }

    @Override
    public boolean needsSync() {
        return this._needsSync;
    }

    @Override
    public void clearSync() {
        this._needsSync = false;
    }

    @Override
    public void setNeedsSync() {
        this._needsSync = true;
    }
}

