/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic;

import com.ma.api.cantrips.ICantrip;
import com.ma.api.capabilities.IPlayerCantrip;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class PlayerCantrip
implements IPlayerCantrip {
    private ResourceLocation cantripID;
    private ItemStack stack;
    private boolean itemLocked = false;
    private ArrayList<ResourceLocation> combination;

    public PlayerCantrip(ICantrip cantrip) {
        this.cantripID = cantrip.getId();
        this.combination = new ArrayList();
        this.stack = cantrip.getDefaultStack();
        this.itemLocked = cantrip.isStackLocked();
        cantrip.getDefaultCombination().forEach(r -> this.combination.add((ResourceLocation)r));
    }

    @Override
    public ResourceLocation getCantripID() {
        return this.cantripID;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.stack.func_190926_b()) {
            CompoundNBT item = new CompoundNBT();
            this.stack.func_77955_b(item);
            nbt.func_218657_a("item", (INBT)item);
        }
        nbt.func_74768_a("count", this.combination.size());
        for (int i = 0; i < this.combination.size(); ++i) {
            nbt.func_74778_a("" + i, this.combination.get(i).toString());
        }
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("item") && !this.itemLocked) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        }
        this.combination.clear();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = new ResourceLocation(nbt.func_74779_i("" + i));
                this.combination.add(rLoc);
            }
        }
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ResourceLocation getPattern(int index) {
        if (index < 0 || index >= this.combination.size()) {
            return null;
        }
        return this.combination.get(index);
    }

    @Override
    public void setPatterns(List<ResourceLocation> manaweavingPatterns) {
        this.combination.clear();
        this.combination.addAll(manaweavingPatterns);
    }

    @Override
    public boolean matches(List<ManaweavingPattern> patterns) {
        if (patterns.size() != this.combination.size()) {
            return false;
        }
        for (int i = 0; i < this.combination.size(); ++i) {
            if (patterns.get(i).func_199560_c().equals((Object)this.combination.get(i))) continue;
            return false;
        }
        return true;
    }
}

