/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.utility;

import com.ma.blocks.BlockInit;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.utility.FillerBlock;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class WaterloggableBlockWithOffset
extends WaterloggableBlock {
    private BlockPos[] offsets;

    public WaterloggableBlockWithOffset(AbstractBlock.Properties properties, boolean startWaterlogged, BlockPos ... offsets) {
        super(properties, startWaterlogged);
        this.offsets = offsets;
    }

    public void func_220082_b(BlockState oldState, World world, BlockPos pos, BlockState newState, boolean p_220082_5_) {
        for (BlockPos offset : this.offsets) {
            BlockPos offsetPos = pos.func_177971_a((Vector3i)offset);
            if (!world.func_175623_d(offsetPos)) continue;
            FillerBlock.setAtOffsetFrom((IWorld)world, pos, offset);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        for (BlockPos offset : this.offsets) {
            BlockPos offsetPos = pos.func_177971_a((Vector3i)offset);
            BlockState offsetState = world.func_180495_p(offsetPos);
            if (offsetState.func_177230_c() != BlockInit.EMPTY_FILLER_BLOCK.get()) continue;
            world.func_175655_b(offsetPos, false);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean doDrops) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            for (BlockPos offset : this.offsets) {
                BlockPos offsetPos = pos.func_177971_a((Vector3i)offset);
                BlockState offsetState = world.func_180495_p(offsetPos);
                if (offsetState.func_177230_c() != BlockInit.EMPTY_FILLER_BLOCK.get()) continue;
                world.func_175655_b(offsetPos, false);
            }
        }
        super.func_196243_a(state, world, pos, newState, doDrops);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        for (BlockPos offset : this.offsets) {
            FluidState flState;
            BlockPos offsetPos = pos.func_177971_a((Vector3i)offset);
            if (context.func_195991_k().func_175623_d(offsetPos) || (flState = context.func_195991_k().func_204610_c(offsetPos)) != null && !flState.func_206888_e() && (flState.func_206886_c() == Fluids.field_204546_a || flState.func_206886_c() == Fluids.field_207212_b)) continue;
            return null;
        }
        return this.func_176223_P();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        this.addDestroyAtPos(state, world, pos, manager);
        for (BlockPos offset : this.offsets) {
            this.addDestroyAtPos(state, world, offset, manager);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addDestroyAtPos(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        if (state.func_177230_c() != this) {
            return;
        }
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
        voxelshape.func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
            double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
            double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
            double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_228348_3_;
                        double d8 = d5 * d2 + p_228348_5_;
                        double d9 = d6 * d3 + p_228348_7_;
                        manager.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
    }
}

