/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.google.common.collect.ImmutableList;
import com.ma.blocks.tileentities.OcculusTile;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.ModelUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class OcculusRenderer
extends TileEntityRenderer<OcculusTile> {
    private final ResourceLocation interior = new ResourceLocation("mana-and-artifice", "block/occulus_eye_shell_interior");
    private final ResourceLocation frame = new ResourceLocation("mana-and-artifice", "block/occulus_eye_shell");
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(p_228882_0_ -> RenderType.func_228630_a_((int)(p_228882_0_ + 1))).collect(ImmutableList.toImmutableList());
    private static final Random RANDOM = new Random(31100L);

    public OcculusRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(OcculusTile tileEntityIn, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        double d0 = tileEntityIn.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int i = this.getPasses(d0);
        Vector3d teDir = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        Vector3d playerPos = Minecraft.func_71410_x().field_71439_g.func_213303_ch();
        Vector3d between = playerPos.func_178788_d(teDir);
        double angle = -Math.atan2(between.field_72449_c, between.field_72450_a) / 2.0 / Math.PI * 360.0 + 90.0;
        Quaternion eyeRotation = Vector3f.field_229181_d_.func_229187_a_((float)angle);
        matrixStack.func_227860_a_();
        float translateUp = (float)Math.sin(((float)tileEntityIn.func_145831_w().func_82737_E() + partialTicks) / 40.0f) * 0.1f;
        float addedHeight = MathUtils.clamp01(0.5f - (float)(Math.sqrt(d0) / 10.0));
        float finalHeight = addedHeight / 2.0f + translateUp * addedHeight;
        matrixStack.func_227861_a_(0.5, (double)finalHeight, 0.5);
        matrixStack.func_227863_a_(eyeRotation);
        float colorMod = 0.15f;
        this.renderModelWithRandomColor(matrixStack, bufferIn.getBuffer(RENDER_TYPES.get(0)), world, pos, state, colorMod, combinedLightIn, combinedOverlayIn);
        for (int j = 1; j < i; ++j) {
            colorMod = 2.0f / (float)(18 - j);
            this.renderModelWithRandomColor(matrixStack, bufferIn.getBuffer(RENDER_TYPES.get(j)), world, pos, state, colorMod, combinedLightIn, combinedOverlayIn);
        }
        ModelUtils.renderModel(bufferIn, world, pos, state, this.frame, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private void renderModelWithRandomColor(MatrixStack stack, IVertexBuilder builder, World world, BlockPos pos, BlockState state, float colorMod, int light, int overlay) {
        float r = (RANDOM.nextFloat() * 0.5f + 0.1f) * colorMod;
        float g = (RANDOM.nextFloat() * 0.5f + 0.4f) * colorMod;
        float b = (RANDOM.nextFloat() * 0.5f + 0.5f) * colorMod;
        ModelUtils.renderModel(builder, world, pos, state, this.interior, stack, new float[]{1.0f, r, g, b}, light, overlay);
    }

    protected int getPasses(double dist) {
        if (dist > 36864.0) {
            return 1;
        }
        if (dist > 25600.0) {
            return 3;
        }
        if (dist > 16384.0) {
            return 5;
        }
        if (dist > 9216.0) {
            return 7;
        }
        if (dist > 4096.0) {
            return 9;
        }
        if (dist > 1024.0) {
            return 11;
        }
        if (dist > 576.0) {
            return 13;
        }
        return dist > 256.0 ? 14 : 15;
    }
}

