/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.ManaAndArtifice;
import com.ma.blocks.manaweaving.ManaweavingAltarBlock;
import com.ma.blocks.tileentities.ManaweavingAltarTile;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.tools.RLoc;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.ModelUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ManaweavingAltarRenderer
extends TileEntityRenderer<ManaweavingAltarTile> {
    private static final ResourceLocation SPARKLE_TEXTURE = RLoc.create("textures/particle/sparkle.png");
    private static final ResourceLocation CRYSTAL_A = RLoc.create("block/manaweaving_altar_crystal_a");
    private static final ResourceLocation CRYSTAL_B = RLoc.create("block/manaweaving_altar_crystal_b");
    private static final ResourceLocation CRYSTAL_C = RLoc.create("block/manaweaving_altar_crystal_c");
    private static final RenderType RENDER_TYPE = RenderType.func_228642_d_((ResourceLocation)SPARKLE_TEXTURE);
    private final ItemRenderer itemRenderer;
    private final EntityRendererManager renderDispatcher;
    private final FontRenderer font;

    public ManaweavingAltarRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Minecraft mc = Minecraft.func_71410_x();
        this.itemRenderer = mc.func_175599_af();
        this.renderDispatcher = mc.func_175598_ae();
        this.font = mc.field_71466_p;
    }

    public void render(ManaweavingAltarTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float yFloatA = (float)Math.sin(((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) / 40.0f) * 0.01f;
        float yFloatB = (float)Math.sin(((float)(ManaAndArtifice.instance.proxy.getGameTicks() + 40L) + partialTicks) / 40.0f) * 0.01f;
        float yFloatC = (float)Math.sin(((float)(ManaAndArtifice.instance.proxy.getGameTicks() + 80L) + partialTicks) / 40.0f) * 0.01f;
        this.renderModelExtras(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, yFloatA, yFloatB, yFloatC);
        this.renderStacks(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, partialTicks);
        this.renderPatterns(tileEntityIn, matrixStackIn, bufferIn, yFloatA, yFloatB, yFloatC);
        this.renderLastRecipe(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderModelExtras(ManaweavingAltarTile tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, float yFloatA, float yFloatB, float yFloatC) {
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        matrixStackIn.func_227860_a_();
        switch ((Direction)state.func_177229_b((Property)ManaweavingAltarBlock.FACING)) {
            case EAST: {
                matrixStackIn.func_227861_a_(1.0, 0.0, 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227861_a_(1.0, 0.0, 1.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case WEST: {
                matrixStackIn.func_227861_a_(0.0, 0.0, 1.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)yFloatA, 0.0);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_A, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)yFloatB, 0.0);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_B, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)yFloatC, 0.0);
        ModelUtils.renderModel(bufferIn, world, pos, state, CRYSTAL_C, matrixStackIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    private void renderLastRecipe(ManaweavingAltarTile tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.func_191420_l() || tileEntityIn.getAddedPatterns().size() != 0 || tileEntityIn.getReCraftOutput().func_190926_b()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x == null || mc.field_71476_x.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)mc.field_71476_x;
        if (!brtr.func_216350_a().equals((Object)tileEntityIn.func_174877_v())) {
            return;
        }
        List<ItemStack> itemstacks = tileEntityIn.getReCraftInput();
        float scale = 0.15f;
        float xStep = 1.0f;
        float xOffset = (float)(itemstacks.size() - 1) * xStep / 2.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 1.3, 0.5);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.renderString(new TranslationTextComponent("block.mana-and-artifice.manaweaving_altar.repeat").getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(this.renderDispatcher.func_229098_b_());
        matrixStackIn.func_227861_a_(0.0, -0.75, 0.0);
        this.itemRenderer.func_229110_a_(tileEntityIn.getReCraftOutput(), ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227861_a_(0.0, -0.75, 0.0);
        scale = 0.5f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        matrixStackIn.func_227861_a_((double)xOffset, 0.0, 0.0);
        for (int i = 0; i < itemstacks.size(); ++i) {
            ItemStack stack = itemstacks.get(i);
            this.itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227861_a_((double)(-xStep), 0.0, 0.0);
        }
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227861_a_(0.0, -1.95, 0.0);
        this.renderString(new TranslationTextComponent("block.mana-and-artifice.manaweaving_altar.repeat_mana_cost", new Object[]{tileEntityIn.getReCraftManaCost()}).getString(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.func_227865_b_();
    }

    protected void renderString(String text, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
        stack.func_227860_a_();
        stack.func_227863_a_(this.renderDispatcher.func_229098_b_());
        stack.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float opacity = 0.25f;
        int textColor = (int)(opacity * 255.0f) << 24;
        float hOffset = -this.font.func_78256_a(text) / 2;
        this.font.func_228079_a_(text, hOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, true, textColor, packedLight);
        this.font.func_228079_a_(text, hOffset, 0.0f, -1, false, matrix4f, buffer, false, 0, packedLight);
        stack.func_227865_b_();
    }

    private void renderStacks(ManaweavingAltarTile tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, float partialTicks) {
        ItemStack[] itemstacks = tileEntityIn.getDisplayedItems();
        for (int i = 0; i < itemstacks.length; ++i) {
            Random r = new Random((long)i * 1234L);
            if (itemstacks[i].func_190926_b()) continue;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.3, 0.5);
            Vector3d randomPos = new Vector3d(r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f), r.nextGaussian() * Math.sin((float)i / 4.5f)).func_72432_b();
            randomPos = randomPos.func_186678_a((double)0.3f);
            if (!tileEntityIn.isCrafting()) {
                matrixStackIn.func_227861_a_(randomPos.func_82615_a(), randomPos.func_82617_b(), randomPos.func_82616_c());
            } else {
                float ringAngle = (float)i * (360.0f / (float)itemstacks.length);
                float craftPct = (float)tileEntityIn.getCraftTicks() / (float)tileEntityIn.getMaxCraftTicks();
                Vector3d ringPos = new Vector3d(Math.cos(ringAngle), 0.0, Math.sin(ringAngle)).func_186678_a((double)(1.0f - craftPct));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
                if (tileEntityIn.getCraftTicks() < tileEntityIn.getMaxCraftTicks() / 5) {
                    float pct = (float)tileEntityIn.getCraftTicks() / ((float)tileEntityIn.getMaxCraftTicks() / 5.0f);
                    Vector3d lerpPos = MathUtils.lerpVector3d(randomPos, ringPos, pct);
                    matrixStackIn.func_227861_a_(lerpPos.func_82615_a(), lerpPos.func_82617_b(), lerpPos.func_82616_c());
                } else {
                    matrixStackIn.func_227861_a_(ringPos.func_82615_a(), ringPos.func_82617_b(), ringPos.func_82616_c());
                }
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks));
            matrixStackIn.func_227862_a_(0.25f, 0.25f, 0.25f);
            this.itemRenderer.func_229110_a_(itemstacks[i], ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderPatterns(ManaweavingAltarTile tileEntityIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float yFloatA, float yFloatB, float yFloatC) {
        int count = 7;
        float radius = 0.375f;
        float rotation = 0.0f;
        float rotationBase = 0.0f;
        float[] yOffsets = new float[]{0.8375f, 0.91f, 0.9525f};
        switch ((Direction)tileEntityIn.func_195044_w().func_177229_b((Property)ManaweavingAltarBlock.FACING)) {
            case SOUTH: {
                rotation = 180.0f;
                rotationBase = 180.0f;
                break;
            }
            case EAST: {
                rotation = 90.0f;
                break;
            }
            case WEST: {
                rotation = -90.0f;
                break;
            }
            default: {
                rotationBase = 180.0f;
            }
        }
        for (ManaweavingPattern pattern : tileEntityIn.getAddedPatterns()) {
            float yOffset = count == 1 || count == 7 ? yOffsets[0] + yFloatA : (count == 2 || count == 6 ? yOffsets[1] + yFloatB : yOffsets[2] + yFloatC);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
            Vector3f vec = new Vector3f(0.0f, yOffset, radius);
            vec.func_214905_a(Vector3f.field_229181_d_.func_229187_a_(rotationBase + (float)(45 * count)));
            matrixStackIn.func_227861_a_((double)(vec.func_195899_a() + 0.5f), (double)vec.func_195900_b(), (double)(vec.func_195902_c() + 0.5f));
            this.renderPattern(pattern, matrixStackIn, bufferIn, rotation);
            matrixStackIn.func_227865_b_();
            if (--count != 4) continue;
            --count;
        }
    }

    private void renderPattern(ManaweavingPattern pattern, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float rotation) {
        byte[][] points = pattern.get();
        float pointSize = 0.5f;
        float baseScale = 0.03f;
        float offsetX = (float)points.length / 2.0f * pointSize;
        float offsetY = (float)points[0].length / 2.0f * pointSize;
        Quaternion cameraRotation = Minecraft.func_71410_x().func_175598_ae().func_229098_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.2, 0.0);
        matrixStackIn.func_227862_a_(baseScale, baseScale, baseScale);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation));
        matrixStackIn.func_227863_a_(cameraRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RENDER_TYPE);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * pointSize;
                float originY = offsetY - (float)i * pointSize;
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 1.0f, 1.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 1.0f, 0.0f);
                ManaweavingAltarRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, 0.0f);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float u, float v) {
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(109, 227, 220, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF00000).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

